/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.pipeline;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.processor.channel.ChannelProtocolType;
import org.apache.rocketmq.proxy.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.netty.AttributeKeys;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class ContextInitPipeline
implements RequestPipeline {
    @Override
    public void execute(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        Channel channel = ctx.channel();
        LanguageCode languageCode = (LanguageCode)RemotingHelper.getAttributeValue((AttributeKey)AttributeKeys.LANGUAGE_CODE_KEY, (Channel)channel);
        String clientId = (String)RemotingHelper.getAttributeValue((AttributeKey)AttributeKeys.CLIENT_ID_KEY, (Channel)channel);
        Integer version = (Integer)RemotingHelper.getAttributeValue((AttributeKey)AttributeKeys.VERSION_KEY, (Channel)channel);
        context.setAction(RemotingHelper.getRequestCodeDesc((int)request.getCode())).setProtocolType(ChannelProtocolType.REMOTING.getName()).setChannel(channel).setLocalAddress(NetworkUtil.socketAddress2String((SocketAddress)ctx.channel().localAddress())).setRemoteAddress(RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel()));
        if (languageCode != null) {
            context.setLanguage(languageCode.name());
        }
        if (clientId != null) {
            context.setClientID(clientId);
        }
        if (version != null) {
            context.setClientVersion(MQVersion.getVersionDesc((int)version));
        }
    }
}

