/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.producer;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang3.StringUtils;

public class RecallMessageHandle {
    private static final String SEPARATOR = " ";
    private static final String VERSION_1 = "v1";

    public static RecallMessageHandle decodeHandle(String handle) throws DecoderException {
        String rawString;
        if (StringUtils.isEmpty((CharSequence)handle)) {
            throw new DecoderException("recall handle is invalid");
        }
        try {
            rawString = new String(Base64.getUrlDecoder().decode(handle.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            throw new DecoderException("recall handle is invalid");
        }
        String[] items = rawString.split(SEPARATOR);
        if (!VERSION_1.equals(items[0]) || items.length < 5) {
            throw new DecoderException("recall handle is invalid");
        }
        return new HandleV1(items[1], items[2], items[3], items[4]);
    }

    public static class HandleV1
    extends RecallMessageHandle {
        private String version = "v1";
        private String topic;
        private String brokerName;
        private String timestampStr;
        private String messageId;

        public HandleV1(String topic, String brokerName, String timestamp, String messageId) {
            this.topic = topic;
            this.brokerName = brokerName;
            this.timestampStr = timestamp;
            this.messageId = messageId;
        }

        public static String buildHandle(String topic, String brokerName, String timestampStr, String messageId) {
            String rawString = String.join((CharSequence)RecallMessageHandle.SEPARATOR, RecallMessageHandle.VERSION_1, topic, brokerName, timestampStr, messageId);
            return Base64.getUrlEncoder().encodeToString(rawString.getBytes(StandardCharsets.UTF_8));
        }

        public String getTopic() {
            return this.topic;
        }

        public String getBrokerName() {
            return this.brokerName;
        }

        public String getTimestampStr() {
            return this.timestampStr;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

