/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.sysflag;

import org.apache.rocketmq.common.compression.CompressionType;

public class MessageSysFlag {
    public static final int COMPRESSED_FLAG = 1;
    public static final int MULTI_TAGS_FLAG = 2;
    public static final int TRANSACTION_NOT_TYPE = 0;
    public static final int TRANSACTION_PREPARED_TYPE = 4;
    public static final int TRANSACTION_COMMIT_TYPE = 8;
    public static final int TRANSACTION_ROLLBACK_TYPE = 12;
    public static final int BORNHOST_V6_FLAG = 16;
    public static final int STOREHOSTADDRESS_V6_FLAG = 32;
    public static final int NEED_UNWRAP_FLAG = 64;
    public static final int INNER_BATCH_FLAG = 128;
    public static final int COMPRESSION_LZ4_TYPE = 256;
    public static final int COMPRESSION_ZSTD_TYPE = 512;
    public static final int COMPRESSION_ZLIB_TYPE = 768;
    public static final int COMPRESSION_TYPE_COMPARATOR = 1792;

    public static int getTransactionValue(int flag) {
        return flag & 0xC;
    }

    public static int resetTransactionValue(int flag, int type) {
        return flag & 0xFFFFFFF3 | type;
    }

    public static int clearCompressedFlag(int flag) {
        return flag & 0xFFFFFFFE;
    }

    public static CompressionType getCompressionType(int flag) {
        return CompressionType.findByValue((flag & 0x700) >> 8);
    }

    public static boolean check(int flag, int expectedFlag) {
        return (flag & expectedFlag) != 0;
    }
}

