/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.grpc.metrics.GrpcServerMetrics;
import org.apache.ratis.grpc.server.GrpcServerProtocolClient;
import org.apache.ratis.grpc.server.GrpcServicesImpl;
import org.apache.ratis.metrics.Timekeeper;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.MultipleLinearRandomRetry;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.server.leader.FollowerInfo;
import org.apache.ratis.server.leader.LeaderState;
import org.apache.ratis.server.leader.LogAppender;
import org.apache.ratis.server.leader.LogAppenderBase;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.statemachine.SnapshotInfo;
import org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ratis.thirdparty.io.grpc.stub.CallStreamObserver;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.ratis.util.AutoCloseableReadWriteLock;
import org.apache.ratis.util.BatchLogger;
import org.apache.ratis.util.CodeInjectionForTesting;
import org.apache.ratis.util.IOUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.apache.ratis.util.TimeoutExecutor;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcLogAppender
extends LogAppenderBase {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcLogAppender.class);
    public static final int INSTALL_SNAPSHOT_NOTIFICATION_INDEX = 0;
    private static final Comparator<Long> CALL_ID_COMPARATOR = (left, right) -> {
        long diff = left - right;
        return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
    };
    private final AtomicLong callId = new AtomicLong();
    private final RequestMap pendingRequests = new RequestMap();
    private final int maxPendingRequestsNum;
    private final boolean installSnapshotEnabled;
    private final TimeDuration requestTimeoutDuration;
    private final TimeDuration installSnapshotStreamTimeout;
    private final TimeDuration logMessageBatchDuration;
    private final int maxOutstandingInstallSnapshots;
    private final TimeoutExecutor scheduler = TimeoutExecutor.getInstance();
    private volatile StreamObservers appendLogRequestObserver;
    private final boolean useSeparateHBChannel;
    private final GrpcServerMetrics grpcServerMetrics;
    private final AutoCloseableReadWriteLock lock;
    private final StackTraceElement caller;
    private final RetryPolicy errorRetryWaitPolicy;
    private final ReplyState replyState = new ReplyState();

    public GrpcLogAppender(RaftServer.Division server, LeaderState leaderState, FollowerInfo f) {
        super(server, leaderState, f);
        Objects.requireNonNull(this.getServerRpc(), "getServerRpc() == null");
        RaftProperties properties = server.getRaftServer().getProperties();
        this.maxPendingRequestsNum = GrpcConfigKeys.Server.leaderOutstandingAppendsMax(properties);
        this.requestTimeoutDuration = RaftServerConfigKeys.Rpc.requestTimeout((RaftProperties)properties);
        this.maxOutstandingInstallSnapshots = GrpcConfigKeys.Server.installSnapshotRequestElementLimit(properties);
        this.installSnapshotStreamTimeout = GrpcConfigKeys.Server.installSnapshotRequestTimeout(properties).multiply((double)this.maxOutstandingInstallSnapshots);
        this.logMessageBatchDuration = GrpcConfigKeys.Server.logMessageBatchDuration(properties);
        this.installSnapshotEnabled = RaftServerConfigKeys.Log.Appender.installSnapshotEnabled((RaftProperties)properties);
        this.useSeparateHBChannel = GrpcConfigKeys.Server.heartbeatChannel(properties);
        this.grpcServerMetrics = new GrpcServerMetrics(server.getMemberId().toString());
        this.grpcServerMetrics.addPendingRequestsCount(this.getFollowerId().toString(), this.pendingRequests::logRequestsSize);
        this.lock = new AutoCloseableReadWriteLock((Object)this);
        this.caller = LOG.isTraceEnabled() ? JavaUtils.getCallerStackTraceElement() : null;
        this.errorRetryWaitPolicy = MultipleLinearRandomRetry.parseCommaSeparated((String)RaftServerConfigKeys.Log.Appender.retryPolicy((RaftProperties)properties));
    }

    public GrpcServicesImpl getServerRpc() {
        return (GrpcServicesImpl)super.getServerRpc();
    }

    private GrpcServerProtocolClient getClient() throws IOException {
        return (GrpcServerProtocolClient)this.getServerRpc().getProxies().getProxy(this.getFollowerId());
    }

    private void resetClient(AppendEntriesRequest request, Event event) {
        try (AutoCloseableLock writeLock = this.lock.writeLock(this.caller, arg_0 -> ((Logger)LOG).trace(arg_0));){
            this.getClient().resetConnectBackoff();
            if (this.appendLogRequestObserver != null) {
                this.appendLogRequestObserver.stop();
                this.appendLogRequestObserver = null;
            }
            int errorCount = this.replyState.process(event);
            this.pendingRequests.clear();
            FollowerInfo f = this.getFollower();
            long nextIndex = 1L + Optional.ofNullable(request).map(AppendEntriesRequest::getPreviousLog).map(TermIndex::getIndex).orElseGet(() -> ((FollowerInfo)f).getMatchIndex());
            if (event.isError() && request == null) {
                long followerNextIndex = f.getNextIndex();
                BatchLogger.print((BatchLogger.Key)BatchLogKey.RESET_CLIENT, (Object)(f.getId() + "-" + followerNextIndex), suffix -> LOG.warn("{}: Follower failed (request=null, errorCount={}); keep nextIndex ({}) unchanged and retry.{}", new Object[]{this, errorCount, followerNextIndex, suffix}), (TimeDuration)this.logMessageBatchDuration);
                return;
            }
            if (request != null && request.isHeartbeat()) {
                return;
            }
            this.getFollower().computeNextIndex(this.getNextIndexForError(nextIndex));
        }
        catch (IOException ie) {
            LOG.warn((Object)((Object)this) + ": Failed to getClient for " + this.getFollowerId(), (Throwable)ie);
        }
    }

    private boolean isFollowerCommitBehindLastCommitIndex() {
        return this.getRaftLog().getLastCommittedIndex() > this.getFollower().getCommitIndex();
    }

    private boolean installSnapshot() {
        if (this.installSnapshotEnabled) {
            SnapshotInfo snapshot = this.shouldInstallSnapshot();
            if (snapshot != null) {
                this.installSnapshot(snapshot);
                return true;
            }
        } else {
            TermIndex firstAvailable = this.shouldNotifyToInstallSnapshot();
            if (firstAvailable != null) {
                this.notifyInstallSnapshot(firstAvailable);
                return true;
            }
        }
        return false;
    }

    public void run() throws IOException {
        while (this.isRunning()) {
            if (this.shouldSendAppendEntries() || this.isFollowerCommitBehindLastCommitIndex()) {
                boolean installingSnapshot = this.installSnapshot();
                this.appendLog(installingSnapshot || this.haveTooManyPendingRequests());
            }
            this.getLeaderState().checkHealth(this.getFollower());
            this.mayWait();
        }
        Optional.ofNullable(this.appendLogRequestObserver).ifPresent(StreamObservers::onCompleted);
    }

    public long getWaitTimeMs() {
        if (this.haveTooManyPendingRequests()) {
            return this.getHeartbeatWaitTimeMs();
        }
        if (this.shouldSendAppendEntries() && !this.isSlowFollower()) {
            return TimeDuration.max((TimeDuration)this.getRemainingWaitTime(), (TimeDuration)TimeDuration.ZERO).toLong(TimeUnit.MILLISECONDS);
        }
        return this.getHeartbeatWaitTimeMs();
    }

    private boolean isSlowFollower() {
        TimeDuration elapsedTime = this.getFollower().getLastRpcResponseTime().elapsedTime();
        return elapsedTime.compareTo(this.getServer().properties().rpcSlownessTimeout()) > 0;
    }

    private void mayWait() {
        try {
            this.getEventAwaitForSignal().await(this.getWaitTimeMs() + this.errorWaitTimeMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)((Object)this) + ": Wait interrupted by " + ie);
            Thread.currentThread().interrupt();
        }
    }

    private long errorWaitTimeMs() {
        return this.errorRetryWaitPolicy.handleAttemptFailure(this.replyState::getErrorCount).getSleepTime().toLong(TimeUnit.MILLISECONDS);
    }

    public CompletableFuture<LifeCycle.State> stopAsync() {
        this.grpcServerMetrics.unregister();
        return super.stopAsync();
    }

    public boolean shouldSendAppendEntries() {
        return this.appendLogRequestObserver == null || super.shouldSendAppendEntries();
    }

    public boolean hasPendingDataRequests() {
        return this.pendingRequests.logRequestsSize() > 0;
    }

    private boolean haveTooManyPendingRequests() {
        int size = this.pendingRequests.logRequestsSize();
        if (size == 0) {
            return false;
        }
        if (size >= this.maxPendingRequestsNum) {
            return true;
        }
        return !this.replyState.isFirstReplyReceived();
    }

    public long getCallId() {
        return this.callId.get();
    }

    public Comparator<Long> getCallIdComparator() {
        return CALL_ID_COMPARATOR;
    }

    private void appendLog(boolean heartbeat) throws IOException {
        AppendEntriesRequest request;
        RaftProtos.AppendEntriesRequestProto pending;
        try (AutoCloseableLock writeLock = this.lock.writeLock(this.caller, arg_0 -> ((Logger)LOG).trace(arg_0));){
            pending = this.newAppendEntriesRequest(this.callId.getAndIncrement(), heartbeat);
            if (pending == null) {
                return;
            }
            request = new AppendEntriesRequest(pending, this.getFollowerId(), this.grpcServerMetrics);
            this.pendingRequests.put(request);
            this.increaseNextIndex(pending);
            if (this.appendLogRequestObserver == null) {
                this.appendLogRequestObserver = new StreamObservers(this.getClient(), new AppendLogResponseHandler(), this.useSeparateHBChannel, this.getWaitTimeMin());
            }
        }
        TimeDuration remaining = this.getRemainingWaitTime();
        if (remaining.isPositive()) {
            GrpcLogAppender.sleep(remaining, heartbeat);
        }
        if (this.isRunning()) {
            this.sendRequest(request, pending);
        }
    }

    private static void sleep(TimeDuration waitTime, boolean heartbeat) throws InterruptedIOException {
        try {
            waitTime.sleep();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw IOUtils.toInterruptedIOException((String)("Interrupted appendLog, heartbeat? " + heartbeat), (InterruptedException)e);
        }
    }

    private void sendRequest(AppendEntriesRequest request, RaftProtos.AppendEntriesRequestProto proto) throws InterruptedIOException {
        CodeInjectionForTesting.execute((String)GrpcServicesImpl.GRPC_SEND_SERVER_REQUEST, (Object)this.getServer().getId(), null, (Object[])new Object[]{proto});
        this.resetHeartbeatTrigger();
        StreamObservers observers = this.appendLogRequestObserver;
        if (observers != null) {
            request.startRequestTimer();
            observers.onNext(proto);
            this.getFollower().updateLastRpcSendTime(request.isHeartbeat());
            this.scheduler.onTimeout(this.requestTimeoutDuration, () -> this.timeoutAppendRequest(request.getCallId(), request.isHeartbeat()), LOG, () -> "Timeout check failed for append entry request: " + request);
        }
    }

    private void timeoutAppendRequest(long cid, boolean heartbeat) {
        AppendEntriesRequest pending = this.pendingRequests.remove(cid, heartbeat);
        if (pending != null) {
            int errorCount = this.replyState.process(Event.TIMEOUT);
            LOG.warn("{}: Timed out {}appendEntries, errorCount={}, request={}", new Object[]{this, heartbeat ? "HEARTBEAT " : "", errorCount, pending});
            this.grpcServerMetrics.onRequestTimeout(this.getFollowerId().toString(), heartbeat);
            pending.stopRequestTimer();
        }
    }

    private void increaseNextIndex(RaftProtos.AppendEntriesRequestProto request) {
        int count = request.getEntriesCount();
        if (count > 0) {
            this.getFollower().increaseNextIndex(request.getEntries(count - 1).getIndex() + 1L);
        }
    }

    private void increaseNextIndex(long installedSnapshotIndex, Object reason) {
        long newNextIndex = installedSnapshotIndex + 1L;
        LOG.info("{}: updateNextIndex {} for {}", new Object[]{this, newNextIndex, reason});
        this.getFollower().updateNextIndex(newNextIndex);
    }

    private void updateNextIndex(long replyNextIndex) {
        try (AutoCloseableLock writeLock = this.lock.writeLock(this.caller, arg_0 -> ((Logger)LOG).trace(arg_0));){
            this.pendingRequests.clear();
            this.getFollower().setNextIndex(replyNextIndex);
        }
    }

    private void installSnapshot(SnapshotInfo snapshot) {
        LOG.info("{}: followerNextIndex = {} but logStartIndex = {}, send snapshot {} to follower", new Object[]{this, this.getFollower().getNextIndex(), this.getRaftLog().getStartIndex(), snapshot});
        InstallSnapshotResponseHandler responseHandler = new InstallSnapshotResponseHandler();
        StreamObserver<RaftProtos.InstallSnapshotRequestProto> snapshotRequestObserver = null;
        String requestId = UUID.randomUUID().toString();
        try {
            snapshotRequestObserver = this.getClient().installSnapshot(this.getFollower().getName() + "-installSnapshot-" + requestId, this.installSnapshotStreamTimeout, this.maxOutstandingInstallSnapshots, responseHandler);
            for (RaftProtos.InstallSnapshotRequestProto request : this.newInstallSnapshotRequests(requestId, snapshot)) {
                if (!this.isRunning()) break;
                snapshotRequestObserver.onNext((Object)request);
                this.getFollower().updateLastRpcSendTime(false);
                responseHandler.addPending(request);
            }
            snapshotRequestObserver.onCompleted();
            this.grpcServerMetrics.onInstallSnapshot();
        }
        catch (Exception e) {
            LOG.warn((Object)((Object)this) + ": failed to installSnapshot " + snapshot, (Throwable)e);
            if (snapshotRequestObserver != null) {
                snapshotRequestObserver.onError((Throwable)e);
            }
            return;
        }
        responseHandler.waitForResponse();
        if (responseHandler.hasAllResponse()) {
            this.getFollower().setSnapshotIndex(snapshot.getTermIndex().getIndex());
            LOG.info("{}: installed snapshot {} successfully", (Object)this, (Object)snapshot);
        }
    }

    private void notifyInstallSnapshot(TermIndex firstAvailable) {
        LOG.info("{}: notifyInstallSnapshot with firstAvailable={}, followerNextIndex={}", new Object[]{this, firstAvailable, this.getFollower().getNextIndex()});
        InstallSnapshotResponseHandler responseHandler = new InstallSnapshotResponseHandler(true);
        StreamObserver<RaftProtos.InstallSnapshotRequestProto> snapshotRequestObserver = null;
        RaftProtos.InstallSnapshotRequestProto request = this.newInstallSnapshotNotificationRequest(firstAvailable);
        if (LOG.isInfoEnabled()) {
            LOG.info("{}: send {}", (Object)this, (Object)ServerStringUtils.toInstallSnapshotRequestString((RaftProtos.InstallSnapshotRequestProto)request));
        }
        try {
            snapshotRequestObserver = this.getClient().installSnapshot(this.getFollower().getName() + "-notifyInstallSnapshot", this.requestTimeoutDuration, 0, responseHandler);
            snapshotRequestObserver.onNext((Object)request);
            this.getFollower().updateLastRpcSendTime(false);
            responseHandler.addPending(request);
            snapshotRequestObserver.onCompleted();
        }
        catch (Exception e) {
            GrpcUtil.warn(LOG, () -> (Object)((Object)this) + ": Failed to notify follower to install snapshot.", e);
            if (snapshotRequestObserver != null) {
                snapshotRequestObserver.onError((Throwable)e);
            }
            return;
        }
        responseHandler.waitForResponse();
    }

    private TermIndex shouldNotifyToInstallSnapshot() {
        FollowerInfo follower = this.getFollower();
        long leaderNextIndex = this.getRaftLog().getNextIndex();
        boolean isFollowerBootstrapping = this.getLeaderState().isFollowerBootstrapping(follower);
        long leaderStartIndex = this.getRaftLog().getStartIndex();
        TermIndex firstAvailable = Optional.ofNullable(this.getRaftLog().getTermIndex(leaderStartIndex)).orElseGet(() -> TermIndex.valueOf((long)this.getServer().getInfo().getCurrentTerm(), (long)leaderNextIndex));
        if (isFollowerBootstrapping && !follower.hasAttemptedToInstallSnapshot()) {
            LOG.debug("{}: follower is bootstrapping, notify to install snapshot to {}.", (Object)this, (Object)firstAvailable);
            return firstAvailable;
        }
        long followerNextIndex = follower.getNextIndex();
        if (followerNextIndex >= leaderNextIndex) {
            return null;
        }
        if (followerNextIndex < leaderStartIndex) {
            return firstAvailable;
        }
        if (leaderStartIndex == -1L) {
            return firstAvailable;
        }
        return null;
    }

    static class RequestMap {
        private final Map<Long, AppendEntriesRequest> logRequests = new ConcurrentHashMap<Long, AppendEntriesRequest>();
        private final Map<Long, AppendEntriesRequest> heartbeats = new ConcurrentHashMap<Long, AppendEntriesRequest>();

        RequestMap() {
        }

        int logRequestsSize() {
            return this.logRequests.size();
        }

        void clear() {
            this.logRequests.clear();
            this.heartbeats.clear();
        }

        void put(AppendEntriesRequest request) {
            if (request.isHeartbeat()) {
                this.heartbeats.put(request.getCallId(), request);
            } else {
                this.logRequests.put(request.getCallId(), request);
            }
        }

        AppendEntriesRequest remove(RaftProtos.AppendEntriesReplyProto reply) {
            return this.remove(reply.getServerReply().getCallId(), reply.getIsHearbeat());
        }

        AppendEntriesRequest remove(long cid, boolean isHeartbeat) {
            return isHeartbeat ? this.heartbeats.remove(cid) : this.logRequests.remove(cid);
        }
    }

    static class AppendEntriesRequest {
        private final Timekeeper timer;
        private volatile Timekeeper.Context timerContext;
        private final long callId;
        private final TermIndex previousLog;
        private final int entriesCount;
        private final TermIndex firstEntry;
        private final TermIndex lastEntry;
        private volatile Timestamp sendTime;

        AppendEntriesRequest(RaftProtos.AppendEntriesRequestProto proto, RaftPeerId followerId, GrpcServerMetrics grpcServerMetrics) {
            this.callId = proto.getServerRequest().getCallId();
            this.previousLog = proto.hasPreviousLog() ? TermIndex.valueOf((RaftProtos.TermIndexProto)proto.getPreviousLog()) : null;
            this.entriesCount = proto.getEntriesCount();
            this.firstEntry = this.entriesCount > 0 ? TermIndex.valueOf((RaftProtos.LogEntryProto)proto.getEntries(0)) : null;
            this.lastEntry = this.entriesCount > 0 ? TermIndex.valueOf((RaftProtos.LogEntryProto)proto.getEntries(this.entriesCount - 1)) : null;
            this.timer = grpcServerMetrics.getGrpcLogAppenderLatencyTimer(followerId.toString(), this.isHeartbeat());
            grpcServerMetrics.onRequestCreate(this.isHeartbeat());
        }

        long getCallId() {
            return this.callId;
        }

        TermIndex getPreviousLog() {
            return this.previousLog;
        }

        long getFirstIndex() {
            return Optional.ofNullable(this.firstEntry).map(TermIndex::getIndex).orElse(-1L);
        }

        Timestamp getSendTime() {
            return this.sendTime;
        }

        void startRequestTimer() {
            this.timerContext = this.timer.time();
            this.sendTime = Timestamp.currentTime();
        }

        void stopRequestTimer() {
            this.timerContext.stop();
        }

        boolean isHeartbeat() {
            return this.entriesCount == 0;
        }

        public String toString() {
            String entries = this.entriesCount == 0 ? "" : (this.entriesCount == 1 ? ",entry=" + this.firstEntry : ",entries=" + this.firstEntry + "..." + this.lastEntry);
            return JavaUtils.getClassSimpleName(this.getClass()) + ":cid=" + this.callId + ",entriesCount=" + this.entriesCount + entries;
        }
    }

    private class InstallSnapshotResponseHandler
    implements StreamObserver<RaftProtos.InstallSnapshotReplyProto> {
        private final String name;
        private final Queue<Integer> pending;
        private final CompletableFuture<Void> done;
        private final boolean isNotificationOnly;

        InstallSnapshotResponseHandler() {
            this(false);
        }

        InstallSnapshotResponseHandler(boolean notifyOnly) {
            this.name = GrpcLogAppender.this.getFollower().getName() + "-" + JavaUtils.getClassSimpleName(this.getClass());
            this.done = new CompletableFuture();
            this.pending = new LinkedList<Integer>();
            this.isNotificationOnly = notifyOnly;
        }

        void addPending(RaftProtos.InstallSnapshotRequestProto request) {
            try (AutoCloseableLock writeLock = GrpcLogAppender.this.lock.writeLock(GrpcLogAppender.this.caller, arg_0 -> ((Logger)LOG).trace(arg_0));){
                int index;
                if (this.isNotificationOnly) {
                    Preconditions.assertSame((Object)RaftProtos.InstallSnapshotRequestProto.InstallSnapshotRequestBodyCase.NOTIFICATION, (Object)request.getInstallSnapshotRequestBodyCase(), (String)"request case");
                    index = 0;
                } else {
                    Preconditions.assertSame((Object)RaftProtos.InstallSnapshotRequestProto.InstallSnapshotRequestBodyCase.SNAPSHOTCHUNK, (Object)request.getInstallSnapshotRequestBodyCase(), (String)"request case");
                    index = request.getSnapshotChunk().getRequestIndex();
                }
                if (index == 0) {
                    Preconditions.assertTrue((boolean)this.pending.isEmpty(), (Object)"pending queue is non-empty before offer for index 0");
                }
                this.pending.offer(index);
            }
        }

        void removePending(RaftProtos.InstallSnapshotReplyProto reply) {
            try (AutoCloseableLock writeLock = GrpcLogAppender.this.lock.writeLock(GrpcLogAppender.this.caller, arg_0 -> ((Logger)LOG).trace(arg_0));){
                int index = Objects.requireNonNull(this.pending.poll(), "index == null");
                if (this.isNotificationOnly) {
                    Preconditions.assertSame((Object)RaftProtos.InstallSnapshotReplyProto.InstallSnapshotReplyBodyCase.SNAPSHOTINDEX, (Object)reply.getInstallSnapshotReplyBodyCase(), (String)"reply case");
                    Preconditions.assertSame((int)0, (int)index, (String)"poll index");
                } else {
                    Preconditions.assertSame((Object)RaftProtos.InstallSnapshotReplyProto.InstallSnapshotReplyBodyCase.REQUESTINDEX, (Object)reply.getInstallSnapshotReplyBodyCase(), (String)"reply case");
                    Preconditions.assertSame((int)reply.getRequestIndex(), (int)index, (String)"poll index");
                }
            }
        }

        void onFollowerCatchup(long followerSnapshotIndex) {
            long followerNextIndex = followerSnapshotIndex + 1L;
            long leaderStartIndex = GrpcLogAppender.this.getRaftLog().getStartIndex();
            if (followerNextIndex >= leaderStartIndex) {
                LOG.info("{}: Follower can catch up leader after install the snapshot, as leader's start index is {}", (Object)this, (Object)followerNextIndex);
                this.notifyInstallSnapshotFinished(RaftProtos.InstallSnapshotResult.SUCCESS, followerSnapshotIndex);
            }
        }

        void notifyInstallSnapshotFinished(RaftProtos.InstallSnapshotResult result, long snapshotIndex) {
            GrpcLogAppender.this.getServer().getStateMachine().event().notifySnapshotInstalled(result, snapshotIndex, GrpcLogAppender.this.getFollower().getPeer());
        }

        void waitForResponse() {
            try {
                this.done.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("Failed to complete " + this.name, e);
            }
        }

        void close() {
            this.done.complete(null);
            GrpcLogAppender.this.notifyLogAppender();
        }

        boolean hasAllResponse() {
            try (AutoCloseableLock readLock = GrpcLogAppender.this.lock.readLock(GrpcLogAppender.this.caller, arg_0 -> ((Logger)LOG).trace(arg_0));){
                boolean bl = this.pending.isEmpty();
                return bl;
            }
        }

        public void onNext(RaftProtos.InstallSnapshotReplyProto reply) {
            if (LOG.isInfoEnabled()) {
                LOG.info("{}: received {} reply {}", new Object[]{this, GrpcLogAppender.this.replyState.isFirstReplyReceived() ? "a" : "the first", ServerStringUtils.toInstallSnapshotReplyString((RaftProtos.InstallSnapshotReplyProto)reply)});
            }
            GrpcLogAppender.this.getFollower().updateLastRpcResponseTime();
            GrpcLogAppender.this.replyState.process(Event.SNAPSHOT_REPLY);
            switch (reply.getResult()) {
                case SUCCESS: {
                    LOG.info("{}: Completed InstallSnapshot. Reply: {}", (Object)this, (Object)reply);
                    GrpcLogAppender.this.getFollower().setAttemptedToInstallSnapshot();
                    this.removePending(reply);
                    break;
                }
                case IN_PROGRESS: {
                    LOG.info("{}: InstallSnapshot in progress.", (Object)this);
                    this.removePending(reply);
                    break;
                }
                case ALREADY_INSTALLED: {
                    long followerSnapshotIndex = reply.getSnapshotIndex();
                    LOG.info("{}: Follower snapshot is already at index {}.", (Object)this, (Object)followerSnapshotIndex);
                    GrpcLogAppender.this.getFollower().setSnapshotIndex(followerSnapshotIndex);
                    GrpcLogAppender.this.getFollower().setAttemptedToInstallSnapshot();
                    GrpcLogAppender.this.getLeaderState().onFollowerCommitIndex(GrpcLogAppender.this.getFollower(), followerSnapshotIndex);
                    GrpcLogAppender.this.increaseNextIndex(followerSnapshotIndex, reply.getResult());
                    this.removePending(reply);
                    break;
                }
                case NOT_LEADER: {
                    GrpcLogAppender.this.onFollowerTerm(reply.getTerm());
                    break;
                }
                case CONF_MISMATCH: {
                    LOG.error("{}: Configuration Mismatch ({}): Leader {} has it set to {} but follower {} has it set to {}", new Object[]{this, "raft.server.log.appender.install.snapshot.enabled", GrpcLogAppender.this.getServer().getId(), GrpcLogAppender.this.installSnapshotEnabled, GrpcLogAppender.this.getFollowerId(), !GrpcLogAppender.this.installSnapshotEnabled});
                    break;
                }
                case SNAPSHOT_INSTALLED: {
                    long followerSnapshotIndex = reply.getSnapshotIndex();
                    LOG.info("{}: Follower installed snapshot at index {}", (Object)this, (Object)followerSnapshotIndex);
                    GrpcLogAppender.this.getFollower().setSnapshotIndex(followerSnapshotIndex);
                    GrpcLogAppender.this.getFollower().setAttemptedToInstallSnapshot();
                    GrpcLogAppender.this.getLeaderState().onFollowerCommitIndex(GrpcLogAppender.this.getFollower(), followerSnapshotIndex);
                    GrpcLogAppender.this.increaseNextIndex(followerSnapshotIndex, reply.getResult());
                    this.onFollowerCatchup(followerSnapshotIndex);
                    this.removePending(reply);
                    break;
                }
                case SNAPSHOT_UNAVAILABLE: {
                    LOG.info("{}: Follower could not install snapshot as it is not available.", (Object)this);
                    GrpcLogAppender.this.getFollower().setAttemptedToInstallSnapshot();
                    this.notifyInstallSnapshotFinished(RaftProtos.InstallSnapshotResult.SNAPSHOT_UNAVAILABLE, -1L);
                    this.removePending(reply);
                    break;
                }
                case UNRECOGNIZED: {
                    LOG.error("Unrecognized the reply result {}: Leader is {}, follower is {}", new Object[]{reply.getResult(), GrpcLogAppender.this.getServer().getId(), GrpcLogAppender.this.getFollowerId()});
                    break;
                }
                case SNAPSHOT_EXPIRED: {
                    LOG.warn("{}: Follower could not install snapshot as it is expired.", (Object)this);
                }
            }
        }

        public void onError(Throwable t) {
            if (!GrpcLogAppender.this.isRunning()) {
                LOG.info("{} is stopped", (Object)GrpcLogAppender.this);
                return;
            }
            GrpcUtil.warn(LOG, () -> this + ": Failed InstallSnapshot", t);
            GrpcLogAppender.this.grpcServerMetrics.onRequestRetry();
            GrpcLogAppender.this.resetClient(null, Event.ERROR);
            this.close();
        }

        public void onCompleted() {
            if (!this.isNotificationOnly || LOG.isDebugEnabled()) {
                LOG.info("{}: follower responded installSnapshot COMPLETED", (Object)this);
            }
            GrpcLogAppender.this.replyState.process(Event.COMPLETE);
            this.close();
        }

        public String toString() {
            return this.name;
        }
    }

    private class AppendLogResponseHandler
    implements StreamObserver<RaftProtos.AppendEntriesReplyProto> {
        private final String name;

        private AppendLogResponseHandler() {
            this.name = GrpcLogAppender.this.getFollower().getName() + "-" + JavaUtils.getClassSimpleName(this.getClass());
        }

        public void onNext(RaftProtos.AppendEntriesReplyProto reply) {
            AppendEntriesRequest request = GrpcLogAppender.this.pendingRequests.remove(reply);
            if (request != null) {
                request.stopRequestTimer();
                GrpcLogAppender.this.getFollower().updateLastRespondedAppendEntriesSendTime(request.getSendTime());
            }
            GrpcLogAppender.this.getFollower().updateLastRpcResponseTime();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: received {} reply {}, request={}", new Object[]{this, GrpcLogAppender.this.replyState.isFirstReplyReceived() ? "a" : "the first", ServerStringUtils.toAppendEntriesReplyString((RaftProtos.AppendEntriesReplyProto)reply), request});
            }
            try {
                this.onNextImpl(request, reply);
            }
            catch (Exception t) {
                LOG.error("Failed onNext request=" + request + ", reply=" + ServerStringUtils.toAppendEntriesReplyString((RaftProtos.AppendEntriesReplyProto)reply), (Throwable)t);
            }
        }

        private void onNextImpl(AppendEntriesRequest request, RaftProtos.AppendEntriesReplyProto reply) {
            int errorCount = GrpcLogAppender.this.replyState.process(reply.getResult());
            switch (reply.getResult()) {
                case SUCCESS: {
                    GrpcLogAppender.this.grpcServerMetrics.onRequestSuccess(GrpcLogAppender.this.getFollowerId().toString(), reply.getIsHearbeat());
                    GrpcLogAppender.this.getLeaderState().onFollowerCommitIndex(GrpcLogAppender.this.getFollower(), reply.getFollowerCommit());
                    if (!GrpcLogAppender.this.getFollower().updateMatchIndex(reply.getMatchIndex())) break;
                    GrpcLogAppender.this.getFollower().updateNextIndex(reply.getMatchIndex() + 1L);
                    GrpcLogAppender.this.getLeaderState().onFollowerSuccessAppendEntries(GrpcLogAppender.this.getFollower());
                    break;
                }
                case NOT_LEADER: {
                    GrpcLogAppender.this.grpcServerMetrics.onRequestNotLeader(GrpcLogAppender.this.getFollowerId().toString());
                    LOG.warn("{}: received {} reply with term {}", new Object[]{this, reply.getResult(), reply.getTerm()});
                    if (!GrpcLogAppender.this.onFollowerTerm(reply.getTerm())) break;
                    return;
                }
                case INCONSISTENCY: {
                    GrpcLogAppender.this.grpcServerMetrics.onRequestInconsistency(GrpcLogAppender.this.getFollowerId().toString());
                    BatchLogger.print((BatchLogger.Key)BatchLogKey.INCONSISTENCY_REPLY, (Object)(GrpcLogAppender.this.getFollower().getName() + "_" + reply.getNextIndex()), suffix -> LOG.warn("{}: received {} reply with nextIndex {}, errorCount={}, request={} {}", new Object[]{this, reply.getResult(), reply.getNextIndex(), errorCount, request, suffix}));
                    long requestFirstIndex = request != null ? request.getFirstIndex() : -1L;
                    GrpcLogAppender.this.updateNextIndex(GrpcLogAppender.this.getNextIndexForInconsistency(requestFirstIndex, reply.getNextIndex()));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected reply result: " + reply.getResult());
                }
            }
            GrpcLogAppender.this.getLeaderState().onAppendEntriesReply((LogAppender)GrpcLogAppender.this, reply);
            GrpcLogAppender.this.notifyLogAppender();
        }

        public void onError(Throwable t) {
            if (!GrpcLogAppender.this.isRunning()) {
                LOG.info("{} is already stopped", (Object)GrpcLogAppender.this);
                return;
            }
            BatchLogger.print((BatchLogger.Key)BatchLogKey.APPEND_LOG_RESPONSE_HANDLER_ON_ERROR, (Object)this.name, suffix -> GrpcUtil.warn(LOG, () -> this + ": Failed appendEntries" + suffix, t), (TimeDuration)GrpcLogAppender.this.logMessageBatchDuration, (boolean)(t instanceof StatusRuntimeException));
            GrpcLogAppender.this.grpcServerMetrics.onRequestRetry();
            AppendEntriesRequest request = GrpcLogAppender.this.pendingRequests.remove(GrpcUtil.getCallId(t), GrpcUtil.isHeartbeat(t));
            GrpcLogAppender.this.resetClient(request, Event.ERROR);
        }

        public void onCompleted() {
            LOG.info("{}: follower responses appendEntries COMPLETED", (Object)this);
            GrpcLogAppender.this.resetClient(null, Event.COMPLETE);
        }

        public String toString() {
            return this.name;
        }
    }

    static class StreamObservers {
        private final CallStreamObserver<RaftProtos.AppendEntriesRequestProto> appendLog;
        private final CallStreamObserver<RaftProtos.AppendEntriesRequestProto> heartbeat;
        private final TimeDuration waitForReady;
        private volatile boolean running = true;

        StreamObservers(GrpcServerProtocolClient client, AppendLogResponseHandler handler, boolean separateHeartbeat, TimeDuration waitTimeMin) {
            this.appendLog = client.appendEntries(handler, false);
            this.heartbeat = separateHeartbeat ? client.appendEntries(handler, true) : null;
            this.waitForReady = waitTimeMin.isPositive() ? waitTimeMin : TimeDuration.ONE_MILLISECOND;
        }

        void onNext(RaftProtos.AppendEntriesRequestProto proto) throws InterruptedIOException {
            boolean isHeartBeat = this.heartbeat != null && proto.getEntriesCount() == 0;
            CallStreamObserver<RaftProtos.AppendEntriesRequestProto> stream = isHeartBeat ? this.heartbeat : this.appendLog;
            while (!stream.isReady() && this.running) {
                GrpcLogAppender.sleep(this.waitForReady, isHeartBeat);
            }
            stream.onNext((Object)proto);
        }

        void stop() {
            this.running = false;
        }

        void onCompleted() {
            this.appendLog.onCompleted();
            Optional.ofNullable(this.heartbeat).ifPresent(StreamObserver::onCompleted);
        }
    }

    static class ReplyState {
        private boolean firstReplyReceived = false;
        private int errorCount = 0;

        ReplyState() {
        }

        synchronized boolean isFirstReplyReceived() {
            return this.firstReplyReceived;
        }

        synchronized int getErrorCount() {
            return this.errorCount;
        }

        int process(RaftProtos.AppendEntriesReplyProto.AppendResult result) {
            return this.process(result == RaftProtos.AppendEntriesReplyProto.AppendResult.INCONSISTENCY ? Event.APPEND_ENTRIES_INCONSISTENCY_REPLY : Event.APPEND_ENTRIES_REPLY);
        }

        synchronized int process(Event event) {
            this.firstReplyReceived = event.updateFirstReplyReceived(this.firstReplyReceived);
            this.errorCount = event.isError() ? ++this.errorCount : 0;
            return this.errorCount;
        }
    }

    static enum Event {
        APPEND_ENTRIES_REPLY,
        APPEND_ENTRIES_INCONSISTENCY_REPLY,
        SNAPSHOT_REPLY,
        COMPLETE,
        TIMEOUT,
        ERROR;


        boolean updateFirstReplyReceived(boolean firstReplyReceived) {
            switch (this) {
                case APPEND_ENTRIES_REPLY: 
                case APPEND_ENTRIES_INCONSISTENCY_REPLY: 
                case SNAPSHOT_REPLY: 
                case COMPLETE: {
                    return true;
                }
                case ERROR: {
                    return false;
                }
                case TIMEOUT: {
                    return firstReplyReceived;
                }
            }
            throw new IllegalStateException("Unexpected event: " + (Object)((Object)this));
        }

        boolean isError() {
            switch (this) {
                case APPEND_ENTRIES_INCONSISTENCY_REPLY: 
                case ERROR: 
                case TIMEOUT: {
                    return true;
                }
                case APPEND_ENTRIES_REPLY: 
                case SNAPSHOT_REPLY: 
                case COMPLETE: {
                    return false;
                }
            }
            throw new IllegalStateException("Unexpected event: " + (Object)((Object)this));
        }
    }

    private static enum BatchLogKey implements BatchLogger.Key
    {
        RESET_CLIENT,
        INCONSISTENCY_REPLY,
        APPEND_LOG_RESPONSE_HANDLER_ON_ERROR;

    }
}

