/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileListFile;
import org.apache.hadoop.hbase.shaded.protobuf.generated.StoreFileTrackerProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.hbase.thirdparty.org.apache.commons.cli.OptionGroup;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.hbase.thirdparty.org.apache.commons.cli.PosixParser;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class StoreFileListFilePrettyPrinter
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFileListFilePrettyPrinter.class);
    private Options options = new Options();
    private final String fileOption = "f";
    private final String columnFamilyOption = "cf";
    private final String regionOption = "r";
    private final String tableNameOption = "t";
    private final String cmdString = "sft";
    private String namespace;
    private String regionName;
    private String columnFamily;
    private String tableName;
    private Path path;
    private PrintStream err = System.err;
    private PrintStream out = System.out;

    public StoreFileListFilePrettyPrinter() {
        this.init();
    }

    public StoreFileListFilePrettyPrinter(Configuration conf) {
        super(conf);
        this.init();
    }

    private void init() {
        OptionGroup files = new OptionGroup();
        this.options.addOption(new Option("t", "table", true, "Table to scan. Pass table name; e.g. test_table"));
        this.options.addOption(new Option("cf", "columnfamily", true, "column family to scan. Pass column family name; e.g. f"));
        files.addOption(new Option("r", "region", true, "Region to scan. Pass region name; e.g. '3d58e9067bf23e378e68c071f3dd39eb'"));
        files.addOption(new Option("f", "file", true, "File to scan. Pass full-path; e.g. /root/hbase-3.0.0-alpha-4-SNAPSHOT/hbase-data/data/default/tbl-sft/093fa06bf84b3b631007f951a14b8457/f/.filelist/f2.1655139542249"));
        this.options.addOptionGroup(files);
    }

    public boolean parseOptions(String[] args) throws ParseException, IOException {
        HelpFormatter formatter = new HelpFormatter();
        if (args.length == 0) {
            formatter.printHelp("sft", this.options, true);
            return false;
        }
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(this.options, args);
        if (cmd.hasOption("f")) {
            this.path = new Path(cmd.getOptionValue("f"));
        } else {
            String tableNameWtihNS;
            this.regionName = cmd.getOptionValue("r");
            if (StringUtils.isEmpty((CharSequence)this.regionName)) {
                this.err.println("Region name is not specified.");
                formatter.printHelp("sft", this.options, true);
                System.exit(1);
            }
            this.columnFamily = cmd.getOptionValue("cf");
            if (StringUtils.isEmpty((CharSequence)this.columnFamily)) {
                this.err.println("Column family is not specified.");
                formatter.printHelp("sft", this.options, true);
                System.exit(1);
            }
            if (StringUtils.isEmpty((CharSequence)(tableNameWtihNS = cmd.getOptionValue("t")))) {
                this.err.println("Table name is not specified.");
                formatter.printHelp("sft", this.options, true);
                System.exit(1);
            }
            TableName tn = TableName.valueOf((String)tableNameWtihNS);
            this.namespace = tn.getNamespaceAsString();
            this.tableName = tn.getNameAsString();
        }
        return true;
    }

    public int run(String[] args) {
        if (this.getConf() == null) {
            throw new RuntimeException("A Configuration instance must be provided.");
        }
        boolean pass = true;
        try {
            CommonFSUtils.setFsDefault((Configuration)this.getConf(), (Path)CommonFSUtils.getRootDir((Configuration)this.getConf()));
            if (!this.parseOptions(args)) {
                return 1;
            }
        }
        catch (IOException ex) {
            LOG.error("Error parsing command-line options", (Throwable)ex);
            return 1;
        }
        catch (ParseException ex) {
            LOG.error("Error parsing command-line options", (Throwable)ex);
            return 1;
        }
        FileSystem fs = null;
        if (this.path != null) {
            try {
                fs = this.path.getFileSystem(this.getConf());
                if (fs.isDirectory(this.path)) {
                    this.err.println("ERROR, wrong path given: " + this.path);
                    return 2;
                }
                return this.print(fs, this.path);
            }
            catch (IOException e) {
                LOG.error("Error reading " + this.path, (Throwable)e);
                return 2;
            }
        }
        try {
            Path root = CommonFSUtils.getRootDir((Configuration)this.getConf());
            Path baseDir = new Path(root, "data");
            Path nameSpacePath = new Path(baseDir, this.namespace);
            Path tablePath = new Path(nameSpacePath, this.tableName);
            Path regionPath = new Path(tablePath, this.regionName);
            Path cfPath = new Path(regionPath, this.columnFamily);
            Path sftPath = new Path(cfPath, ".filelist");
            fs = FileSystem.newInstance((URI)regionPath.toUri(), (Configuration)this.getConf());
            RemoteIterator iterator = fs.listFiles(sftPath, false);
            while (iterator.hasNext()) {
                LocatedFileStatus lfs = (LocatedFileStatus)iterator.next();
                if (!lfs.isFile() || !StoreFileListFile.TRACK_FILE_PATTERN.matcher(lfs.getPath().getName()).matches()) continue;
                this.out.println("Printing contents for file " + lfs.getPath().toString());
                int ret = this.print(fs, lfs.getPath());
                if (ret == 0) continue;
                pass = false;
            }
        }
        catch (IOException e) {
            LOG.error("Error processing " + e);
            return 2;
        }
        return pass ? 0 : 2;
    }

    private int print(FileSystem fs, Path path) throws IOException {
        try {
            if (!fs.exists(path)) {
                this.err.println("ERROR, file doesnt exist: " + path);
                return 2;
            }
        }
        catch (IOException e) {
            this.err.println("ERROR, reading file: " + path + e);
            return 2;
        }
        StoreFileTrackerProtos.StoreFileList storeFile = StoreFileListFile.load(fs, path);
        int end = storeFile.getStoreFileCount();
        for (int i = 0; i < end; ++i) {
            this.out.println(storeFile.getStoreFile(i).getName());
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new StoreFileListFilePrettyPrinter(), (String[])args);
        System.exit(ret);
    }
}

