/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.ipc.MetricsHBaseServer;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.util.NettyFutureUtils;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandlerContext;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundInvoker;
import org.apache.hbase.thirdparty.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NettyRpcServerRequestDecoder
extends SimpleChannelInboundHandler<ByteBuf> {
    private final MetricsHBaseServer metrics;
    private final NettyServerRpcConnection connection;

    public NettyRpcServerRequestDecoder(MetricsHBaseServer metrics, NettyServerRpcConnection connection) {
        super(false);
        this.metrics = metrics;
        this.connection = connection;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        NettyRpcServer.LOG.warn("Connection {}; caught unexpected downstream exception.", (Object)ctx.channel().remoteAddress(), (Object)e);
        NettyFutureUtils.safeClose((ChannelOutboundInvoker)ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        this.metrics.receivedBytes(msg.readableBytes() + 4);
        this.connection.process(msg);
    }
}

