/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.multitenant;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "Yarn", "Ranger", "Hive", "HBase"})
@InterfaceStability.Evolving
public interface AccessPolicy {
    public void setPolicyName(String var1);

    public String getPolicyID();

    public String getPolicyName();

    public String serializePolicyToJsonString() throws IOException;

    public String deserializePolicyFromJsonString(JsonObject var1) throws IOException;

    public AccessPolicyType getAccessPolicyType();

    public void addAccessPolicyElem(OzoneObj var1, Principal var2, IAccessAuthorizer.ACLType var3, AccessGrantType var4) throws IOException;

    public void removeAccessPolicyElem(OzoneObj var1, Principal var2, IAccessAuthorizer.ACLType var3, AccessGrantType var4) throws IOException;

    public List<AccessPolicyElem> getAccessPolicyElem();

    public void setPolicyLastUpdateTime(long var1);

    public long getPolicyLastUpdateTime();

    public HashSet<String> getRoleList();

    public static class AccessPolicyElem {
        private OzoneObj object;
        private Principal principal;
        private IAccessAuthorizer.ACLType aclType;
        private AccessGrantType grantType;

        public AccessPolicyElem(OzoneObj obj, Principal id, IAccessAuthorizer.ACLType acl, AccessGrantType grant) {
            this.object = obj;
            this.principal = id;
            this.aclType = acl;
            this.grantType = grant;
        }

        public OzoneObj getObject() {
            return this.object;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public IAccessAuthorizer.ACLType getAclType() {
            return this.aclType;
        }

        public AccessGrantType getAccessGrantType() {
            return this.grantType;
        }
    }

    public static enum AccessGrantType {
        ALLOW,
        DENY;

    }

    public static enum AccessPolicyType {
        NATIVE_ACL,
        RANGER_POLICY,
        AWS_POLICY,
        OTHER;

    }
}

