/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import com.google.protobuf.MessageLite;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OmVolumeArgs
extends WithObjectID
implements CopyObject<OmVolumeArgs>,
Auditable {
    private static final Codec<OmVolumeArgs> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.VolumeInfo.getDefaultInstance()), OmVolumeArgs::getFromProtobuf, OmVolumeArgs::getProtobuf);
    private final String adminName;
    private String ownerName;
    private final String volume;
    private long creationTime;
    private long modificationTime;
    private long quotaInBytes;
    private long quotaInNamespace;
    private long usedNamespace;
    private List<OzoneAcl> acls;
    private long refCount;

    public static Codec<OmVolumeArgs> getCodec() {
        return CODEC;
    }

    private OmVolumeArgs(String adminName, String ownerName, String volume, long quotaInBytes, long quotaInNamespace, long usedNamespace, Map<String, String> metadata, List<OzoneAcl> acls, long creationTime, long modificationTime, long objectID, long updateID, long refCount) {
        this.adminName = adminName;
        this.ownerName = ownerName;
        this.volume = volume;
        this.quotaInBytes = quotaInBytes;
        this.quotaInNamespace = quotaInNamespace;
        this.usedNamespace = usedNamespace;
        this.metadata = metadata;
        this.acls = acls;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.objectID = objectID;
        this.updateID = updateID;
        this.refCount = refCount;
    }

    public long getRefCount() {
        Preconditions.checkState((this.refCount >= 0L ? 1 : 0) != 0, (Object)"refCount should not be negative");
        return this.refCount;
    }

    public void incRefCount() {
        ++this.refCount;
    }

    public void decRefCount() {
        Preconditions.checkState((this.refCount > 0L ? 1 : 0) != 0, (Object)"refCount should not become negative");
        --this.refCount;
    }

    public void setOwnerName(String newOwner) {
        this.ownerName = newOwner;
    }

    public void setQuotaInBytes(long quotaInBytes) {
        this.quotaInBytes = quotaInBytes;
    }

    public void setQuotaInNamespace(long quotaInNamespace) {
        this.quotaInNamespace = quotaInNamespace;
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
    }

    public void setModificationTime(long time) {
        this.modificationTime = time;
    }

    public boolean addAcl(OzoneAcl ozoneAcl) {
        return OzoneAclUtil.addAcl(this.acls, ozoneAcl);
    }

    public boolean setAcls(List<OzoneAcl> ozoneAcls) {
        return OzoneAclUtil.setAcl(this.acls, ozoneAcls);
    }

    public boolean removeAcl(OzoneAcl ozoneAcl) {
        return OzoneAclUtil.removeAcl(this.acls, ozoneAcl);
    }

    public String getAdminName() {
        return this.adminName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getVolume() {
        return this.volume;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public List<OzoneAcl> getDefaultAcls() {
        ArrayList<OzoneAcl> defaultAcls = new ArrayList<OzoneAcl>();
        for (OzoneAcl acl : this.acls) {
            if (acl.getAclScope() != OzoneAcl.AclScope.DEFAULT) continue;
            defaultAcls.add(acl);
        }
        return defaultAcls;
    }

    public void incrUsedNamespace(long n) {
        this.usedNamespace += n;
    }

    public long getUsedNamespace() {
        return this.usedNamespace;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("admin", this.adminName);
        auditMap.put("owner", this.ownerName);
        auditMap.put("volume", this.volume);
        auditMap.put("creationTime", String.valueOf(this.creationTime));
        auditMap.put("modificationTime", String.valueOf(this.modificationTime));
        auditMap.put("quotaInBytes", String.valueOf(this.quotaInBytes));
        auditMap.put("quotaInNamespace", String.valueOf(this.quotaInNamespace));
        auditMap.put("usedNamespace", String.valueOf(this.usedNamespace));
        auditMap.put("objectID", String.valueOf(this.getObjectID()));
        auditMap.put("updateID", String.valueOf(this.getUpdateID()));
        return auditMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmVolumeArgs that = (OmVolumeArgs)o;
        return Objects.equals(this.objectID, that.objectID);
    }

    public int hashCode() {
        return Objects.hash(this.objectID);
    }

    public OzoneManagerProtocolProtos.VolumeInfo getProtobuf() {
        List<OzoneManagerProtocolProtos.OzoneAclInfo> aclList = OzoneAclUtil.toProtobuf(this.acls);
        return OzoneManagerProtocolProtos.VolumeInfo.newBuilder().setAdminName(this.adminName).setOwnerName(this.ownerName).setVolume(this.volume).setQuotaInBytes(this.quotaInBytes).setQuotaInNamespace(this.quotaInNamespace).setUsedNamespace(this.usedNamespace).addAllMetadata(KeyValueUtil.toProtobuf(this.metadata)).addAllVolumeAcls(aclList).setCreationTime(this.creationTime == 0L ? System.currentTimeMillis() : this.creationTime).setModificationTime(this.modificationTime).setObjectID(this.objectID).setUpdateID(this.updateID).setRefCount(this.refCount).build();
    }

    public static OmVolumeArgs getFromProtobuf(OzoneManagerProtocolProtos.VolumeInfo volInfo) {
        List<OzoneAcl> acls = OzoneAclUtil.fromProtobuf(volInfo.getVolumeAclsList());
        return new OmVolumeArgs(volInfo.getAdminName(), volInfo.getOwnerName(), volInfo.getVolume(), volInfo.getQuotaInBytes(), volInfo.getQuotaInNamespace(), volInfo.getUsedNamespace(), KeyValueUtil.getFromProtobuf(volInfo.getMetadataList()), acls, volInfo.getCreationTime(), volInfo.getModificationTime(), volInfo.getObjectID(), volInfo.getUpdateID(), volInfo.getRefCount());
    }

    @Override
    public String getObjectInfo() {
        return "OMVolumeArgs{volume='" + this.volume + '\'' + ", admin='" + this.adminName + '\'' + ", owner='" + this.ownerName + '\'' + ", creationTime='" + this.creationTime + '\'' + ", quotaInBytes='" + this.quotaInBytes + '\'' + ", usedNamespace='" + this.usedNamespace + '\'' + ", refCount='" + this.refCount + '\'' + '}';
    }

    public OmVolumeArgs copyObject() {
        HashMap<String, String> cloneMetadata = new HashMap<String, String>();
        if (this.metadata != null) {
            this.metadata.forEach((k, v) -> cloneMetadata.put((String)k, (String)v));
        }
        ArrayList<OzoneAcl> cloneAcls = new ArrayList<OzoneAcl>(this.acls.size());
        this.acls.forEach(acl -> cloneAcls.add(new OzoneAcl(acl.getType(), acl.getName(), (BitSet)acl.getAclBitSet().clone(), acl.getAclScope())));
        return new OmVolumeArgs(this.adminName, this.ownerName, this.volume, this.quotaInBytes, this.quotaInNamespace, this.usedNamespace, cloneMetadata, cloneAcls, this.creationTime, this.modificationTime, this.objectID, this.updateID, this.refCount);
    }

    public static class Builder {
        private String adminName;
        private String ownerName;
        private String volume;
        private long creationTime;
        private long modificationTime;
        private long quotaInBytes = -1L;
        private long quotaInNamespace = -1L;
        private long usedNamespace;
        private Map<String, String> metadata = new HashMap<String, String>();
        private List<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        private long objectID;
        private long updateID;
        private long refCount;

        public Builder setObjectID(long id) {
            this.objectID = id;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public Builder setAdminName(String admin) {
            this.adminName = admin;
            return this;
        }

        public Builder setOwnerName(String owner) {
            this.ownerName = owner;
            return this;
        }

        public Builder setVolume(String volumeName) {
            this.volume = volumeName;
            return this;
        }

        public Builder setCreationTime(long createdOn) {
            this.creationTime = createdOn;
            return this;
        }

        public Builder setModificationTime(long modifiedOn) {
            this.modificationTime = modifiedOn;
            return this;
        }

        public Builder setQuotaInBytes(long quotaBytes) {
            this.quotaInBytes = quotaBytes;
            return this;
        }

        public Builder setQuotaInNamespace(long quotaNamespace) {
            this.quotaInNamespace = quotaNamespace;
            return this;
        }

        public Builder setUsedNamespace(long namespaceUsage) {
            this.usedNamespace = namespaceUsage;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> additionalMetaData) {
            if (additionalMetaData != null) {
                this.metadata.putAll(additionalMetaData);
            }
            return this;
        }

        public Builder addOzoneAcls(OzoneAcl acl) {
            OzoneAclUtil.addAcl(this.acls, acl);
            return this;
        }

        public void setRefCount(long refCount) {
            Preconditions.checkState((refCount >= 0L ? 1 : 0) != 0, (Object)"refCount should not be negative");
            this.refCount = refCount;
        }

        public OmVolumeArgs build() {
            Preconditions.checkNotNull((Object)this.adminName);
            Preconditions.checkNotNull((Object)this.ownerName);
            Preconditions.checkNotNull((Object)this.volume);
            return new OmVolumeArgs(this.adminName, this.ownerName, this.volume, this.quotaInBytes, this.quotaInNamespace, this.usedNamespace, this.metadata, this.acls, this.creationTime, this.modificationTime, this.objectID, this.updateID, this.refCount);
        }
    }
}

