/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.util.NativeCrc32;

public final class NativeCRC32Wrapper {
    public static final int CHECKSUM_CRC32 = 1;
    public static final int CHECKSUM_CRC32C = 2;

    private NativeCRC32Wrapper() {
    }

    public static boolean isAvailable() {
        return NativeCrc32.isAvailable();
    }

    public static void verifyChunkedSums(int bytesPerSum, int checksumType, ByteBuffer sums, ByteBuffer data, String fileName, long basePos) throws ChecksumException {
        NativeCrc32.verifyChunkedSums((int)bytesPerSum, (int)checksumType, (ByteBuffer)sums, (ByteBuffer)data, (String)fileName, (long)basePos);
    }

    public static void verifyChunkedSumsByteArray(int bytesPerSum, int checksumType, byte[] sums, int sumsOffset, byte[] data, int dataOffset, int dataLength, String fileName, long basePos) throws ChecksumException {
        NativeCrc32.verifyChunkedSumsByteArray((int)bytesPerSum, (int)checksumType, (byte[])sums, (int)sumsOffset, (byte[])data, (int)dataOffset, (int)dataLength, (String)fileName, (long)basePos);
    }

    public static void calculateChunkedSums(int bytesPerSum, int checksumType, ByteBuffer sums, ByteBuffer data) {
        NativeCrc32.calculateChunkedSums((int)bytesPerSum, (int)checksumType, (ByteBuffer)sums, (ByteBuffer)data);
    }

    public static void calculateChunkedSumsByteArray(int bytesPerSum, int checksumType, byte[] sums, int sumsOffset, byte[] data, int dataOffset, int dataLength) {
        NativeCrc32.calculateChunkedSumsByteArray((int)bytesPerSum, (int)checksumType, (byte[])sums, (int)sumsOffset, (byte[])data, (int)dataOffset, (int)dataLength);
    }
}

