/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.util.Time;
import org.apache.ratis.util.function.CheckedRunnable;
import org.apache.ratis.util.function.CheckedSupplier;

public final class MetricUtil {
    private MetricUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T captureLatencyNs(MutableRate metric, CheckedSupplier<T, E> block) throws E {
        long start = Time.monotonicNowNanos();
        try {
            Object object = block.get();
            return (T)object;
        }
        finally {
            metric.add(Time.monotonicNowNanos() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends IOException> void captureLatencyNs(MutableRate metric, CheckedRunnable<E> block) throws IOException {
        long start = Time.monotonicNowNanos();
        try {
            block.run();
        }
        finally {
            metric.add(Time.monotonicNowNanos() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends IOException> T captureLatencyNs(Consumer<Long> latencySetter, CheckedSupplier<T, E> block) throws E {
        long start = Time.monotonicNowNanos();
        try {
            Object object = block.get();
            return (T)object;
        }
        finally {
            latencySetter.accept(Time.monotonicNowNanos() - start);
        }
    }
}

