/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;

public final class LongCodec
implements Codec<Long> {
    private static final LongCodec CODEC = new LongCodec();

    public static LongCodec get() {
        return CODEC;
    }

    private LongCodec() {
    }

    @Override
    public boolean supportCodecBuffer() {
        return true;
    }

    @Override
    public CodecBuffer toCodecBuffer(@Nonnull Long object, CodecBuffer.Allocator allocator) {
        return ((CodecBuffer)allocator.apply(8)).putLong(object);
    }

    @Override
    public Long fromCodecBuffer(@Nonnull CodecBuffer buffer) {
        return buffer.asReadOnlyByteBuffer().getLong();
    }

    @Override
    public byte[] toPersistedFormat(Long object) {
        if (object == null) {
            return null;
        }
        return ByteBuffer.wrap(new byte[8]).putLong(object).array();
    }

    @Override
    public Long fromPersistedFormat(byte[] rawData) {
        if (rawData != null) {
            return ByteBuffer.wrap(rawData).getLong();
        }
        return null;
    }

    @Override
    public Long copyObject(Long object) {
        return object;
    }
}

