/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.keys;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDDSKeyGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(HDDSKeyGenerator.class);
    private final SecurityConfig securityConfig;

    public HDDSKeyGenerator(SecurityConfig config) {
        this.securityConfig = config;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public KeyPair generateKey() throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.generateKey(this.securityConfig.getSize(), this.securityConfig.getKeyAlgo(), this.securityConfig.getProvider());
    }

    public KeyPair generateKey(int size) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.generateKey(size, this.securityConfig.getKeyAlgo(), this.securityConfig.getProvider());
    }

    public KeyPair generateKey(int size, String algorithm, String provider) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generating key pair using size:{}, Algorithm:{}, Provider:{}", new Object[]{size, algorithm, provider});
        }
        KeyPairGenerator generator = KeyPairGenerator.getInstance(algorithm, provider);
        generator.initialize(size);
        return generator.generateKeyPair();
    }
}

