/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.commons.collections.CollectionUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasClassificationDef
extends AtlasStructDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<String> superTypes;
    private Set<String> entityTypes;
    private Set<String> subTypes;

    public AtlasClassificationDef() {
        this((String)null, (String)null, (String)null, (List<AtlasStructDef.AtlasAttributeDef>)null, (Set<String>)null, (Map<String, String>)null);
    }

    public AtlasClassificationDef(String name) {
        this(name, null, null, null, null, null);
    }

    public AtlasClassificationDef(String name, String description) {
        this(name, description, null, null, null, null);
    }

    public AtlasClassificationDef(String name, String description, String typeVersion) {
        this(name, description, typeVersion, null, null, null);
    }

    public AtlasClassificationDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs) {
        this(name, description, typeVersion, attributeDefs, null, null);
    }

    public AtlasClassificationDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes) {
        this(name, description, typeVersion, attributeDefs, superTypes, null);
    }

    public AtlasClassificationDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes, Map<String, String> options) {
        this(name, description, typeVersion, attributeDefs, superTypes, null, options);
    }

    public AtlasClassificationDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes, Set<String> entityTypes, Map<String, String> options) {
        super(TypeCategory.CLASSIFICATION, name, description, typeVersion, attributeDefs, options);
        this.setSuperTypes(superTypes);
        this.setEntityTypes(entityTypes);
    }

    public AtlasClassificationDef(AtlasClassificationDef other) {
        super(other);
        this.setSuperTypes(other != null ? other.getSuperTypes() : null);
    }

    public Set<String> getSuperTypes() {
        return this.superTypes;
    }

    public void setSuperTypes(Set<String> superTypes) {
        if (superTypes != null && this.superTypes == superTypes) {
            return;
        }
        this.superTypes = CollectionUtils.isEmpty(superTypes) ? new HashSet<String>() : new HashSet<String>(superTypes);
    }

    public Set<String> getSubTypes() {
        return this.subTypes;
    }

    public void setSubTypes(Set<String> subTypes) {
        this.subTypes = subTypes;
    }

    public boolean hasSuperType(String typeName) {
        return AtlasClassificationDef.hasSuperType(this.superTypes, typeName);
    }

    public void addSuperType(String typeName) {
        Set<String> s = this.superTypes;
        if (!AtlasClassificationDef.hasSuperType(s, typeName)) {
            s = new HashSet<String>(s);
            s.add(typeName);
            this.superTypes = s;
        }
    }

    public void removeSuperType(String typeName) {
        Set<String> s = this.superTypes;
        if (AtlasClassificationDef.hasSuperType(s, typeName)) {
            s = new HashSet<String>(s);
            s.remove(typeName);
            this.superTypes = s;
        }
    }

    private static boolean hasSuperType(Set<String> superTypes, String typeName) {
        return superTypes != null && typeName != null && superTypes.contains(typeName);
    }

    public Set<String> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Set<String> entityTypes) {
        if (entityTypes != null && this.entityTypes == entityTypes) {
            return;
        }
        this.entityTypes = CollectionUtils.isEmpty(entityTypes) ? new HashSet<String>() : new HashSet<String>(entityTypes);
    }

    public boolean hasEntityType(String typeName) {
        return AtlasClassificationDef.hasEntityType(this.entityTypes, typeName);
    }

    public void addEntityType(String typeName) {
        Set<String> s = this.entityTypes;
        if (!AtlasClassificationDef.hasEntityType(s, typeName)) {
            s = new HashSet<String>(s);
            s.add(typeName);
            this.entityTypes = s;
        }
    }

    public void removeEntityType(String typeName) {
        Set<String> s = this.entityTypes;
        if (AtlasClassificationDef.hasEntityType(s, typeName)) {
            s = new HashSet<String>(s);
            s.remove(typeName);
            this.entityTypes = s;
        }
    }

    private static boolean hasEntityType(Set<String> entityTypes, String typeName) {
        return entityTypes != null && typeName != null && entityTypes.contains(typeName);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasClassificationDef{");
        super.toString(sb);
        sb.append(", superTypes=[");
        AtlasClassificationDef.dumpObjects(this.superTypes, sb);
        sb.append("], entityTypes=[");
        AtlasClassificationDef.dumpObjects(this.entityTypes, sb);
        sb.append("]");
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasClassificationDef that = (AtlasClassificationDef)o;
        return Objects.equals(this.superTypes, that.superTypes) && Objects.equals(this.entityTypes, that.entityTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.superTypes);
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasClassificationDef.class})
    public static class AtlasClassificationDefs
    extends PList<AtlasClassificationDef> {
        private static final long serialVersionUID = 1L;

        public AtlasClassificationDefs() {
        }

        public AtlasClassificationDefs(List<AtlasClassificationDef> list) {
            super(list);
        }

        public AtlasClassificationDefs(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }
}

