/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveResourceACLs;

public class HiveResourceACLsImpl
implements HiveResourceACLs {
    Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> userPermissions = new HashMap<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>>();
    Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> groupPermissions = new HashMap<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>>();

    @Override
    public Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> getUserPermissions() {
        return this.userPermissions;
    }

    @Override
    public Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> getGroupPermissions() {
        return this.groupPermissions;
    }

    public void addUserEntry(String user, HiveResourceACLs.Privilege priv, HiveResourceACLs.AccessResult result) {
        if (this.userPermissions.containsKey(user)) {
            this.userPermissions.get(user).put(priv, result);
        } else {
            EnumMap<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> entry = new EnumMap<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>(HiveResourceACLs.Privilege.class);
            entry.put(priv, result);
            this.userPermissions.put(user, entry);
        }
    }

    public void addGroupEntry(String group, HiveResourceACLs.Privilege priv, HiveResourceACLs.AccessResult result) {
        if (this.groupPermissions.containsKey(group)) {
            this.groupPermissions.get(group).put(priv, result);
        } else {
            EnumMap<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> entry = new EnumMap<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>(HiveResourceACLs.Privilege.class);
            entry.put(priv, result);
            this.groupPermissions.put(group, entry);
        }
    }
}

