/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.com.esotericsoftware.kryo.Kryo;
import org.apache.hive.com.esotericsoftware.kryo.io.Input;
import org.apache.hive.com.esotericsoftware.kryo.io.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object object) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)stream);
        Kryo kryo = SerializationUtilities.borrowKryo();
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            kryo.writeObject(output, object);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        output.close();
        return stream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserialize(byte[] buffer, Class<T> clazz) {
        Kryo kryo = SerializationUtilities.borrowKryo();
        kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
        T result = null;
        try {
            result = kryo.readObject(new Input(new ByteArrayInputStream(buffer)), clazz);
        }
        finally {
            SerializationUtilities.releaseKryo(kryo);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializeJobConf(JobConf jobConf) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            jobConf.write((DataOutput)new DataOutputStream((OutputStream)out));
        }
        catch (IOException e) {
            LOG.error("Error serializing job configuration: " + e, (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                LOG.error("Error closing output stream: " + e, (Throwable)e);
            }
        }
        return out.toByteArray();
    }

    public static JobConf deserializeJobConf(byte[] buffer) {
        JobConf conf = new JobConf();
        try {
            conf.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(buffer)));
        }
        catch (IOException e) {
            String msg = "Error de-serializing job configuration: " + e;
            throw new IllegalStateException(msg, e);
        }
        return conf;
    }
}

