/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.Node;

public class NodeUtils {
    public static <T> void iterateTask(Collection<Task<? extends Serializable>> tasks, Class<T> clazz, Function<T> function) {
        HashSet<Task> visited = new HashSet<Task>();
        while (!tasks.isEmpty()) {
            tasks = NodeUtils.iterateTask(tasks, clazz, function, visited);
        }
    }

    private static <T> Collection<Task<? extends Serializable>> iterateTask(Collection<Task<?>> tasks, Class<T> clazz, Function<T> function, Set<Task> visited) {
        ArrayList<Task<? extends Serializable>> childTasks = new ArrayList<Task<? extends Serializable>>();
        for (Task<?> task : tasks) {
            if (!visited.add(task)) continue;
            if (clazz.isInstance(task)) {
                function.apply(clazz.cast(task));
            }
            if (task.getDependentTasks() == null) continue;
            childTasks.addAll(task.getDependentTasks());
        }
        return childTasks;
    }

    public static <T> void iterate(Collection<? extends Node> nodes, Class<T> clazz, Function<T> function) {
        HashSet<Node> visited = new HashSet<Node>();
        List<Collection<? extends Node>> listNodes = Collections.singletonList(nodes);
        while (!listNodes.isEmpty()) {
            listNodes = NodeUtils.iterate(listNodes, clazz, function, visited);
        }
    }

    private static <T> List<Collection<? extends Node>> iterate(List<Collection<? extends Node>> listNodes, Class<T> clazz, Function<T> function, Set<Node> visited) {
        ArrayList<Collection<? extends Node>> childListNodes = new ArrayList<Collection<? extends Node>>();
        for (Collection<? extends Node> nodes : listNodes) {
            for (Node node : nodes) {
                if (!visited.add(node)) continue;
                if (clazz.isInstance(node)) {
                    function.apply(clazz.cast(node));
                }
                if (node.getChildren() == null) continue;
                childListNodes.add(node.getChildren());
            }
        }
        return childListNodes;
    }

    public static interface Function<T> {
        public void apply(T var1);
    }
}

