/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.jackson.datatype.joda.deser;

import io.prestosql.jdbc.$internal.jackson.core.JsonParser;
import io.prestosql.jdbc.$internal.jackson.core.JsonToken;
import io.prestosql.jdbc.$internal.jackson.databind.DeserializationContext;
import io.prestosql.jdbc.$internal.jackson.databind.JsonNode;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.cfg.FormatConfig;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.cfg.JacksonJodaPeriodFormat;
import io.prestosql.jdbc.$internal.jackson.datatype.joda.deser.JodaDeserializerBase;
import io.prestosql.jdbc.$internal.joda.time.Days;
import io.prestosql.jdbc.$internal.joda.time.Hours;
import io.prestosql.jdbc.$internal.joda.time.Minutes;
import io.prestosql.jdbc.$internal.joda.time.Months;
import io.prestosql.jdbc.$internal.joda.time.Period;
import io.prestosql.jdbc.$internal.joda.time.ReadablePeriod;
import io.prestosql.jdbc.$internal.joda.time.Seconds;
import io.prestosql.jdbc.$internal.joda.time.Weeks;
import io.prestosql.jdbc.$internal.joda.time.Years;
import java.io.IOException;

public class PeriodDeserializer
extends JodaDeserializerBase<ReadablePeriod> {
    private static final long serialVersionUID = 1L;
    private final JacksonJodaPeriodFormat _format = FormatConfig.DEFAULT_PERIOD_FORMAT;
    private final boolean _requireFullPeriod;

    public PeriodDeserializer() {
        this(true);
    }

    public PeriodDeserializer(boolean fullPeriod) {
        super(fullPeriod ? Period.class : ReadablePeriod.class);
        this._requireFullPeriod = fullPeriod;
    }

    @Override
    public ReadablePeriod deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ReadablePeriod rp;
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String str = p.getText().trim();
            if (str.isEmpty()) {
                return null;
            }
            return this._format.parsePeriod(ctxt, str);
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Period(p.getLongValue());
        }
        if (t != JsonToken.START_OBJECT && t != JsonToken.FIELD_NAME) {
            return (ReadablePeriod)ctxt.handleUnexpectedToken(this.handledType(), t, p, "expected JSON Number, String or Object", new Object[0]);
        }
        JsonNode treeNode = (JsonNode)p.readValueAsTree();
        String periodType = treeNode.path("fieldType").path("name").asText();
        String periodName = treeNode.path("periodType").path("name").asText();
        int periodValue = treeNode.path(periodType).asInt();
        if (periodName.equals("Seconds")) {
            rp = Seconds.seconds(periodValue);
        } else if (periodName.equals("Minutes")) {
            rp = Minutes.minutes(periodValue);
        } else if (periodName.equals("Hours")) {
            rp = Hours.hours(periodValue);
        } else if (periodName.equals("Days")) {
            rp = Days.days(periodValue);
        } else if (periodName.equals("Weeks")) {
            rp = Weeks.weeks(periodValue);
        } else if (periodName.equals("Months")) {
            rp = Months.months(periodValue);
        } else if (periodName.equals("Years")) {
            rp = Years.years(periodValue);
        } else {
            ctxt.reportInputMismatch(this.handledType(), "Don't know how to deserialize %s using periodName '%s'", this.handledType().getName(), periodName);
            rp = null;
        }
        if (this._requireFullPeriod && !(rp instanceof Period)) {
            rp = rp.toPeriod();
        }
        return rp;
    }
}

