/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.connector;

import io.prestosql.spi.connector.NotFoundException;
import java.util.Objects;

public class SchemaNotFoundException
extends NotFoundException {
    private final String schemaName;

    public SchemaNotFoundException(String schemaName) {
        this(schemaName, "Schema " + schemaName + " not found");
    }

    public SchemaNotFoundException(String schemaName, String message) {
        super(message);
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
    }

    public SchemaNotFoundException(String schemaName, Throwable cause) {
        this(schemaName, "Schema " + schemaName + " not found", cause);
    }

    public SchemaNotFoundException(String schemaName, String message, Throwable cause) {
        super(message, cause);
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
    }

    public String getSchemaName() {
        return this.schemaName;
    }
}

