/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.AbstractMapBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.EncoderUtil;
import io.prestosql.spi.block.MapBlock;
import io.prestosql.spi.block.MapHashTables;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSerde;
import java.util.Optional;

public class MapBlockEncoding
implements BlockEncoding {
    public static final String NAME = "MAP";
    private final TypeManager typeManager;

    public MapBlockEncoding(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        AbstractMapBlock mapBlock = (AbstractMapBlock)block;
        int positionCount = mapBlock.getPositionCount();
        int offsetBase = mapBlock.getOffsetBase();
        int[] offsets = mapBlock.getOffsets();
        Optional<int[]> hashTable = mapBlock.getHashTables().tryGet();
        int entriesStartOffset = offsets[offsetBase];
        int entriesEndOffset = offsets[offsetBase + positionCount];
        TypeSerde.writeType(sliceOutput, mapBlock.getMapType());
        blockEncodingSerde.writeBlock(sliceOutput, mapBlock.getRawKeyBlock().getRegion(entriesStartOffset, entriesEndOffset - entriesStartOffset));
        blockEncodingSerde.writeBlock(sliceOutput, mapBlock.getRawValueBlock().getRegion(entriesStartOffset, entriesEndOffset - entriesStartOffset));
        if (hashTable.isPresent()) {
            int hashTableLength = (entriesEndOffset - entriesStartOffset) * 2;
            sliceOutput.appendInt(hashTableLength);
            sliceOutput.writeBytes(Slices.wrappedIntArray((int[])hashTable.get(), (int)(entriesStartOffset * 2), (int)hashTableLength));
        } else {
            sliceOutput.appendInt(-1);
        }
        sliceOutput.appendInt(positionCount);
        for (int position = 0; position < positionCount + 1; ++position) {
            sliceOutput.writeInt(offsets[offsetBase + position] - entriesStartOffset);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        MapType mapType = (MapType)TypeSerde.readType(this.typeManager, sliceInput);
        Block keyBlock = blockEncodingSerde.readBlock(sliceInput);
        Block valueBlock = blockEncodingSerde.readBlock(sliceInput);
        int hashTableLength = sliceInput.readInt();
        int[] hashTable = null;
        if (hashTableLength >= 0) {
            hashTable = new int[hashTableLength];
            sliceInput.readBytes(Slices.wrappedIntArray((int[])hashTable));
        }
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("Deserialized MapBlock violates invariants: key %s, value %s", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        if (hashTable != null && keyBlock.getPositionCount() * 2 != hashTable.length) {
            throw new IllegalArgumentException(String.format("Deserialized MapBlock violates invariants: expected hashtable size %s, actual hashtable size %s", keyBlock.getPositionCount() * 2, hashTable.length));
        }
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        sliceInput.readBytes(Slices.wrappedIntArray((int[])offsets));
        Optional<boolean[]> mapIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        MapHashTables hashTables = new MapHashTables(mapType, Optional.ofNullable(hashTable));
        return MapBlock.createMapBlockInternal(mapType, 0, positionCount, mapIsNull, offsets, keyBlock, valueBlock, hashTables);
    }
}

