/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi;

import io.prestosql.spi.ErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Location;
import java.util.Objects;
import java.util.Optional;

public class PrestoException
extends RuntimeException {
    private final ErrorCode errorCode;
    private final Optional<Location> location;

    public PrestoException(ErrorCodeSupplier errorCode, String message) {
        this(errorCode, message, null);
    }

    public PrestoException(ErrorCodeSupplier errorCode, Throwable throwable) {
        this(errorCode, null, throwable);
    }

    public PrestoException(ErrorCodeSupplier errorCode, String message, Throwable cause) {
        this(errorCode, Optional.empty(), message, cause);
    }

    public PrestoException(ErrorCodeSupplier errorCodeSupplier, Optional<Location> location, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCodeSupplier.toErrorCode();
        this.location = Objects.requireNonNull(location, "location is null");
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Optional<Location> getLocation() {
        return this.location;
    }

    @Override
    public String getMessage() {
        String message = this.getRawMessage();
        if (this.location.isPresent()) {
            message = String.format("line %s:%s: %s", this.location.get().getLineNumber(), this.location.get().getColumnNumber(), message);
        }
        return message;
    }

    public String getRawMessage() {
        String message = super.getMessage();
        if (message == null && this.getCause() != null) {
            message = this.getCause().getMessage();
        }
        if (message == null) {
            message = this.errorCode.getName();
        }
        return message;
    }
}

