/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.PartialListing;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemOverloadScheme;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSHedgedReadMetrics;
import org.apache.hadoop.hdfs.DFSInotifyEventInputStream;
import org.apache.hadoop.hdfs.DFSOpsCountStatistics;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsPathHandle;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.token.DelegationTokenIssuer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ViewDistributedFileSystem
extends DistributedFileSystem {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewDistributedFileSystem.class);
    private ViewFileSystemOverloadScheme vfs;
    private DistributedFileSystem defaultDFS;

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        try {
            this.vfs = this.tryInitializeMountingViewFs(uri, conf);
        }
        catch (IOException ioe) {
            LOGGER.debug("Mount tree initialization failed with " + "the reason => {}. Falling back to regular DFS" + " initialization. Please re-initialize the fs after updating" + " mount point.", (Object)ioe.getMessage());
            super.initDFSClient(uri, conf);
            super.setWorkingDirectory(super.getHomeDirectory());
            return;
        }
        this.setConf(conf);
        this.defaultDFS = (DistributedFileSystem)this.vfs.getFallbackFileSystem();
        this.dfs = this.defaultDFS != null ? this.defaultDFS.dfs : null;
        super.setWorkingDirectory(this.vfs.getHomeDirectory());
    }

    @Override
    void initDFSClient(URI uri, Configuration conf) throws IOException {
    }

    private ViewFileSystemOverloadScheme tryInitializeMountingViewFs(URI theUri, Configuration conf) throws IOException {
        ViewFileSystemOverloadScheme viewFs = new ViewFileSystemOverloadScheme();
        viewFs.setSupportAutoAddingFallbackOnNoMounts(false);
        viewFs.initialize(theUri, conf);
        return viewFs;
    }

    @Override
    public URI getUri() {
        if (this.vfs == null) {
            return super.getUri();
        }
        return this.vfs.getUri();
    }

    @Override
    public String getScheme() {
        if (this.vfs == null) {
            return super.getScheme();
        }
        return this.vfs.getScheme();
    }

    @Override
    public Path getWorkingDirectory() {
        if (this.vfs == null) {
            return super.getWorkingDirectory();
        }
        return this.vfs.getWorkingDirectory();
    }

    @Override
    public void setWorkingDirectory(Path dir) {
        if (this.vfs == null) {
            super.setWorkingDirectory(dir);
            return;
        }
        this.vfs.setWorkingDirectory(dir);
    }

    @Override
    public Path getHomeDirectory() {
        if (this.dfs == null) {
            return null;
        }
        if (this.vfs == null) {
            return super.getHomeDirectory();
        }
        return this.vfs.getHomeDirectory();
    }

    @Override
    public DFSHedgedReadMetrics getHedgedReadMetrics() {
        if (this.vfs == null) {
            return super.getHedgedReadMetrics();
        }
        this.checkDefaultDFS(this.defaultDFS, "getHedgedReadMetrics");
        return this.defaultDFS.getHedgedReadMetrics();
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws IOException {
        if (this.vfs == null) {
            return super.getFileBlockLocations(fs, start, len);
        }
        return this.vfs.getFileBlockLocations(fs, start, len);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException {
        if (this.vfs == null) {
            return super.getFileBlockLocations(p, start, len);
        }
        return this.vfs.getFileBlockLocations(p, start, len);
    }

    @Override
    public void setVerifyChecksum(boolean verifyChecksum) {
        if (this.vfs == null) {
            super.setVerifyChecksum(verifyChecksum);
            return;
        }
        this.vfs.setVerifyChecksum(verifyChecksum);
    }

    @Override
    public boolean recoverLease(Path f) throws IOException {
        if (this.vfs == null) {
            return super.recoverLease(f);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(f, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "recoverLease");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).recoverLease(mountPathInfo.getPathOnTarget());
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            return super.open(f, bufferSize);
        }
        return this.vfs.open(f, bufferSize);
    }

    @Override
    public FSDataInputStream open(PathHandle fd, int bufferSize) throws IOException {
        if (this.vfs == null) {
            return super.open(fd, bufferSize);
        }
        return this.vfs.open(fd, bufferSize);
    }

    @Override
    protected HdfsPathHandle createPathHandle(FileStatus st, Options.HandleOpt ... opts) {
        if (this.vfs == null) {
            return super.createPathHandle(st, opts);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        if (this.vfs == null) {
            return super.append(f, bufferSize, progress);
        }
        return this.vfs.append(f, bufferSize, progress);
    }

    @Override
    public FSDataOutputStream append(Path f, EnumSet<CreateFlag> flag, int bufferSize, Progressable progress) throws IOException {
        if (this.vfs == null) {
            return super.append(f, flag, bufferSize, progress);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(f, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "append");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).append(mountPathInfo.getPathOnTarget(), flag, bufferSize, progress);
    }

    @Override
    public FSDataOutputStream append(Path f, EnumSet<CreateFlag> flag, int bufferSize, Progressable progress, InetSocketAddress[] favoredNodes) throws IOException {
        if (this.vfs == null) {
            return super.append(f, flag, bufferSize, progress, favoredNodes);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(f, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "append");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).append(mountPathInfo.getPathOnTarget(), flag, bufferSize, progress, favoredNodes);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.vfs == null) {
            return super.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
        }
        return this.vfs.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public HdfsDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress, InetSocketAddress[] favoredNodes) throws IOException {
        if (this.vfs == null) {
            return super.create(f, permission, overwrite, bufferSize, replication, blockSize, progress, favoredNodes);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(f, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "create");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).create(mountPathInfo.getPathOnTarget(), permission, overwrite, bufferSize, replication, blockSize, progress, favoredNodes);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> cflags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        if (this.vfs == null) {
            return super.create(f, permission, cflags, bufferSize, replication, blockSize, progress, checksumOpt);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(f, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "create");
        return ((FileSystem)mountPathInfo.getTargetFs()).create(mountPathInfo.getPathOnTarget(), permission, cflags, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    void checkDFS(FileSystem fs, String methodName) {
        if (!(fs instanceof DistributedFileSystem)) {
            String msg = "This API:" + methodName + " is specific to DFS. Can't run on other fs:" + fs.getUri();
            throw new UnsupportedOperationException(msg);
        }
    }

    void checkDefaultDFS(FileSystem fs, String methodName) {
        if (fs == null) {
            String msg = "This API:" + methodName + " cannot be supported without default cluster(that is linkFallBack).";
            throw new UnsupportedOperationException(msg);
        }
    }

    @Override
    protected HdfsDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        if (this.vfs == null) {
            return super.primitiveCreate(f, absolutePermission, (EnumSet)flag, bufferSize, replication, blockSize, progress, checksumOpt);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(f, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "primitiveCreate");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).primitiveCreate(f, absolutePermission, (EnumSet)flag, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        if (this.vfs == null) {
            return super.createNonRecursive(f, permission, flags, bufferSize, replication, bufferSize, progress);
        }
        return this.vfs.createNonRecursive(f, permission, flags, bufferSize, replication, (long)bufferSize, progress);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            return super.setReplication(f, replication);
        }
        return this.vfs.setReplication(f, replication);
    }

    @Override
    public void setStoragePolicy(Path src, String policyName) throws IOException {
        if (this.vfs == null) {
            super.setStoragePolicy(src, policyName);
            return;
        }
        this.vfs.setStoragePolicy(src, policyName);
    }

    @Override
    public void unsetStoragePolicy(Path src) throws IOException {
        if (this.vfs == null) {
            super.unsetStoragePolicy(src);
            return;
        }
        this.vfs.unsetStoragePolicy(src);
    }

    @Override
    public BlockStoragePolicySpi getStoragePolicy(Path src) throws IOException {
        if (this.vfs == null) {
            return super.getStoragePolicy(src);
        }
        return this.vfs.getStoragePolicy(src);
    }

    @Override
    public Collection<BlockStoragePolicy> getAllStoragePolicies() throws IOException {
        if (this.vfs == null) {
            return super.getAllStoragePolicies();
        }
        Collection allStoragePolicies = this.vfs.getAllStoragePolicies();
        return allStoragePolicies;
    }

    @Override
    public long getBytesWithFutureGenerationStamps() throws IOException {
        if (this.vfs == null) {
            return super.getBytesWithFutureGenerationStamps();
        }
        this.checkDefaultDFS(this.defaultDFS, "getBytesWithFutureGenerationStamps");
        return this.defaultDFS.getBytesWithFutureGenerationStamps();
    }

    @Override
    @Deprecated
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        if (this.vfs == null) {
            return super.getStoragePolicies();
        }
        this.checkDefaultDFS(this.defaultDFS, "getStoragePolicies");
        return this.defaultDFS.getStoragePolicies();
    }

    @Override
    public void concat(Path trg, Path[] psrcs) throws IOException {
        if (this.vfs == null) {
            super.concat(trg, psrcs);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(trg, this.getConf());
        ((FileSystem)mountPathInfo.getTargetFs()).concat(mountPathInfo.getPathOnTarget(), psrcs);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        if (this.vfs == null) {
            return super.rename(src, dst);
        }
        return this.vfs.rename(src, dst);
    }

    @Override
    public void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        if (this.vfs == null) {
            super.rename(src, dst, options);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountSrcPathInfo = this.vfs.getMountPathInfo(src, this.getConf());
        ViewFileSystemOverloadScheme.MountPathInfo mountDstPathInfo = this.vfs.getMountPathInfo(dst, this.getConf());
        if (!((FileSystem)mountSrcPathInfo.getTargetFs()).getUri().equals(((FileSystem)mountDstPathInfo.getTargetFs()).getUri())) {
            throw new HadoopIllegalArgumentException("Can't rename across file systems.");
        }
        FileUtil.rename((FileSystem)((FileSystem)mountSrcPathInfo.getTargetFs()), (Path)mountSrcPathInfo.getPathOnTarget(), (Path)mountDstPathInfo.getPathOnTarget(), (Options.Rename[])options);
    }

    @Override
    public boolean truncate(Path f, long newLength) throws IOException {
        if (this.vfs == null) {
            return super.truncate(f, newLength);
        }
        return this.vfs.truncate(f, newLength);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            return super.delete(f, recursive);
        }
        return this.vfs.delete(f, recursive);
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        if (this.vfs == null) {
            return super.getContentSummary(f);
        }
        return this.vfs.getContentSummary(f);
    }

    @Override
    public QuotaUsage getQuotaUsage(Path f) throws IOException {
        if (this.vfs == null) {
            return super.getQuotaUsage(f);
        }
        return this.vfs.getQuotaUsage(f);
    }

    @Override
    public void setQuota(Path src, long namespaceQuota, long storagespaceQuota) throws IOException {
        if (this.vfs == null) {
            super.setQuota(src, namespaceQuota, storagespaceQuota);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(src, this.getConf());
        ((FileSystem)mountPathInfo.getTargetFs()).setQuota(mountPathInfo.getPathOnTarget(), namespaceQuota, storagespaceQuota);
    }

    @Override
    public void setQuotaByStorageType(Path src, StorageType type, long quota) throws IOException {
        if (this.vfs == null) {
            super.setQuotaByStorageType(src, type, quota);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(src, this.getConf());
        ((FileSystem)mountPathInfo.getTargetFs()).setQuotaByStorageType(mountPathInfo.getPathOnTarget(), type, quota);
    }

    @Override
    public FileStatus[] listStatus(Path p) throws IOException {
        if (this.vfs == null) {
            return super.listStatus(p);
        }
        return this.vfs.listStatus(p);
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f, PathFilter filter) throws FileNotFoundException, IOException {
        if (this.vfs == null) {
            return super.listLocatedStatus(f, filter);
        }
        return this.vfs.listLocatedStatus(f, filter);
    }

    @Override
    public RemoteIterator<FileStatus> listStatusIterator(Path p) throws IOException {
        if (this.vfs == null) {
            return super.listStatusIterator(p);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(p, this.getConf());
        return ((FileSystem)mountPathInfo.getTargetFs()).listStatusIterator(mountPathInfo.getPathOnTarget());
    }

    @Override
    public RemoteIterator<PartialListing<FileStatus>> batchedListStatusIterator(List<Path> paths) throws IOException {
        if (this.vfs == null) {
            return super.batchedListStatusIterator(paths);
        }
        return this.defaultDFS.batchedListStatusIterator(paths);
    }

    @Override
    public RemoteIterator<PartialListing<LocatedFileStatus>> batchedListLocatedStatusIterator(List<Path> paths) throws IOException {
        if (this.vfs == null) {
            return super.batchedListLocatedStatusIterator(paths);
        }
        return this.defaultDFS.batchedListLocatedStatusIterator(paths);
    }

    @Override
    public boolean mkdir(Path f, FsPermission permission) throws IOException {
        if (this.vfs == null) {
            return super.mkdir(f, permission);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(f, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "mkdir");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).mkdir(mountPathInfo.getPathOnTarget(), permission);
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        if (this.vfs == null) {
            return super.mkdirs(f, permission);
        }
        return this.vfs.mkdirs(f, permission);
    }

    @Override
    protected boolean primitiveMkdir(Path f, FsPermission absolutePermission) throws IOException {
        if (this.vfs == null) {
            return super.primitiveMkdir(f, absolutePermission);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(f, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "primitiveMkdir");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).primitiveMkdir(mountPathInfo.getPathOnTarget(), absolutePermission);
    }

    @Override
    public void close() throws IOException {
        if (this.vfs != null) {
            this.vfs.close();
        }
        super.close();
    }

    @Override
    @InterfaceAudience.Private
    public DFSClient getClient() {
        if (this.vfs == null) {
            return super.getClient();
        }
        this.checkDefaultDFS(this.defaultDFS, "getClient");
        return this.defaultDFS.getClient();
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        if (this.vfs == null) {
            return super.getStatus(p);
        }
        return this.vfs.getStatus(p);
    }

    @Override
    public long getMissingBlocksCount() throws IOException {
        if (this.vfs == null) {
            return super.getMissingBlocksCount();
        }
        this.checkDefaultDFS(this.defaultDFS, "getMissingBlocksCount");
        return this.defaultDFS.getMissingBlocksCount();
    }

    @Override
    public long getPendingDeletionBlocksCount() throws IOException {
        if (this.vfs == null) {
            return super.getPendingDeletionBlocksCount();
        }
        this.checkDefaultDFS(this.defaultDFS, "getPendingDeletionBlocksCount");
        return this.defaultDFS.getPendingDeletionBlocksCount();
    }

    @Override
    public long getMissingReplOneBlocksCount() throws IOException {
        if (this.vfs == null) {
            return super.getMissingReplOneBlocksCount();
        }
        this.checkDefaultDFS(this.defaultDFS, "getMissingReplOneBlocksCount");
        return this.defaultDFS.getMissingReplOneBlocksCount();
    }

    @Override
    public long getLowRedundancyBlocksCount() throws IOException {
        if (this.vfs == null) {
            return super.getLowRedundancyBlocksCount();
        }
        this.checkDefaultDFS(this.defaultDFS, "getLowRedundancyBlocksCount");
        return this.defaultDFS.getLowRedundancyBlocksCount();
    }

    @Override
    public long getCorruptBlocksCount() throws IOException {
        if (this.vfs == null) {
            return super.getCorruptBlocksCount();
        }
        this.checkDefaultDFS(this.defaultDFS, "getCorruptBlocksCount");
        return this.defaultDFS.getLowRedundancyBlocksCount();
    }

    @Override
    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        if (this.vfs == null) {
            return super.listCorruptFileBlocks(path);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        return ((FileSystem)mountPathInfo.getTargetFs()).listCorruptFileBlocks(mountPathInfo.getPathOnTarget());
    }

    @Override
    public DatanodeInfo[] getDataNodeStats() throws IOException {
        if (this.vfs == null) {
            return super.getDataNodeStats();
        }
        this.checkDefaultDFS(this.defaultDFS, "getDataNodeStats");
        return this.defaultDFS.getDataNodeStats();
    }

    @Override
    public DatanodeInfo[] getDataNodeStats(HdfsConstants.DatanodeReportType type) throws IOException {
        if (this.vfs == null) {
            return super.getDataNodeStats(type);
        }
        this.checkDefaultDFS(this.defaultDFS, "getDataNodeStats");
        return this.defaultDFS.getDataNodeStats(type);
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        if (this.vfs == null) {
            return super.setSafeMode(action);
        }
        this.checkDefaultDFS(this.defaultDFS, "setSafeMode");
        return this.defaultDFS.setSafeMode(action);
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        if (this.vfs == null) {
            return super.setSafeMode(action, isChecked);
        }
        this.checkDefaultDFS(this.defaultDFS, "setSafeMode");
        return this.defaultDFS.setSafeMode(action, isChecked);
    }

    @Override
    public boolean saveNamespace(long timeWindow, long txGap) throws IOException {
        if (this.vfs == null) {
            return super.saveNamespace(timeWindow, txGap);
        }
        this.checkDefaultDFS(this.defaultDFS, "saveNamespace");
        return this.defaultDFS.saveNamespace(timeWindow, txGap);
    }

    @Override
    public void saveNamespace() throws IOException {
        if (this.vfs == null) {
            super.saveNamespace();
            return;
        }
        this.checkDefaultDFS(this.defaultDFS, "saveNamespace");
        this.defaultDFS.saveNamespace();
    }

    @Override
    public long rollEdits() throws IOException {
        if (this.vfs == null) {
            return super.rollEdits();
        }
        this.checkDefaultDFS(this.defaultDFS, "rollEdits");
        return this.defaultDFS.rollEdits();
    }

    @Override
    public boolean restoreFailedStorage(String arg) throws IOException {
        if (this.vfs == null) {
            return super.restoreFailedStorage(arg);
        }
        this.checkDefaultDFS(this.defaultDFS, "restoreFailedStorage");
        return this.defaultDFS.restoreFailedStorage(arg);
    }

    @Override
    public void refreshNodes() throws IOException {
        if (this.vfs == null) {
            super.refreshNodes();
            return;
        }
        this.checkDefaultDFS(this.defaultDFS, "refreshNodes");
        this.defaultDFS.refreshNodes();
    }

    @Override
    public void finalizeUpgrade() throws IOException {
        if (this.vfs == null) {
            super.finalizeUpgrade();
            return;
        }
        this.checkDefaultDFS(this.defaultDFS, "finalizeUpgrade");
        this.defaultDFS.finalizeUpgrade();
    }

    @Override
    public boolean upgradeStatus() throws IOException {
        if (this.vfs == null) {
            return super.upgradeStatus();
        }
        this.checkDefaultDFS(this.defaultDFS, "upgradeStatus");
        return this.defaultDFS.upgradeStatus();
    }

    @Override
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        if (this.vfs == null) {
            return super.rollingUpgrade(action);
        }
        this.checkDefaultDFS(this.defaultDFS, "rollingUpgrade");
        return this.defaultDFS.rollingUpgrade(action);
    }

    @Override
    public void metaSave(String pathname) throws IOException {
        if (this.vfs == null) {
            super.metaSave(pathname);
            return;
        }
        this.checkDefaultDFS(this.defaultDFS, "metaSave");
        this.defaultDFS.metaSave(pathname);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        if (this.vfs == null) {
            return super.getServerDefaults();
        }
        this.checkDefaultDFS(this.defaultDFS, "getServerDefaults");
        return this.defaultDFS.getServerDefaults();
    }

    @Override
    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            return super.getFileStatus(f);
        }
        return this.vfs.getFileStatus(f);
    }

    @Override
    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        if (this.vfs == null) {
            super.createSymlink(target, link, createParent);
            return;
        }
        throw new UnsupportedOperationException("createSymlink is not supported in ViewHDFS");
    }

    @Override
    public boolean supportsSymlinks() {
        if (this.vfs == null) {
            return super.supportsSymlinks();
        }
        return false;
    }

    @Override
    public FileStatus getFileLinkStatus(Path f) throws IOException {
        if (this.vfs == null) {
            return super.getFileLinkStatus(f);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(f, this.getConf());
        return ((FileSystem)mountPathInfo.getTargetFs()).getFileLinkStatus(mountPathInfo.getPathOnTarget());
    }

    @Override
    public Path getLinkTarget(Path path) throws IOException {
        if (this.vfs == null) {
            return super.getLinkTarget(path);
        }
        return this.vfs.getLinkTarget(path);
    }

    @Override
    protected Path resolveLink(Path f) throws IOException {
        if (this.vfs == null) {
            return super.resolveLink(f);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(f, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "resolveLink");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).resolveLink(mountPathInfo.getPathOnTarget());
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            return super.getFileChecksum(f);
        }
        return this.vfs.getFileChecksum(f);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            super.setPermission(f, permission);
            return;
        }
        this.vfs.setPermission(f, permission);
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            super.setOwner(f, username, groupname);
            return;
        }
        this.vfs.setOwner(f, username, groupname);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            super.setTimes(f, mtime, atime);
            return;
        }
        this.vfs.setTimes(f, mtime, atime);
    }

    @Override
    protected int getDefaultPort() {
        return super.getDefaultPort();
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        if (this.vfs == null) {
            return super.getDelegationToken(renewer);
        }
        if (this.defaultDFS != null) {
            return this.defaultDFS.getDelegationToken(renewer);
        }
        return null;
    }

    @Override
    public void setBalancerBandwidth(long bandwidth) throws IOException {
        if (this.vfs == null) {
            super.setBalancerBandwidth(bandwidth);
            return;
        }
        this.checkDefaultDFS(this.defaultDFS, "setBalancerBandwidth");
        this.defaultDFS.setBalancerBandwidth(bandwidth);
    }

    @Override
    public String getCanonicalServiceName() {
        if (this.vfs == null) {
            return super.getCanonicalServiceName();
        }
        this.checkDefaultDFS(this.defaultDFS, "getCanonicalServiceName");
        return this.defaultDFS.getCanonicalServiceName();
    }

    @Override
    protected URI canonicalizeUri(URI uri) {
        if (this.vfs == null) {
            return super.canonicalizeUri(uri);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = null;
        try {
            mountPathInfo = this.vfs.getMountPathInfo(new Path(uri), this.getConf());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to resolve the uri as mount path", (Throwable)e);
            return null;
        }
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "canonicalizeUri");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).canonicalizeUri(uri);
    }

    @Override
    public boolean isInSafeMode() throws IOException {
        if (this.vfs == null) {
            return super.isInSafeMode();
        }
        this.checkDefaultDFS(this.defaultDFS, "isInSafeMode");
        return this.defaultDFS.isInSafeMode();
    }

    @Override
    public void allowSnapshot(Path path) throws IOException {
        if (this.vfs == null) {
            super.allowSnapshot(path);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "allowSnapshot");
        ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).allowSnapshot(mountPathInfo.getPathOnTarget());
    }

    @Override
    public void disallowSnapshot(Path path) throws IOException {
        if (this.vfs == null) {
            super.disallowSnapshot(path);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "disallowSnapshot");
        ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).disallowSnapshot(mountPathInfo.getPathOnTarget());
    }

    @Override
    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        if (this.vfs == null) {
            return super.createSnapshot(path, snapshotName);
        }
        return this.vfs.createSnapshot(path, snapshotName);
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        if (this.vfs == null) {
            super.renameSnapshot(path, snapshotOldName, snapshotNewName);
            return;
        }
        this.vfs.renameSnapshot(path, snapshotOldName, snapshotNewName);
    }

    @Override
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        if (this.vfs == null) {
            return super.getSnapshottableDirListing();
        }
        this.checkDefaultDFS(this.defaultDFS, "getSnapshottableDirListing");
        return this.defaultDFS.getSnapshottableDirListing();
    }

    @Override
    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        if (this.vfs == null) {
            super.deleteSnapshot(path, snapshotName);
            return;
        }
        this.vfs.deleteSnapshot(path, snapshotName);
    }

    @Override
    public RemoteIterator<SnapshotDiffReportListing> snapshotDiffReportListingRemoteIterator(Path snapshotDir, String fromSnapshot, String toSnapshot) throws IOException {
        if (this.vfs == null) {
            return super.snapshotDiffReportListingRemoteIterator(snapshotDir, fromSnapshot, toSnapshot);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(snapshotDir, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "snapshotDiffReportListingRemoteIterator");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).snapshotDiffReportListingRemoteIterator(mountPathInfo.getPathOnTarget(), fromSnapshot, toSnapshot);
    }

    @Override
    public SnapshotDiffReport getSnapshotDiffReport(Path snapshotDir, String fromSnapshot, String toSnapshot) throws IOException {
        if (this.vfs == null) {
            return super.getSnapshotDiffReport(snapshotDir, fromSnapshot, toSnapshot);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(snapshotDir, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "getSnapshotDiffReport");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).getSnapshotDiffReport(mountPathInfo.getPathOnTarget(), fromSnapshot, toSnapshot);
    }

    @Override
    public boolean isFileClosed(Path src) throws IOException {
        if (this.vfs == null) {
            return super.isFileClosed(src);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(src, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "isFileClosed");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).isFileClosed(mountPathInfo.getPathOnTarget());
    }

    @Override
    public long addCacheDirective(CacheDirectiveInfo info) throws IOException {
        if (this.vfs == null) {
            return super.addCacheDirective(info);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(info.getPath(), this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "addCacheDirective");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).addCacheDirective(new CacheDirectiveInfo.Builder(info).setPath(mountPathInfo.getPathOnTarget()).build());
    }

    @Override
    public long addCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        if (this.vfs == null) {
            return super.addCacheDirective(info, flags);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(info.getPath(), this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "addCacheDirective");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).addCacheDirective(new CacheDirectiveInfo.Builder(info).setPath(mountPathInfo.getPathOnTarget()).build(), flags);
    }

    @Override
    public void modifyCacheDirective(CacheDirectiveInfo info) throws IOException {
        if (this.vfs == null) {
            super.modifyCacheDirective(info);
            return;
        }
        if (info.getPath() != null) {
            ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(info.getPath(), this.getConf());
            this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "modifyCacheDirective");
            ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).modifyCacheDirective(new CacheDirectiveInfo.Builder(info).setPath(mountPathInfo.getPathOnTarget()).build());
            return;
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                dfs.modifyCacheDirective(info);
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
    }

    @Override
    public void modifyCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        if (this.vfs == null) {
            super.modifyCacheDirective(info, flags);
            return;
        }
        if (info.getPath() != null) {
            ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(info.getPath(), this.getConf());
            this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "modifyCacheDirective");
            ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).modifyCacheDirective(new CacheDirectiveInfo.Builder(info).setPath(mountPathInfo.getPathOnTarget()).build(), flags);
            return;
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                dfs.modifyCacheDirective(info, flags);
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
    }

    @Override
    public void removeCacheDirective(long id) throws IOException {
        if (this.vfs == null) {
            super.removeCacheDirective(id);
            return;
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                dfs.removeCacheDirective(id);
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
    }

    @Override
    public RemoteIterator<CacheDirectiveEntry> listCacheDirectives(CacheDirectiveInfo filter) throws IOException {
        if (this.vfs == null) {
            return super.listCacheDirectives(filter);
        }
        if (filter != null && filter.getPath() != null) {
            ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(filter.getPath(), this.getConf());
            this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "listCacheDirectives");
            return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).listCacheDirectives(new CacheDirectiveInfo.Builder(filter).setPath(mountPathInfo.getPathOnTarget()).build());
        }
        final ArrayList<RemoteIterator<CacheDirectiveEntry>> iters = new ArrayList<RemoteIterator<CacheDirectiveEntry>>();
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            iters.add(((DistributedFileSystem)fs).listCacheDirectives(filter));
        }
        if (iters.size() == 0) {
            throw new UnsupportedOperationException("No DFS found in child fs. This API can't be supported in non DFS");
        }
        return new RemoteIterator<CacheDirectiveEntry>(){
            int currIdx = 0;
            RemoteIterator<CacheDirectiveEntry> currIter = (RemoteIterator)iters.get(this.currIdx++);

            public boolean hasNext() throws IOException {
                if (this.currIter.hasNext()) {
                    return true;
                }
                while (this.currIdx < iters.size()) {
                    this.currIter = (RemoteIterator)iters.get(this.currIdx++);
                    if (!this.currIter.hasNext()) continue;
                    return true;
                }
                return false;
            }

            public CacheDirectiveEntry next() throws IOException {
                if (this.hasNext()) {
                    return (CacheDirectiveEntry)this.currIter.next();
                }
                throw new NoSuchElementException("No more elements");
            }
        };
    }

    @Override
    public void addCachePool(CachePoolInfo info) throws IOException {
        if (this.vfs == null) {
            super.addCachePool(info);
            return;
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                dfs.addCachePool(info);
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
    }

    @Override
    public void modifyCachePool(CachePoolInfo info) throws IOException {
        if (this.vfs == null) {
            super.modifyCachePool(info);
            return;
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                dfs.modifyCachePool(info);
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
    }

    @Override
    public void removeCachePool(String poolName) throws IOException {
        if (this.vfs == null) {
            super.removeCachePool(poolName);
            return;
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                dfs.removeCachePool(poolName);
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
    }

    @Override
    public RemoteIterator<CachePoolEntry> listCachePools() throws IOException {
        if (this.vfs == null) {
            return super.listCachePools();
        }
        final ArrayList<DistributedFileSystem> childDFSs = new ArrayList<DistributedFileSystem>();
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            childDFSs.add((DistributedFileSystem)fs);
        }
        if (childDFSs.size() == 0) {
            throw new UnsupportedOperationException("No DFS found in child fs. This API can't be supported in non DFS");
        }
        return new RemoteIterator<CachePoolEntry>(){
            int curDfsIdx = 0;
            RemoteIterator<CachePoolEntry> currIter = ((DistributedFileSystem)((Object)childDFSs.get(this.curDfsIdx++))).listCachePools();

            public boolean hasNext() throws IOException {
                if (this.currIter.hasNext()) {
                    return true;
                }
                while (this.curDfsIdx < childDFSs.size()) {
                    this.currIter = ((DistributedFileSystem)((Object)childDFSs.get(this.curDfsIdx++))).listCachePools();
                    if (!this.currIter.hasNext()) continue;
                    return true;
                }
                return false;
            }

            public CachePoolEntry next() throws IOException {
                if (this.hasNext()) {
                    return (CachePoolEntry)this.currIter.next();
                }
                throw new NoSuchElementException("No more entries");
            }
        };
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        if (this.vfs == null) {
            super.modifyAclEntries(path, aclSpec);
            return;
        }
        this.vfs.modifyAclEntries(path, aclSpec);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        if (this.vfs == null) {
            super.removeAclEntries(path, aclSpec);
            return;
        }
        this.vfs.removeAclEntries(path, aclSpec);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        if (this.vfs == null) {
            super.removeDefaultAcl(path);
            return;
        }
        this.vfs.removeDefaultAcl(path);
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        if (this.vfs == null) {
            super.removeAcl(path);
            return;
        }
        this.vfs.removeAcl(path);
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        if (this.vfs == null) {
            super.setAcl(path, aclSpec);
            return;
        }
        this.vfs.setAcl(path, aclSpec);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        if (this.vfs == null) {
            return super.getAclStatus(path);
        }
        return this.vfs.getAclStatus(path);
    }

    @Override
    public void createEncryptionZone(Path path, String keyName) throws IOException {
        if (this.vfs == null) {
            super.createEncryptionZone(path, keyName);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "createEncryptionZone");
        ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).createEncryptionZone(mountPathInfo.getPathOnTarget(), keyName);
    }

    @Override
    public EncryptionZone getEZForPath(Path path) throws IOException {
        if (this.vfs == null) {
            return super.getEZForPath(path);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "getEZForPath");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).getEZForPath(mountPathInfo.getPathOnTarget());
    }

    @Override
    public RemoteIterator<EncryptionZone> listEncryptionZones() throws IOException {
        if (this.vfs == null) {
            return super.listEncryptionZones();
        }
        this.checkDefaultDFS(this.defaultDFS, "listEncryptionZones");
        return this.defaultDFS.listEncryptionZones();
    }

    @Override
    public void reencryptEncryptionZone(Path zone, HdfsConstants.ReencryptAction action) throws IOException {
        if (this.vfs == null) {
            super.reencryptEncryptionZone(zone, action);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(zone, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "reencryptEncryptionZone");
        ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).reencryptEncryptionZone(mountPathInfo.getPathOnTarget(), action);
    }

    @Override
    public RemoteIterator<ZoneReencryptionStatus> listReencryptionStatus() throws IOException {
        if (this.vfs == null) {
            return super.listReencryptionStatus();
        }
        this.checkDefaultDFS(this.defaultDFS, "listReencryptionStatus");
        return this.defaultDFS.listReencryptionStatus();
    }

    @Override
    public FileEncryptionInfo getFileEncryptionInfo(Path path) throws IOException {
        if (this.vfs == null) {
            return super.getFileEncryptionInfo(path);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "getFileEncryptionInfo");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).getFileEncryptionInfo(mountPathInfo.getPathOnTarget());
    }

    @Override
    public void provisionEZTrash(Path path, FsPermission trashPermission) throws IOException {
        if (this.vfs == null) {
            super.provisionEZTrash(path, trashPermission);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "provisionEZTrash");
        ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).provisionEZTrash(mountPathInfo.getPathOnTarget(), trashPermission);
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        if (this.vfs == null) {
            super.setXAttr(path, name, value, flag);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        ((FileSystem)mountPathInfo.getTargetFs()).setXAttr(mountPathInfo.getPathOnTarget(), name, value, flag);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        if (this.vfs == null) {
            return super.getXAttr(path, name);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        return ((FileSystem)mountPathInfo.getTargetFs()).getXAttr(mountPathInfo.getPathOnTarget(), name);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        if (this.vfs == null) {
            return super.getXAttrs(path);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        return ((FileSystem)mountPathInfo.getTargetFs()).getXAttrs(mountPathInfo.getPathOnTarget());
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        if (this.vfs == null) {
            return super.getXAttrs(path, names);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        return ((FileSystem)mountPathInfo.getTargetFs()).getXAttrs(mountPathInfo.getPathOnTarget(), names);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        if (this.vfs == null) {
            return super.listXAttrs(path);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        return ((FileSystem)mountPathInfo.getTargetFs()).listXAttrs(mountPathInfo.getPathOnTarget());
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        if (this.vfs == null) {
            super.removeXAttr(path, name);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        ((FileSystem)mountPathInfo.getTargetFs()).removeXAttr(mountPathInfo.getPathOnTarget(), name);
    }

    @Override
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            super.access(path, mode);
            return;
        }
        this.vfs.access(path, mode);
    }

    @Override
    public URI getKeyProviderUri() throws IOException {
        if (this.vfs == null) {
            return super.getKeyProviderUri();
        }
        this.checkDefaultDFS(this.defaultDFS, "getKeyProviderUri");
        return this.defaultDFS.getKeyProviderUri();
    }

    @Override
    public KeyProvider getKeyProvider() throws IOException {
        if (this.vfs == null) {
            return super.getKeyProvider();
        }
        this.checkDefaultDFS(this.defaultDFS, "getKeyProvider");
        return this.defaultDFS.getKeyProvider();
    }

    @Override
    public DelegationTokenIssuer[] getAdditionalTokenIssuers() throws IOException {
        if (this.vfs == null) {
            return super.getChildFileSystems();
        }
        return this.vfs.getChildFileSystems();
    }

    @Override
    public DFSInotifyEventInputStream getInotifyEventStream() throws IOException {
        if (this.vfs == null) {
            return super.getInotifyEventStream();
        }
        this.checkDefaultDFS(this.defaultDFS, "getInotifyEventStream");
        return this.defaultDFS.getInotifyEventStream();
    }

    @Override
    public DFSInotifyEventInputStream getInotifyEventStream(long lastReadTxid) throws IOException {
        if (this.vfs == null) {
            return super.getInotifyEventStream();
        }
        this.checkDefaultDFS(this.defaultDFS, "getInotifyEventStream");
        return this.defaultDFS.getInotifyEventStream();
    }

    @Override
    public void setErasureCodingPolicy(Path path, String ecPolicyName) throws IOException {
        if (this.vfs == null) {
            super.setErasureCodingPolicy(path, ecPolicyName);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "setErasureCodingPolicy");
        ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).setErasureCodingPolicy(mountPathInfo.getPathOnTarget(), ecPolicyName);
    }

    @Override
    public void satisfyStoragePolicy(Path src) throws IOException {
        if (this.vfs == null) {
            super.satisfyStoragePolicy(src);
            return;
        }
        this.vfs.satisfyStoragePolicy(src);
    }

    @Override
    public ErasureCodingPolicy getErasureCodingPolicy(Path path) throws IOException {
        if (this.vfs == null) {
            return super.getErasureCodingPolicy(path);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "getErasureCodingPolicy");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).getErasureCodingPolicy(mountPathInfo.getPathOnTarget());
    }

    @Override
    public Collection<ErasureCodingPolicyInfo> getAllErasureCodingPolicies() throws IOException {
        if (this.vfs == null) {
            return super.getAllErasureCodingPolicies();
        }
        FileSystem[] childFss = this.getChildFileSystems();
        ArrayList<ErasureCodingPolicyInfo> results = new ArrayList<ErasureCodingPolicyInfo>();
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : childFss) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                results.addAll(dfs.getAllErasureCodingPolicies());
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
        return results;
    }

    @Override
    public Map<String, String> getAllErasureCodingCodecs() throws IOException {
        if (this.vfs == null) {
            return super.getAllErasureCodingCodecs();
        }
        FileSystem[] childFss = this.getChildFileSystems();
        HashMap<String, String> results = new HashMap<String, String>();
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : childFss) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                results.putAll(dfs.getAllErasureCodingCodecs());
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
        return results;
    }

    @Override
    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies) throws IOException {
        if (this.vfs == null) {
            return super.addErasureCodingPolicies(policies);
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        ArrayList<AddErasureCodingPolicyResponse> results = new ArrayList<AddErasureCodingPolicyResponse>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                results.addAll(Arrays.asList(dfs.addErasureCodingPolicies(policies)));
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
        return results.toArray(new AddErasureCodingPolicyResponse[results.size()]);
    }

    @Override
    public void removeErasureCodingPolicy(String ecPolicyName) throws IOException {
        if (this.vfs == null) {
            super.removeErasureCodingPolicy(ecPolicyName);
            return;
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                dfs.removeErasureCodingPolicy(ecPolicyName);
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
    }

    @Override
    public void enableErasureCodingPolicy(String ecPolicyName) throws IOException {
        if (this.vfs == null) {
            super.enableErasureCodingPolicy(ecPolicyName);
            return;
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                dfs.enableErasureCodingPolicy(ecPolicyName);
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
    }

    @Override
    public void disableErasureCodingPolicy(String ecPolicyName) throws IOException {
        if (this.vfs == null) {
            super.disableErasureCodingPolicy(ecPolicyName);
            return;
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        boolean isDFSExistsInChilds = false;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            isDFSExistsInChilds = true;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                dfs.disableErasureCodingPolicy(ecPolicyName);
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (!isDFSExistsInChilds) {
            throw new UnsupportedOperationException("No DFS available in child file systems.");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
    }

    @Override
    public void unsetErasureCodingPolicy(Path path) throws IOException {
        if (this.vfs == null) {
            super.unsetErasureCodingPolicy(path);
            return;
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "unsetErasureCodingPolicy");
        ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).unsetErasureCodingPolicy(mountPathInfo.getPathOnTarget());
    }

    @Override
    public ECTopologyVerifierResult getECTopologyResultForPolicies(String ... policyNames) throws IOException {
        if (this.vfs == null) {
            return super.getECTopologyResultForPolicies(policyNames);
        }
        ArrayList<IOException> failedExceptions = new ArrayList<IOException>();
        ECTopologyVerifierResult result = null;
        for (FileSystem fs : this.getChildFileSystems()) {
            if (!(fs instanceof DistributedFileSystem)) continue;
            DistributedFileSystem dfs = (DistributedFileSystem)fs;
            try {
                result = dfs.getECTopologyResultForPolicies(policyNames);
                if (result.isSupported()) continue;
                return result;
            }
            catch (IOException ioe) {
                failedExceptions.add(ioe);
            }
        }
        if (result == null) {
            throw new UnsupportedOperationException("No DFS available in child filesystems");
        }
        if (failedExceptions.size() > 0) {
            throw MultipleIOException.createIOException(failedExceptions);
        }
        return result;
    }

    @Override
    public Path getTrashRoot(Path path) {
        if (this.vfs == null) {
            return super.getTrashRoot(path);
        }
        return this.vfs.getTrashRoot(path);
    }

    @Override
    public Collection<FileStatus> getTrashRoots(boolean allUsers) {
        if (this.vfs == null) {
            return super.getTrashRoots(allUsers);
        }
        ArrayList<FileStatus> trashRoots = new ArrayList<FileStatus>();
        for (FileSystem fs : this.getChildFileSystems()) {
            trashRoots.addAll(fs.getTrashRoots(allUsers));
        }
        return trashRoots;
    }

    @Override
    protected Path fixRelativePart(Path p) {
        return super.fixRelativePart(p);
    }

    @Override
    FileSystem.Statistics getFsStatistics() {
        if (this.vfs == null) {
            return super.getFsStatistics();
        }
        return this.statistics;
    }

    @Override
    DFSOpsCountStatistics getDFSOpsCountStatistics() {
        if (this.vfs == null) {
            return super.getDFSOpsCountStatistics();
        }
        return this.defaultDFS.getDFSOpsCountStatistics();
    }

    @Override
    public DistributedFileSystem.HdfsDataOutputStreamBuilder createFile(Path path) {
        if (this.vfs == null) {
            return super.createFile(path);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = null;
        try {
            mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        }
        catch (IOException e) {
            return null;
        }
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "createFile");
        return (DistributedFileSystem.HdfsDataOutputStreamBuilder)((FileSystem)mountPathInfo.getTargetFs()).createFile(mountPathInfo.getPathOnTarget());
    }

    @Override
    @Deprecated
    public RemoteIterator<OpenFileEntry> listOpenFiles() throws IOException {
        if (this.vfs == null) {
            return super.listOpenFiles();
        }
        this.checkDefaultDFS(this.defaultDFS, "listOpenFiles");
        return this.defaultDFS.listOpenFiles();
    }

    @Override
    @Deprecated
    public RemoteIterator<OpenFileEntry> listOpenFiles(EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes) throws IOException {
        if (this.vfs == null) {
            return super.listOpenFiles(openFilesTypes);
        }
        this.checkDefaultDFS(this.defaultDFS, "listOpenFiles");
        return this.defaultDFS.listOpenFiles(openFilesTypes);
    }

    @Override
    public RemoteIterator<OpenFileEntry> listOpenFiles(EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes, String path) throws IOException {
        if (this.vfs == null) {
            return super.listOpenFiles(openFilesTypes, path);
        }
        Path absF = this.fixRelativePart(new Path(path));
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = this.vfs.getMountPathInfo(absF, this.getConf());
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "listOpenFiles");
        return ((DistributedFileSystem)((Object)mountPathInfo.getTargetFs())).listOpenFiles(openFilesTypes, mountPathInfo.getPathOnTarget().toString());
    }

    @Override
    public DistributedFileSystem.HdfsDataOutputStreamBuilder appendFile(Path path) {
        if (this.vfs == null) {
            return super.appendFile(path);
        }
        ViewFileSystemOverloadScheme.MountPathInfo mountPathInfo = null;
        try {
            mountPathInfo = this.vfs.getMountPathInfo(path, this.getConf());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to resolve the path as mount path", (Throwable)e);
            return null;
        }
        this.checkDFS((FileSystem)mountPathInfo.getTargetFs(), "appendFile");
        return (DistributedFileSystem.HdfsDataOutputStreamBuilder)((FileSystem)mountPathInfo.getTargetFs()).appendFile(mountPathInfo.getPathOnTarget());
    }

    @Override
    public boolean hasPathCapability(Path path, String capability) throws IOException {
        if (this.vfs == null) {
            return super.hasPathCapability(path, capability);
        }
        return this.vfs.hasPathCapability(path, capability);
    }

    public Path resolvePath(Path f) throws IOException {
        if (this.vfs == null) {
            return super.resolvePath(f);
        }
        return this.vfs.resolvePath(f);
    }

    public boolean delete(Path f) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            return super.delete(f);
        }
        return this.vfs.delete(f);
    }

    @Override
    public FileChecksum getFileChecksum(Path f, long length) throws AccessControlException, FileNotFoundException, IOException {
        if (this.vfs == null) {
            return super.getFileChecksum(f, length);
        }
        return this.vfs.getFileChecksum(f, length);
    }

    public boolean mkdirs(Path dir) throws IOException {
        if (this.vfs == null) {
            return super.mkdirs(dir);
        }
        return this.vfs.mkdirs(dir);
    }

    public long getDefaultBlockSize(Path f) {
        if (this.vfs == null) {
            return super.getDefaultBlockSize(f);
        }
        return this.vfs.getDefaultBlockSize(f);
    }

    public short getDefaultReplication(Path f) {
        if (this.vfs == null) {
            return super.getDefaultReplication(f);
        }
        return this.vfs.getDefaultReplication(f);
    }

    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        if (this.vfs == null) {
            return super.getServerDefaults(f);
        }
        return this.vfs.getServerDefaults(f);
    }

    public void setWriteChecksum(boolean writeChecksum) {
        if (this.vfs == null) {
            super.setWriteChecksum(writeChecksum);
            return;
        }
        this.vfs.setWriteChecksum(writeChecksum);
    }

    public FileSystem[] getChildFileSystems() {
        if (this.vfs == null) {
            return super.getChildFileSystems();
        }
        return this.vfs.getChildFileSystems();
    }

    public ViewFileSystem.MountPoint[] getMountPoints() {
        if (this.vfs == null) {
            return null;
        }
        return this.vfs.getMountPoints();
    }

    public FsStatus getStatus() throws IOException {
        if (this.vfs == null) {
            return super.getStatus();
        }
        return this.vfs.getStatus();
    }

    public long getUsed() throws IOException {
        if (this.vfs == null) {
            return super.getUsed();
        }
        return this.vfs.getUsed();
    }

    @Override
    public DatanodeInfo[] getSlowDatanodeStats() throws IOException {
        if (this.vfs == null) {
            return super.getSlowDatanodeStats();
        }
        this.checkDefaultDFS(this.defaultDFS, "getSlowDatanodeStats");
        return this.defaultDFS.getSlowDatanodeStats();
    }
}

