/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.resourcematcher.RecursiveMatcher;

final class CaseSensitiveURLRecursiveMatcher
extends RecursiveMatcher {
    CaseSensitiveURLRecursiveMatcher(String value, Map<String, String> options, char levelSeparatorChar) {
        super(value, options, levelSeparatorChar);
    }

    @Override
    boolean isMatch(String resourceValue, Map<String, Object> evalContext) {
        String noSeparator;
        if (this.getNeedsDynamicEval()) {
            String expandedPolicyValue = this.getExpandedValue(evalContext);
            noSeparator = expandedPolicyValue != null ? this.getStringToCompare(expandedPolicyValue) : null;
        } else {
            if (this.valueWithoutSeparator == null && this.value != null) {
                this.valueWithoutSeparator = this.getStringToCompare(this.value);
                this.valueWithSeparator = this.valueWithoutSeparator + Character.toString(this.levelSeparatorChar);
            }
            noSeparator = this.valueWithoutSeparator;
        }
        boolean ret = StringUtils.equals((String)resourceValue, (String)noSeparator);
        if (!ret && noSeparator != null) {
            String withSeparator = this.getNeedsDynamicEval() ? noSeparator + Character.toString(this.levelSeparatorChar) : this.valueWithSeparator;
            ret = StringUtils.startsWith((String)resourceValue, (String)withSeparator);
        }
        return ret;
    }

    @Override
    public boolean isPrefixMatch(String resourceValue, Map<String, Object> evalContext) {
        return StringUtils.startsWith((String)this.getExpandedValue(evalContext), (String)resourceValue);
    }

    @Override
    int getPriority() {
        return 7 + (this.getNeedsDynamicEval() ? 8 : 0);
    }
}

