/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jline.builtins.Completers;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.ArgumentCompleter;

public class OptionStrictArgumentCompleter
implements Completer {
    private final List<Completer> completers = new ArrayList<Completer>();

    public OptionStrictArgumentCompleter(Collection<Completer> completers) {
        Objects.requireNonNull(completers);
        this.completers.addAll(completers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        Objects.requireNonNull(line);
        Objects.requireNonNull(candidates);
        if (line.wordIndex() < 0) {
            return;
        }
        Completer completer = line.wordIndex() >= this.completers.size() ? this.completers.get(this.completers.size() - 1) : this.completers.get(line.wordIndex());
        for (int i = 0; i < line.wordIndex(); ++i) {
            int idx = i >= this.completers.size() ? this.completers.size() - 1 : i;
            Completer sub = this.completers.get(idx);
            List args = line.words();
            String arg = args == null || i >= args.size() ? "" : ((CharSequence)args.get(i)).toString();
            LinkedList subCandidates = new LinkedList();
            if (sub instanceof Completers.OptionCompleter) {
                if (!arg.startsWith("-")) return;
                sub.complete(reader, (ParsedLine)new ArgumentCompleter.ArgumentLine(arg, arg.length()), subCandidates);
            } else {
                sub.complete(reader, (ParsedLine)new ArgumentCompleter.ArgumentLine(arg, arg.length()), subCandidates);
            }
            boolean found = false;
            for (Candidate cand : subCandidates) {
                if (!cand.value().equals(arg)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return;
        }
        completer.complete(reader, line, candidates);
    }
}

