/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// UserTokenSettingsDataType is the corresponding interface of UserTokenSettingsDataType
type UserTokenSettingsDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetName returns Name (property field)
	GetName() PascalString
	// GetRecordProperties returns RecordProperties (property field)
	GetRecordProperties() []KeyValuePair
	// GetTokenType returns TokenType (property field)
	GetTokenType() UserTokenType
	// GetIssuedTokenType returns IssuedTokenType (property field)
	GetIssuedTokenType() PascalString
	// GetIssuerEndpointUrl returns IssuerEndpointUrl (property field)
	GetIssuerEndpointUrl() PascalString
	// GetSecurityPolicyUri returns SecurityPolicyUri (property field)
	GetSecurityPolicyUri() PascalString
	// GetCertificateGroupName returns CertificateGroupName (property field)
	GetCertificateGroupName() PascalString
	// GetAuthorizationServiceName returns AuthorizationServiceName (property field)
	GetAuthorizationServiceName() PascalString
	// IsUserTokenSettingsDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsUserTokenSettingsDataType()
	// CreateBuilder creates a UserTokenSettingsDataTypeBuilder
	CreateUserTokenSettingsDataTypeBuilder() UserTokenSettingsDataTypeBuilder
}

// _UserTokenSettingsDataType is the data-structure of this message
type _UserTokenSettingsDataType struct {
	ExtensionObjectDefinitionContract
	Name                     PascalString
	RecordProperties         []KeyValuePair
	TokenType                UserTokenType
	IssuedTokenType          PascalString
	IssuerEndpointUrl        PascalString
	SecurityPolicyUri        PascalString
	CertificateGroupName     PascalString
	AuthorizationServiceName PascalString
}

var _ UserTokenSettingsDataType = (*_UserTokenSettingsDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_UserTokenSettingsDataType)(nil)

// NewUserTokenSettingsDataType factory function for _UserTokenSettingsDataType
func NewUserTokenSettingsDataType(name PascalString, recordProperties []KeyValuePair, tokenType UserTokenType, issuedTokenType PascalString, issuerEndpointUrl PascalString, securityPolicyUri PascalString, certificateGroupName PascalString, authorizationServiceName PascalString) *_UserTokenSettingsDataType {
	if name == nil {
		panic("name of type PascalString for UserTokenSettingsDataType must not be nil")
	}
	if issuedTokenType == nil {
		panic("issuedTokenType of type PascalString for UserTokenSettingsDataType must not be nil")
	}
	if issuerEndpointUrl == nil {
		panic("issuerEndpointUrl of type PascalString for UserTokenSettingsDataType must not be nil")
	}
	if securityPolicyUri == nil {
		panic("securityPolicyUri of type PascalString for UserTokenSettingsDataType must not be nil")
	}
	if certificateGroupName == nil {
		panic("certificateGroupName of type PascalString for UserTokenSettingsDataType must not be nil")
	}
	if authorizationServiceName == nil {
		panic("authorizationServiceName of type PascalString for UserTokenSettingsDataType must not be nil")
	}
	_result := &_UserTokenSettingsDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Name:                              name,
		RecordProperties:                  recordProperties,
		TokenType:                         tokenType,
		IssuedTokenType:                   issuedTokenType,
		IssuerEndpointUrl:                 issuerEndpointUrl,
		SecurityPolicyUri:                 securityPolicyUri,
		CertificateGroupName:              certificateGroupName,
		AuthorizationServiceName:          authorizationServiceName,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// UserTokenSettingsDataTypeBuilder is a builder for UserTokenSettingsDataType
type UserTokenSettingsDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(name PascalString, recordProperties []KeyValuePair, tokenType UserTokenType, issuedTokenType PascalString, issuerEndpointUrl PascalString, securityPolicyUri PascalString, certificateGroupName PascalString, authorizationServiceName PascalString) UserTokenSettingsDataTypeBuilder
	// WithName adds Name (property field)
	WithName(PascalString) UserTokenSettingsDataTypeBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder
	// WithRecordProperties adds RecordProperties (property field)
	WithRecordProperties(...KeyValuePair) UserTokenSettingsDataTypeBuilder
	// WithTokenType adds TokenType (property field)
	WithTokenType(UserTokenType) UserTokenSettingsDataTypeBuilder
	// WithIssuedTokenType adds IssuedTokenType (property field)
	WithIssuedTokenType(PascalString) UserTokenSettingsDataTypeBuilder
	// WithIssuedTokenTypeBuilder adds IssuedTokenType (property field) which is build by the builder
	WithIssuedTokenTypeBuilder(func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder
	// WithIssuerEndpointUrl adds IssuerEndpointUrl (property field)
	WithIssuerEndpointUrl(PascalString) UserTokenSettingsDataTypeBuilder
	// WithIssuerEndpointUrlBuilder adds IssuerEndpointUrl (property field) which is build by the builder
	WithIssuerEndpointUrlBuilder(func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder
	// WithSecurityPolicyUri adds SecurityPolicyUri (property field)
	WithSecurityPolicyUri(PascalString) UserTokenSettingsDataTypeBuilder
	// WithSecurityPolicyUriBuilder adds SecurityPolicyUri (property field) which is build by the builder
	WithSecurityPolicyUriBuilder(func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder
	// WithCertificateGroupName adds CertificateGroupName (property field)
	WithCertificateGroupName(PascalString) UserTokenSettingsDataTypeBuilder
	// WithCertificateGroupNameBuilder adds CertificateGroupName (property field) which is build by the builder
	WithCertificateGroupNameBuilder(func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder
	// WithAuthorizationServiceName adds AuthorizationServiceName (property field)
	WithAuthorizationServiceName(PascalString) UserTokenSettingsDataTypeBuilder
	// WithAuthorizationServiceNameBuilder adds AuthorizationServiceName (property field) which is build by the builder
	WithAuthorizationServiceNameBuilder(func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the UserTokenSettingsDataType or returns an error if something is wrong
	Build() (UserTokenSettingsDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() UserTokenSettingsDataType
}

// NewUserTokenSettingsDataTypeBuilder() creates a UserTokenSettingsDataTypeBuilder
func NewUserTokenSettingsDataTypeBuilder() UserTokenSettingsDataTypeBuilder {
	return &_UserTokenSettingsDataTypeBuilder{_UserTokenSettingsDataType: new(_UserTokenSettingsDataType)}
}

type _UserTokenSettingsDataTypeBuilder struct {
	*_UserTokenSettingsDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (UserTokenSettingsDataTypeBuilder) = (*_UserTokenSettingsDataTypeBuilder)(nil)

func (b *_UserTokenSettingsDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._UserTokenSettingsDataType
}

func (b *_UserTokenSettingsDataTypeBuilder) WithMandatoryFields(name PascalString, recordProperties []KeyValuePair, tokenType UserTokenType, issuedTokenType PascalString, issuerEndpointUrl PascalString, securityPolicyUri PascalString, certificateGroupName PascalString, authorizationServiceName PascalString) UserTokenSettingsDataTypeBuilder {
	return b.WithName(name).WithRecordProperties(recordProperties...).WithTokenType(tokenType).WithIssuedTokenType(issuedTokenType).WithIssuerEndpointUrl(issuerEndpointUrl).WithSecurityPolicyUri(securityPolicyUri).WithCertificateGroupName(certificateGroupName).WithAuthorizationServiceName(authorizationServiceName)
}

func (b *_UserTokenSettingsDataTypeBuilder) WithName(name PascalString) UserTokenSettingsDataTypeBuilder {
	b.Name = name
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithRecordProperties(recordProperties ...KeyValuePair) UserTokenSettingsDataTypeBuilder {
	b.RecordProperties = recordProperties
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithTokenType(tokenType UserTokenType) UserTokenSettingsDataTypeBuilder {
	b.TokenType = tokenType
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithIssuedTokenType(issuedTokenType PascalString) UserTokenSettingsDataTypeBuilder {
	b.IssuedTokenType = issuedTokenType
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithIssuedTokenTypeBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder {
	builder := builderSupplier(b.IssuedTokenType.CreatePascalStringBuilder())
	var err error
	b.IssuedTokenType, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithIssuerEndpointUrl(issuerEndpointUrl PascalString) UserTokenSettingsDataTypeBuilder {
	b.IssuerEndpointUrl = issuerEndpointUrl
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithIssuerEndpointUrlBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder {
	builder := builderSupplier(b.IssuerEndpointUrl.CreatePascalStringBuilder())
	var err error
	b.IssuerEndpointUrl, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithSecurityPolicyUri(securityPolicyUri PascalString) UserTokenSettingsDataTypeBuilder {
	b.SecurityPolicyUri = securityPolicyUri
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithSecurityPolicyUriBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder {
	builder := builderSupplier(b.SecurityPolicyUri.CreatePascalStringBuilder())
	var err error
	b.SecurityPolicyUri, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithCertificateGroupName(certificateGroupName PascalString) UserTokenSettingsDataTypeBuilder {
	b.CertificateGroupName = certificateGroupName
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithCertificateGroupNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder {
	builder := builderSupplier(b.CertificateGroupName.CreatePascalStringBuilder())
	var err error
	b.CertificateGroupName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithAuthorizationServiceName(authorizationServiceName PascalString) UserTokenSettingsDataTypeBuilder {
	b.AuthorizationServiceName = authorizationServiceName
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) WithAuthorizationServiceNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) UserTokenSettingsDataTypeBuilder {
	builder := builderSupplier(b.AuthorizationServiceName.CreatePascalStringBuilder())
	var err error
	b.AuthorizationServiceName, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_UserTokenSettingsDataTypeBuilder) Build() (UserTokenSettingsDataType, error) {
	if b.Name == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'name' not set"))
	}
	if b.IssuedTokenType == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'issuedTokenType' not set"))
	}
	if b.IssuerEndpointUrl == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'issuerEndpointUrl' not set"))
	}
	if b.SecurityPolicyUri == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'securityPolicyUri' not set"))
	}
	if b.CertificateGroupName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'certificateGroupName' not set"))
	}
	if b.AuthorizationServiceName == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'authorizationServiceName' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._UserTokenSettingsDataType.deepCopy(), nil
}

func (b *_UserTokenSettingsDataTypeBuilder) MustBuild() UserTokenSettingsDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_UserTokenSettingsDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_UserTokenSettingsDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_UserTokenSettingsDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateUserTokenSettingsDataTypeBuilder().(*_UserTokenSettingsDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateUserTokenSettingsDataTypeBuilder creates a UserTokenSettingsDataTypeBuilder
func (b *_UserTokenSettingsDataType) CreateUserTokenSettingsDataTypeBuilder() UserTokenSettingsDataTypeBuilder {
	if b == nil {
		return NewUserTokenSettingsDataTypeBuilder()
	}
	return &_UserTokenSettingsDataTypeBuilder{_UserTokenSettingsDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_UserTokenSettingsDataType) GetExtensionId() int32 {
	return int32(15562)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_UserTokenSettingsDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_UserTokenSettingsDataType) GetName() PascalString {
	return m.Name
}

func (m *_UserTokenSettingsDataType) GetRecordProperties() []KeyValuePair {
	return m.RecordProperties
}

func (m *_UserTokenSettingsDataType) GetTokenType() UserTokenType {
	return m.TokenType
}

func (m *_UserTokenSettingsDataType) GetIssuedTokenType() PascalString {
	return m.IssuedTokenType
}

func (m *_UserTokenSettingsDataType) GetIssuerEndpointUrl() PascalString {
	return m.IssuerEndpointUrl
}

func (m *_UserTokenSettingsDataType) GetSecurityPolicyUri() PascalString {
	return m.SecurityPolicyUri
}

func (m *_UserTokenSettingsDataType) GetCertificateGroupName() PascalString {
	return m.CertificateGroupName
}

func (m *_UserTokenSettingsDataType) GetAuthorizationServiceName() PascalString {
	return m.AuthorizationServiceName
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastUserTokenSettingsDataType(structType any) UserTokenSettingsDataType {
	if casted, ok := structType.(UserTokenSettingsDataType); ok {
		return casted
	}
	if casted, ok := structType.(*UserTokenSettingsDataType); ok {
		return *casted
	}
	return nil
}

func (m *_UserTokenSettingsDataType) GetTypeName() string {
	return "UserTokenSettingsDataType"
}

func (m *_UserTokenSettingsDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Implicit Field (noOfRecordProperties)
	lengthInBits += 32

	// Array field
	if len(m.RecordProperties) > 0 {
		for _curItem, element := range m.RecordProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.RecordProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (tokenType)
	lengthInBits += 32

	// Simple field (issuedTokenType)
	lengthInBits += m.IssuedTokenType.GetLengthInBits(ctx)

	// Simple field (issuerEndpointUrl)
	lengthInBits += m.IssuerEndpointUrl.GetLengthInBits(ctx)

	// Simple field (securityPolicyUri)
	lengthInBits += m.SecurityPolicyUri.GetLengthInBits(ctx)

	// Simple field (certificateGroupName)
	lengthInBits += m.CertificateGroupName.GetLengthInBits(ctx)

	// Simple field (authorizationServiceName)
	lengthInBits += m.AuthorizationServiceName.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_UserTokenSettingsDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_UserTokenSettingsDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__userTokenSettingsDataType UserTokenSettingsDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("UserTokenSettingsDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for UserTokenSettingsDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	noOfRecordProperties, err := ReadImplicitField[int32](ctx, "noOfRecordProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfRecordProperties' field"))
	}
	_ = noOfRecordProperties

	recordProperties, err := ReadCountArrayField[KeyValuePair](ctx, "recordProperties", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfRecordProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'recordProperties' field"))
	}
	m.RecordProperties = recordProperties

	tokenType, err := ReadEnumField[UserTokenType](ctx, "tokenType", "UserTokenType", ReadEnum(UserTokenTypeByValue, ReadUnsignedInt(readBuffer, uint8(32))))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'tokenType' field"))
	}
	m.TokenType = tokenType

	issuedTokenType, err := ReadSimpleField[PascalString](ctx, "issuedTokenType", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'issuedTokenType' field"))
	}
	m.IssuedTokenType = issuedTokenType

	issuerEndpointUrl, err := ReadSimpleField[PascalString](ctx, "issuerEndpointUrl", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'issuerEndpointUrl' field"))
	}
	m.IssuerEndpointUrl = issuerEndpointUrl

	securityPolicyUri, err := ReadSimpleField[PascalString](ctx, "securityPolicyUri", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'securityPolicyUri' field"))
	}
	m.SecurityPolicyUri = securityPolicyUri

	certificateGroupName, err := ReadSimpleField[PascalString](ctx, "certificateGroupName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'certificateGroupName' field"))
	}
	m.CertificateGroupName = certificateGroupName

	authorizationServiceName, err := ReadSimpleField[PascalString](ctx, "authorizationServiceName", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'authorizationServiceName' field"))
	}
	m.AuthorizationServiceName = authorizationServiceName

	if closeErr := readBuffer.CloseContext("UserTokenSettingsDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for UserTokenSettingsDataType")
	}

	return m, nil
}

func (m *_UserTokenSettingsDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_UserTokenSettingsDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("UserTokenSettingsDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for UserTokenSettingsDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}
		noOfRecordProperties := int32(utils.InlineIf(bool((m.GetRecordProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetRecordProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfRecordProperties", noOfRecordProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfRecordProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "recordProperties", m.GetRecordProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'recordProperties' field")
		}

		if err := WriteSimpleEnumField[UserTokenType](ctx, "tokenType", "UserTokenType", m.GetTokenType(), WriteEnum[UserTokenType, uint32](UserTokenType.GetValue, UserTokenType.PLC4XEnumName, WriteUnsignedInt(writeBuffer, 32))); err != nil {
			return errors.Wrap(err, "Error serializing 'tokenType' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "issuedTokenType", m.GetIssuedTokenType(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'issuedTokenType' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "issuerEndpointUrl", m.GetIssuerEndpointUrl(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'issuerEndpointUrl' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "securityPolicyUri", m.GetSecurityPolicyUri(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'securityPolicyUri' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "certificateGroupName", m.GetCertificateGroupName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'certificateGroupName' field")
		}

		if err := WriteSimpleField[PascalString](ctx, "authorizationServiceName", m.GetAuthorizationServiceName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'authorizationServiceName' field")
		}

		if popErr := writeBuffer.PopContext("UserTokenSettingsDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for UserTokenSettingsDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_UserTokenSettingsDataType) IsUserTokenSettingsDataType() {}

func (m *_UserTokenSettingsDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_UserTokenSettingsDataType) deepCopy() *_UserTokenSettingsDataType {
	if m == nil {
		return nil
	}
	_UserTokenSettingsDataTypeCopy := &_UserTokenSettingsDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Name),
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.RecordProperties),
		m.TokenType,
		utils.DeepCopy[PascalString](m.IssuedTokenType),
		utils.DeepCopy[PascalString](m.IssuerEndpointUrl),
		utils.DeepCopy[PascalString](m.SecurityPolicyUri),
		utils.DeepCopy[PascalString](m.CertificateGroupName),
		utils.DeepCopy[PascalString](m.AuthorizationServiceName),
	}
	_UserTokenSettingsDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _UserTokenSettingsDataTypeCopy
}

func (m *_UserTokenSettingsDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
