/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataCarDoorZone is the corresponding interface of BACnetConstructedDataCarDoorZone
type BACnetConstructedDataCarDoorZone interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetCarDoorZone returns CarDoorZone (property field)
	GetCarDoorZone() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataCarDoorZone is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataCarDoorZone()
	// CreateBuilder creates a BACnetConstructedDataCarDoorZoneBuilder
	CreateBACnetConstructedDataCarDoorZoneBuilder() BACnetConstructedDataCarDoorZoneBuilder
}

// _BACnetConstructedDataCarDoorZone is the data-structure of this message
type _BACnetConstructedDataCarDoorZone struct {
	BACnetConstructedDataContract
	CarDoorZone BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataCarDoorZone = (*_BACnetConstructedDataCarDoorZone)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataCarDoorZone)(nil)

// NewBACnetConstructedDataCarDoorZone factory function for _BACnetConstructedDataCarDoorZone
func NewBACnetConstructedDataCarDoorZone(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, carDoorZone BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataCarDoorZone {
	if carDoorZone == nil {
		panic("carDoorZone of type BACnetApplicationTagBoolean for BACnetConstructedDataCarDoorZone must not be nil")
	}
	_result := &_BACnetConstructedDataCarDoorZone{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		CarDoorZone:                   carDoorZone,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataCarDoorZoneBuilder is a builder for BACnetConstructedDataCarDoorZone
type BACnetConstructedDataCarDoorZoneBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(carDoorZone BACnetApplicationTagBoolean) BACnetConstructedDataCarDoorZoneBuilder
	// WithCarDoorZone adds CarDoorZone (property field)
	WithCarDoorZone(BACnetApplicationTagBoolean) BACnetConstructedDataCarDoorZoneBuilder
	// WithCarDoorZoneBuilder adds CarDoorZone (property field) which is build by the builder
	WithCarDoorZoneBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataCarDoorZoneBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataCarDoorZone or returns an error if something is wrong
	Build() (BACnetConstructedDataCarDoorZone, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataCarDoorZone
}

// NewBACnetConstructedDataCarDoorZoneBuilder() creates a BACnetConstructedDataCarDoorZoneBuilder
func NewBACnetConstructedDataCarDoorZoneBuilder() BACnetConstructedDataCarDoorZoneBuilder {
	return &_BACnetConstructedDataCarDoorZoneBuilder{_BACnetConstructedDataCarDoorZone: new(_BACnetConstructedDataCarDoorZone)}
}

type _BACnetConstructedDataCarDoorZoneBuilder struct {
	*_BACnetConstructedDataCarDoorZone

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataCarDoorZoneBuilder) = (*_BACnetConstructedDataCarDoorZoneBuilder)(nil)

func (b *_BACnetConstructedDataCarDoorZoneBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataCarDoorZone
}

func (b *_BACnetConstructedDataCarDoorZoneBuilder) WithMandatoryFields(carDoorZone BACnetApplicationTagBoolean) BACnetConstructedDataCarDoorZoneBuilder {
	return b.WithCarDoorZone(carDoorZone)
}

func (b *_BACnetConstructedDataCarDoorZoneBuilder) WithCarDoorZone(carDoorZone BACnetApplicationTagBoolean) BACnetConstructedDataCarDoorZoneBuilder {
	b.CarDoorZone = carDoorZone
	return b
}

func (b *_BACnetConstructedDataCarDoorZoneBuilder) WithCarDoorZoneBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataCarDoorZoneBuilder {
	builder := builderSupplier(b.CarDoorZone.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.CarDoorZone, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataCarDoorZoneBuilder) Build() (BACnetConstructedDataCarDoorZone, error) {
	if b.CarDoorZone == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'carDoorZone' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataCarDoorZone.deepCopy(), nil
}

func (b *_BACnetConstructedDataCarDoorZoneBuilder) MustBuild() BACnetConstructedDataCarDoorZone {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataCarDoorZoneBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataCarDoorZoneBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataCarDoorZoneBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataCarDoorZoneBuilder().(*_BACnetConstructedDataCarDoorZoneBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataCarDoorZoneBuilder creates a BACnetConstructedDataCarDoorZoneBuilder
func (b *_BACnetConstructedDataCarDoorZone) CreateBACnetConstructedDataCarDoorZoneBuilder() BACnetConstructedDataCarDoorZoneBuilder {
	if b == nil {
		return NewBACnetConstructedDataCarDoorZoneBuilder()
	}
	return &_BACnetConstructedDataCarDoorZoneBuilder{_BACnetConstructedDataCarDoorZone: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataCarDoorZone) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataCarDoorZone) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_CAR_DOOR_ZONE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataCarDoorZone) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataCarDoorZone) GetCarDoorZone() BACnetApplicationTagBoolean {
	return m.CarDoorZone
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataCarDoorZone) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetCarDoorZone())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataCarDoorZone(structType any) BACnetConstructedDataCarDoorZone {
	if casted, ok := structType.(BACnetConstructedDataCarDoorZone); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataCarDoorZone); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataCarDoorZone) GetTypeName() string {
	return "BACnetConstructedDataCarDoorZone"
}

func (m *_BACnetConstructedDataCarDoorZone) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (carDoorZone)
	lengthInBits += m.CarDoorZone.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataCarDoorZone) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataCarDoorZone) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataCarDoorZone BACnetConstructedDataCarDoorZone, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataCarDoorZone"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataCarDoorZone")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	carDoorZone, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "carDoorZone", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'carDoorZone' field"))
	}
	m.CarDoorZone = carDoorZone

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), carDoorZone)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataCarDoorZone"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataCarDoorZone")
	}

	return m, nil
}

func (m *_BACnetConstructedDataCarDoorZone) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataCarDoorZone) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataCarDoorZone"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataCarDoorZone")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "carDoorZone", m.GetCarDoorZone(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'carDoorZone' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataCarDoorZone"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataCarDoorZone")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataCarDoorZone) IsBACnetConstructedDataCarDoorZone() {}

func (m *_BACnetConstructedDataCarDoorZone) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataCarDoorZone) deepCopy() *_BACnetConstructedDataCarDoorZone {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataCarDoorZoneCopy := &_BACnetConstructedDataCarDoorZone{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.CarDoorZone),
	}
	_BACnetConstructedDataCarDoorZoneCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataCarDoorZoneCopy
}

func (m *_BACnetConstructedDataCarDoorZone) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
