/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.safemode;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMService;
import org.apache.hadoop.hdds.scm.ha.SCMServiceManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.safemode.ContainerSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.HealthyPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.OneReplicaPipelineSafeModeRule;
import org.apache.hadoop.hdds.scm.safemode.SafeModeExitRule;
import org.apache.hadoop.hdds.scm.safemode.SafeModeManager;
import org.apache.hadoop.hdds.scm.safemode.SafeModeMetrics;
import org.apache.hadoop.hdds.scm.safemode.SafeModeRuleFactory;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMSafeModeManager
implements SafeModeManager {
    private static final Logger LOG = LoggerFactory.getLogger(SCMSafeModeManager.class);
    private final boolean isSafeModeEnabled;
    private AtomicBoolean inSafeMode = new AtomicBoolean(true);
    private AtomicBoolean preCheckComplete = new AtomicBoolean(false);
    private AtomicBoolean forceExitSafeMode = new AtomicBoolean(false);
    private Map<String, SafeModeExitRule> exitRules = new HashMap<String, SafeModeExitRule>(1);
    private Set<String> preCheckRules = new HashSet<String>(1);
    private ConfigurationSource config;
    private static final String CONT_EXIT_RULE = "ContainerSafeModeRule";
    private static final String HEALTHY_PIPELINE_EXIT_RULE = "HealthyPipelineSafeModeRule";
    private static final String ATLEAST_ONE_DATANODE_REPORTED_PIPELINE_EXIT_RULE = "AtleastOneDatanodeReportedRule";
    private Set<String> validatedRules = new HashSet<String>();
    private Set<String> validatedPreCheckRules = new HashSet<String>(1);
    private final EventQueue eventPublisher;
    private final SCMServiceManager serviceManager;
    private final SCMContext scmContext;
    private final SafeModeMetrics safeModeMetrics;

    public SCMSafeModeManager(ConfigurationSource conf, ContainerManager containerManager, PipelineManager pipelineManager, EventQueue eventQueue, SCMServiceManager serviceManager, SCMContext scmContext) {
        this.config = conf;
        this.eventPublisher = eventQueue;
        this.serviceManager = serviceManager;
        this.scmContext = scmContext;
        this.isSafeModeEnabled = conf.getBoolean("hdds.scm.safemode.enabled", true);
        if (this.isSafeModeEnabled) {
            this.safeModeMetrics = SafeModeMetrics.create();
            SafeModeRuleFactory.initialize(this.config, scmContext, eventQueue, this, pipelineManager, containerManager);
            SafeModeRuleFactory factory = SafeModeRuleFactory.getInstance();
            this.exitRules = factory.getSafeModeRules().stream().collect(Collectors.toMap(SafeModeExitRule::getRuleName, rule -> rule));
            this.preCheckRules = factory.getPreCheckRules().stream().map(SafeModeExitRule::getRuleName).collect(Collectors.toSet());
        } else {
            this.safeModeMetrics = null;
            this.exitSafeMode((EventPublisher)eventQueue, true);
        }
    }

    public void stop() {
        if (this.isSafeModeEnabled) {
            this.safeModeMetrics.unRegister();
        }
    }

    public SafeModeMetrics getSafeModeMetrics() {
        return this.safeModeMetrics;
    }

    @VisibleForTesting
    public void emitSafeModeStatus() {
        SafeModeStatus safeModeStatus = new SafeModeStatus(this.getInSafeMode(), this.getPreCheckComplete());
        safeModeStatus.setForceExitSafeMode(this.isForceExitSafeMode());
        this.scmContext.updateSafeModeStatus(safeModeStatus);
        if (!safeModeStatus.isInSafeMode()) {
            this.serviceManager.notifyStatusChanged();
        } else if (safeModeStatus.isPreCheckComplete()) {
            this.serviceManager.notifyEventTriggered(SCMService.Event.PRE_CHECK_COMPLETED);
        }
    }

    public synchronized void validateSafeModeExitRules(String ruleName, EventPublisher eventQueue) {
        if (this.exitRules.get(ruleName) != null) {
            boolean added = this.validatedRules.add(ruleName);
            if (this.preCheckRules.contains(ruleName)) {
                this.validatedPreCheckRules.add(ruleName);
            }
            if (added) {
                LOG.info("{} rule is successfully validated", (Object)ruleName);
            }
        } else {
            LOG.error("No Such Exit rule {}", (Object)ruleName);
        }
        if (!this.getPreCheckComplete() && this.validatedPreCheckRules.size() == this.preCheckRules.size()) {
            this.completePreCheck(eventQueue);
        }
        if (this.validatedRules.size() == this.exitRules.size()) {
            LOG.info("ScmSafeModeManager, all rules are successfully validated");
            this.exitSafeMode(eventQueue, false);
        }
    }

    @VisibleForTesting
    public void completePreCheck(EventPublisher eventQueue) {
        LOG.info("All SCM safe mode pre check rules have passed");
        this.setPreCheckComplete(true);
        this.emitSafeModeStatus();
    }

    @VisibleForTesting
    public void exitSafeMode(EventPublisher eventQueue, boolean force) {
        LOG.info("SCM exiting safe mode.");
        this.setPreCheckComplete(true);
        this.setInSafeMode(false);
        this.setForceExitSafeMode(force);
        this.emitSafeModeStatus();
    }

    public void refresh() {
        if (this.inSafeMode.get()) {
            this.exitRules.values().forEach(rule -> rule.refresh(true));
        }
    }

    public void refreshAndValidate() {
        if (this.inSafeMode.get()) {
            this.exitRules.values().forEach(rule -> {
                rule.refresh(false);
                if (rule.validate() && this.inSafeMode.get()) {
                    this.validateSafeModeExitRules(rule.getRuleName(), (EventPublisher)this.eventPublisher);
                    rule.cleanup();
                }
            });
        }
    }

    @Override
    public boolean getInSafeMode() {
        if (!this.isSafeModeEnabled) {
            return false;
        }
        return this.inSafeMode.get();
    }

    public Map<String, Pair<Boolean, String>> getRuleStatus() {
        HashMap<String, Pair<Boolean, String>> map = new HashMap<String, Pair<Boolean, String>>();
        for (SafeModeExitRule exitRule : this.exitRules.values()) {
            map.put(exitRule.getRuleName(), (Pair<Boolean, String>)Pair.of((Object)exitRule.validate(), (Object)exitRule.getStatusText()));
        }
        return map;
    }

    public boolean getPreCheckComplete() {
        return this.preCheckComplete.get();
    }

    public void setInSafeMode(boolean inSafeMode) {
        this.inSafeMode.set(inSafeMode);
    }

    public void setPreCheckComplete(boolean newState) {
        this.preCheckComplete.set(newState);
    }

    public boolean isForceExitSafeMode() {
        return this.forceExitSafeMode.get();
    }

    public void setForceExitSafeMode(boolean forceExitSafeMode) {
        this.forceExitSafeMode.set(forceExitSafeMode);
    }

    public static Logger getLogger() {
        return LOG;
    }

    @VisibleForTesting
    public double getCurrentContainerThreshold() {
        return ((ContainerSafeModeRule)this.exitRules.get(CONT_EXIT_RULE)).getCurrentContainerThreshold();
    }

    @VisibleForTesting
    public double getCurrentECContainerThreshold() {
        return ((ContainerSafeModeRule)this.exitRules.get(CONT_EXIT_RULE)).getCurrentECContainerThreshold();
    }

    @VisibleForTesting
    public ContainerSafeModeRule getContainerSafeModeRule() {
        return (ContainerSafeModeRule)this.exitRules.get(CONT_EXIT_RULE);
    }

    @VisibleForTesting
    public HealthyPipelineSafeModeRule getHealthyPipelineSafeModeRule() {
        return (HealthyPipelineSafeModeRule)this.exitRules.get(HEALTHY_PIPELINE_EXIT_RULE);
    }

    @VisibleForTesting
    public OneReplicaPipelineSafeModeRule getOneReplicaPipelineSafeModeRule() {
        return (OneReplicaPipelineSafeModeRule)this.exitRules.get(ATLEAST_ONE_DATANODE_REPORTED_PIPELINE_EXIT_RULE);
    }

    public static class SafeModeStatus {
        private final boolean safeModeStatus;
        private final boolean preCheckPassed;
        private boolean forceExitSafeMode;

        public SafeModeStatus(boolean safeModeState, boolean preCheckPassed) {
            this.safeModeStatus = safeModeState;
            this.preCheckPassed = preCheckPassed;
        }

        public boolean isInSafeMode() {
            return this.safeModeStatus;
        }

        public boolean isPreCheckComplete() {
            return this.preCheckPassed;
        }

        public void setForceExitSafeMode(boolean forceExitSafeMode) {
            this.forceExitSafeMode = forceExitSafeMode;
        }

        public boolean isForceExitSafeMode() {
            return this.forceExitSafeMode;
        }

        public String toString() {
            return "SafeModeStatus{safeModeStatus=" + this.safeModeStatus + ", preCheckPassed=" + this.preCheckPassed + '}';
        }
    }
}

