/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.SCMRatisProtocol;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.ha.SCMHAManager;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.scm.metadata.Replicate;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceIdGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceIdGenerator.class);
    public static final String LOCAL_ID = "localId";
    public static final String DEL_TXN_ID = "delTxnId";
    public static final String CONTAINER_ID = "containerId";
    public static final String CERTIFICATE_ID = "CertificateId";
    @Deprecated
    public static final String ROOT_CERTIFICATE_ID = "rootCertificateId";
    private static final long INVALID_SEQUENCE_ID = 0L;
    private final Map<String, Batch> sequenceIdToBatchMap = new HashMap<String, Batch>();
    private final Lock lock = new ReentrantLock();
    private final long batchSize;
    private final StateManager stateManager;

    public SequenceIdGenerator(ConfigurationSource conf, SCMHAManager scmhaManager, Table<String, Long> sequenceIdTable) {
        this.batchSize = conf.getInt("ozone.scm.sequence.id.batch.size", 1000);
        Preconditions.checkNotNull((Object)scmhaManager);
        this.stateManager = this.createStateManager(scmhaManager, sequenceIdTable);
    }

    public StateManager createStateManager(SCMHAManager scmhaManager, Table<String, Long> sequenceIdTable) {
        Preconditions.checkNotNull((Object)scmhaManager);
        return new StateManagerImpl.Builder().setRatisServer(scmhaManager.getRatisServer()).setDBTransactionBuffer(scmhaManager.getDBTransactionBuffer()).setSequenceIdTable(sequenceIdTable).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextId(String sequenceIdName) throws SCMException {
        this.lock.lock();
        try {
            long nextLastId;
            Long prevLastId;
            Batch batch = this.sequenceIdToBatchMap.computeIfAbsent(sequenceIdName, key -> new Batch());
            if (batch.nextId <= batch.lastId) {
                long l = batch.nextId++;
                return l;
            }
            Preconditions.checkArgument((batch.nextId == batch.lastId + 1L ? 1 : 0) != 0);
            while (true) {
                prevLastId = batch.lastId;
                batch.nextId = prevLastId + 1L;
                Preconditions.checkArgument((Long.MAX_VALUE - batch.lastId >= this.batchSize ? 1 : 0) != 0);
                nextLastId = batch.lastId + (sequenceIdName.equals(CERTIFICATE_ID) ? 1L : this.batchSize);
                if (this.stateManager.allocateBatch(sequenceIdName, prevLastId, nextLastId).booleanValue()) break;
                batch.lastId = this.stateManager.getLastId(sequenceIdName);
            }
            batch.lastId = nextLastId;
            LOG.info("Allocate a batch for {}, change lastId from {} to {}.", new Object[]{sequenceIdName, prevLastId, batch.lastId});
            Preconditions.checkArgument((batch.nextId <= batch.lastId ? 1 : 0) != 0);
            long l = batch.nextId++;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidateBatch() {
        this.lock.lock();
        try {
            this.invalidateBatchInternal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void invalidateBatchInternal() {
        this.sequenceIdToBatchMap.forEach((sequenceId, batch) -> ((Batch)batch).nextId = ((Batch)batch).lastId + 1L);
    }

    public void reinitialize(Table<String, Long> sequenceIdTable) throws IOException {
        LOG.info("reinitialize SequenceIdGenerator.");
        this.lock.lock();
        try {
            this.invalidateBatchInternal();
            this.stateManager.reinitialize(sequenceIdTable);
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void upgradeToSequenceId(SCMMetadataStore scmMetadataStore) throws IOException {
        Table sequenceIdTable = scmMetadataStore.getSequenceIdTable();
        if (sequenceIdTable.get((Object)LOCAL_ID) == null) {
            long millisSinceEpoch = TimeUnit.DAYS.toMillis(LocalDate.of(LocalDate.now().getYear() + 1, 1, 1).toEpochDay());
            long localId = millisSinceEpoch << 16;
            Preconditions.checkArgument((localId > UniqueId.next() ? 1 : 0) != 0);
            sequenceIdTable.put((Object)LOCAL_ID, (Object)localId);
            LOG.info("upgrade {} to {}", (Object)LOCAL_ID, sequenceIdTable.get((Object)LOCAL_ID));
        }
        if (sequenceIdTable.get((Object)DEL_TXN_ID) == null) {
            StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction txn = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)scmMetadataStore.getDeletedBlocksTXTable().get((Object)0L);
            sequenceIdTable.put((Object)DEL_TXN_ID, (Object)(txn != null ? txn.getTxID() : 0L));
            LOG.info("upgrade {} to {}", (Object)DEL_TXN_ID, sequenceIdTable.get((Object)DEL_TXN_ID));
        }
        if (sequenceIdTable.get((Object)CONTAINER_ID) == null) {
            long largestContainerId = 0L;
            try (TableIterator iterator = scmMetadataStore.getContainerTable().iterator();){
                while (iterator.hasNext()) {
                    ContainerInfo containerInfo = (ContainerInfo)((Table.KeyValue)iterator.next()).getValue();
                    largestContainerId = Long.max(containerInfo.getContainerID(), largestContainerId);
                }
            }
            sequenceIdTable.put((Object)CONTAINER_ID, (Object)largestContainerId);
            LOG.info("upgrade {} to {}", (Object)CONTAINER_ID, sequenceIdTable.get((Object)CONTAINER_ID));
        }
        SequenceIdGenerator.upgradeToCertificateSequenceId(scmMetadataStore, false);
    }

    public static void upgradeToCertificateSequenceId(SCMMetadataStore scmMetadataStore, boolean force) throws IOException {
        Table sequenceIdTable = scmMetadataStore.getSequenceIdTable();
        if (sequenceIdTable.get((Object)CERTIFICATE_ID) == null || force) {
            X509Certificate cert;
            long largestCertId = BigInteger.ONE.add(BigInteger.ONE).longValueExact();
            try (TableIterator iterator = scmMetadataStore.getValidSCMCertsTable().iterator();){
                while (iterator.hasNext()) {
                    cert = (X509Certificate)((Table.KeyValue)iterator.next()).getValue();
                    largestCertId = Long.max(cert.getSerialNumber().longValueExact(), largestCertId);
                }
            }
            iterator = scmMetadataStore.getValidCertsTable().iterator();
            var6_5 = null;
            try {
                while (iterator.hasNext()) {
                    cert = (X509Certificate)((Table.KeyValue)iterator.next()).getValue();
                    largestCertId = Long.max(cert.getSerialNumber().longValueExact(), largestCertId);
                }
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
            finally {
                if (iterator != null) {
                    if (var6_5 != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable) {
                            var6_5.addSuppressed(throwable);
                        }
                    } else {
                        iterator.close();
                    }
                }
            }
            sequenceIdTable.put((Object)CERTIFICATE_ID, (Object)largestCertId);
            LOG.info("upgrade {} to {}", (Object)CERTIFICATE_ID, sequenceIdTable.get((Object)CERTIFICATE_ID));
        }
        if (sequenceIdTable.get((Object)ROOT_CERTIFICATE_ID) != null) {
            sequenceIdTable.delete((Object)ROOT_CERTIFICATE_ID);
        }
    }

    static final class StateManagerImpl
    implements StateManager {
        private Table<String, Long> sequenceIdTable;
        private final DBTransactionBuffer transactionBuffer;
        private final Map<String, Long> sequenceIdToLastIdMap;

        private StateManagerImpl(Table<String, Long> sequenceIdTable, DBTransactionBuffer trxBuffer) {
            this.sequenceIdTable = sequenceIdTable;
            this.transactionBuffer = trxBuffer;
            this.sequenceIdToLastIdMap = new ConcurrentHashMap<String, Long>();
            LOG.info("Init the HA SequenceIdGenerator.");
        }

        @Override
        public Boolean allocateBatch(String sequenceIdName, Long expectedLastId, Long newLastId) {
            Long lastId = this.sequenceIdToLastIdMap.computeIfAbsent(sequenceIdName, key -> {
                try {
                    Long idInDb = (Long)this.sequenceIdTable.get(key);
                    return idInDb != null ? idInDb : 0L;
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Failed to get lastId from db", ioe);
                }
            });
            if (!lastId.equals(expectedLastId)) {
                LOG.warn("Failed to allocate a batch for {}, expected lastId is {}, actual lastId is {}.", new Object[]{sequenceIdName, expectedLastId, lastId});
                return false;
            }
            try {
                this.transactionBuffer.addToBuffer(this.sequenceIdTable, (Object)sequenceIdName, (Object)newLastId);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to put lastId to Batch", ioe);
            }
            this.sequenceIdToLastIdMap.put(sequenceIdName, newLastId);
            return true;
        }

        @Override
        public Long getLastId(String sequenceIdName) {
            return this.sequenceIdToLastIdMap.get(sequenceIdName);
        }

        @Override
        public void reinitialize(Table<String, Long> seqIdTable) throws IOException {
            this.sequenceIdTable = seqIdTable;
            this.sequenceIdToLastIdMap.clear();
            this.initialize();
        }

        private void initialize() throws IOException {
            try (TableIterator iterator = this.sequenceIdTable.iterator();){
                while (iterator.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)iterator.next();
                    String sequenceIdName = (String)kv.getKey();
                    Long lastId = (Long)kv.getValue();
                    Preconditions.checkNotNull((Object)sequenceIdName, (Object)"sequenceIdName should not be null");
                    Preconditions.checkNotNull((Object)lastId, (Object)"lastId should not be null");
                    this.sequenceIdToLastIdMap.put(sequenceIdName, lastId);
                }
            }
        }

        public static class Builder {
            private Table<String, Long> table;
            private DBTransactionBuffer buffer;
            private SCMRatisServer ratisServer;

            public Builder setRatisServer(SCMRatisServer scmRatisServer) {
                this.ratisServer = scmRatisServer;
                return this;
            }

            public Builder setSequenceIdTable(Table<String, Long> sequenceIdTable) {
                this.table = sequenceIdTable;
                return this;
            }

            public Builder setDBTransactionBuffer(DBTransactionBuffer trxBuffer) {
                this.buffer = trxBuffer;
                return this;
            }

            public StateManager build() {
                Preconditions.checkNotNull(this.table);
                Preconditions.checkNotNull((Object)this.buffer);
                StateManagerImpl impl = new StateManagerImpl(this.table, this.buffer);
                return this.ratisServer.getProxyHandler(SCMRatisProtocol.RequestType.SEQUENCE_ID, StateManager.class, impl);
            }
        }
    }

    static interface StateManager {
        @Replicate
        public Boolean allocateBatch(String var1, Long var2, Long var3) throws SCMException;

        public Long getLastId(String var1);

        public void reinitialize(Table<String, Long> var1) throws IOException;
    }

    static class Batch {
        private long lastId = 0L;
        private long nextId = this.lastId + 1L;

        Batch() {
        }
    }
}

