/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerLocationProtocolProtos;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerMoveInfo;
import org.apache.hadoop.hdds.scm.container.balancer.DataMoveInfo;
import org.apache.hadoop.hdds.scm.container.balancer.IterationInfo;

public class ContainerBalancerTaskIterationStatusInfo {
    private final IterationInfo iterationInfo;
    private final ContainerMoveInfo containerMoveInfo;
    private final DataMoveInfo dataMoveInfo;

    public ContainerBalancerTaskIterationStatusInfo(IterationInfo iterationInfo, ContainerMoveInfo containerMoveInfo, DataMoveInfo dataMoveInfo) {
        this.iterationInfo = iterationInfo;
        this.containerMoveInfo = containerMoveInfo;
        this.dataMoveInfo = dataMoveInfo;
    }

    public Integer getIterationNumber() {
        return this.iterationInfo.getIterationNumber();
    }

    public String getIterationResult() {
        return this.iterationInfo.getIterationResult();
    }

    public long getSizeScheduledForMove() {
        return this.dataMoveInfo.getSizeScheduledForMove();
    }

    public long getDataSizeMoved() {
        return this.dataMoveInfo.getDataSizeMoved();
    }

    public long getContainerMovesScheduled() {
        return this.containerMoveInfo.getContainerMovesScheduled();
    }

    public long getContainerMovesCompleted() {
        return this.containerMoveInfo.getContainerMovesCompleted();
    }

    public long getContainerMovesFailed() {
        return this.containerMoveInfo.getContainerMovesFailed();
    }

    public long getContainerMovesTimeout() {
        return this.containerMoveInfo.getContainerMovesTimeout();
    }

    public Map<UUID, Long> getSizeEnteringNodes() {
        return this.dataMoveInfo.getSizeEnteringNodes();
    }

    public Map<UUID, Long> getSizeLeavingNodes() {
        return this.dataMoveInfo.getSizeLeavingNodes();
    }

    public Long getIterationDuration() {
        return this.iterationInfo.getIterationDuration();
    }

    public StorageContainerLocationProtocolProtos.ContainerBalancerTaskIterationStatusInfoProto toProto() {
        return StorageContainerLocationProtocolProtos.ContainerBalancerTaskIterationStatusInfoProto.newBuilder().setIterationNumber(this.getIterationNumber().intValue()).setIterationResult(Optional.ofNullable(this.getIterationResult()).orElse("")).setIterationDuration(this.getIterationDuration().longValue()).setSizeScheduledForMove(this.getSizeScheduledForMove()).setDataSizeMoved(this.getDataSizeMoved()).setContainerMovesScheduled(this.getContainerMovesScheduled()).setContainerMovesCompleted(this.getContainerMovesCompleted()).setContainerMovesFailed(this.getContainerMovesFailed()).setContainerMovesTimeout(this.getContainerMovesTimeout()).addAllSizeEnteringNodes(this.mapToProtoNodeTransferInfo(this.getSizeEnteringNodes())).addAllSizeLeavingNodes(this.mapToProtoNodeTransferInfo(this.getSizeLeavingNodes())).build();
    }

    private List<StorageContainerLocationProtocolProtos.NodeTransferInfoProto> mapToProtoNodeTransferInfo(Map<UUID, Long> nodes) {
        return nodes.entrySet().stream().map(entry -> StorageContainerLocationProtocolProtos.NodeTransferInfoProto.newBuilder().setUuid(((UUID)entry.getKey()).toString()).setDataVolume(((Long)entry.getValue()).longValue()).build()).collect(Collectors.toList());
    }
}

