/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.upgrade;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.hadoop.ozone.recon.scm.ReconStorageContainerManagerFacade;
import org.apache.hadoop.ozone.recon.upgrade.ReconLayoutFeature;
import org.apache.hadoop.ozone.recon.upgrade.ReconUpgradeAction;
import org.apache.hadoop.ozone.recon.upgrade.UpgradeActionRecon;
import org.apache.ozone.recon.schema.ContainerSchemaDefinition;
import org.apache.ozone.recon.schema.SqlDbUtils;
import org.jooq.Constraint;
import org.jooq.DSLContext;
import org.jooq.Name;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UpgradeActionRecon(feature=ReconLayoutFeature.INITIAL_VERSION, type=ReconUpgradeAction.UpgradeActionType.FINALIZE)
public class InitialConstraintUpgradeAction
implements ReconUpgradeAction {
    private static final Logger LOG = LoggerFactory.getLogger(InitialConstraintUpgradeAction.class);
    private DataSource dataSource;
    private DSLContext dslContext;

    @Override
    public void execute(ReconStorageContainerManagerFacade scmFacade) throws SQLException {
        this.dataSource = scmFacade.getDataSource();
        try (Connection conn = this.dataSource.getConnection();){
            if (!SqlDbUtils.TABLE_EXISTS_CHECK.test(conn, "UNHEALTHY_CONTAINERS")) {
                return;
            }
            this.dslContext = DSL.using((Connection)conn);
            this.dropConstraint();
            this.addUpdatedConstraint();
        }
        catch (SQLException e) {
            throw new SQLException("Failed to execute InitialConstraintUpgradeAction", e);
        }
    }

    private void dropConstraint() {
        String constraintName = "UNHEALTHY_CONTAINERSck1";
        this.dslContext.alterTable("UNHEALTHY_CONTAINERS").dropConstraint(constraintName).execute();
        LOG.debug("Dropped the existing constraint: {}", (Object)constraintName);
    }

    private void addUpdatedConstraint() {
        Object[] enumStates = (String[])Arrays.stream(ContainerSchemaDefinition.UnHealthyContainerStates.values()).map(Enum::name).toArray(String[]::new);
        this.dslContext.alterTable("UNHEALTHY_CONTAINERS").add((Constraint)DSL.constraint((String)"UNHEALTHY_CONTAINERSck1").check(DSL.field((Name)DSL.name((String)"container_state")).in(enumStates))).execute();
        LOG.info("Added the updated constraint to the UNHEALTHY_CONTAINERS table for enum state values: {}", (Object)Arrays.toString(enumStates));
    }

    @Override
    public ReconUpgradeAction.UpgradeActionType getType() {
        return ReconUpgradeAction.UpgradeActionType.FINALIZE;
    }

    @VisibleForTesting
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @VisibleForTesting
    public void setDslContext(DSLContext dslContext) {
        this.dslContext = dslContext;
    }
}

