/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.recon.tasks.FileSizeCountTaskHelper;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.apache.ozone.recon.schema.UtilizationSchemaDefinition;
import org.apache.ozone.recon.schema.generated.tables.daos.FileCountBySizeDao;
import org.jooq.DSLContext;

public class FileSizeCountTaskFSO
implements ReconOmTask {
    private final FileCountBySizeDao fileCountBySizeDao;
    private final DSLContext dslContext;

    @Inject
    public FileSizeCountTaskFSO(FileCountBySizeDao fileCountBySizeDao, UtilizationSchemaDefinition utilizationSchemaDefinition) {
        this.fileCountBySizeDao = fileCountBySizeDao;
        this.dslContext = utilizationSchemaDefinition.getDSLContext();
    }

    @Override
    public ReconOmTask.TaskResult reprocess(OMMetadataManager omMetadataManager) {
        return FileSizeCountTaskHelper.reprocess(omMetadataManager, this.dslContext, this.fileCountBySizeDao, BucketLayout.FILE_SYSTEM_OPTIMIZED, this.getTaskName());
    }

    @Override
    public ReconOmTask.TaskResult process(OMUpdateEventBatch events, Map<String, Integer> subTaskSeekPosMap) {
        return FileSizeCountTaskHelper.processEvents(events, "fileTable", this.dslContext, this.fileCountBySizeDao, this.getTaskName());
    }

    @Override
    public String getTaskName() {
        return "FileSizeCountTaskFSO";
    }
}

