/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurationHandler;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.ScmUtils;
import org.apache.hadoop.hdds.scm.block.BlockManager;
import org.apache.hadoop.hdds.scm.container.CloseContainerEventHandler;
import org.apache.hadoop.hdds.scm.container.ContainerActionsHandler;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.balancer.ContainerBalancer;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.ContainerPlacementPolicyFactory;
import org.apache.hadoop.hdds.scm.container.placement.algorithms.SCMContainerPlacementMetrics;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaPendingOps;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMHAManager;
import org.apache.hadoop.hdds.scm.ha.SCMHAManagerStub;
import org.apache.hadoop.hdds.scm.ha.SCMNodeDetails;
import org.apache.hadoop.hdds.scm.ha.SequenceIdGenerator;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.scm.metadata.SCMDBTransactionBufferImpl;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.NetworkTopologyImpl;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.NodeReportHandler;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineActionHandler;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.server.events.Event;
import org.apache.hadoop.hdds.server.events.EventExecutor;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.EventQueue;
import org.apache.hadoop.hdds.server.events.FixedThreadPoolWithAffinityExecutor;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.recon.ReconContext;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.fsck.ContainerHealthTask;
import org.apache.hadoop.ozone.recon.fsck.ReconSafeModeMgrTask;
import org.apache.hadoop.ozone.recon.persistence.ContainerHealthSchemaManager;
import org.apache.hadoop.ozone.recon.scm.PipelineSyncTask;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.apache.hadoop.ozone.recon.scm.ReconContainerReportHandler;
import org.apache.hadoop.ozone.recon.scm.ReconDatanodeProtocolServer;
import org.apache.hadoop.ozone.recon.scm.ReconDeadNodeHandler;
import org.apache.hadoop.ozone.recon.scm.ReconIncrementalContainerReportHandler;
import org.apache.hadoop.ozone.recon.scm.ReconNewNodeHandler;
import org.apache.hadoop.ozone.recon.scm.ReconNodeManager;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineReportHandler;
import org.apache.hadoop.ozone.recon.scm.ReconSCMDBDefinition;
import org.apache.hadoop.ozone.recon.scm.ReconSafeModeManager;
import org.apache.hadoop.ozone.recon.scm.ReconScmTask;
import org.apache.hadoop.ozone.recon.scm.ReconStaleNodeHandler;
import org.apache.hadoop.ozone.recon.scm.ReconStorageConfig;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;
import org.apache.hadoop.ozone.recon.spi.StorageContainerServiceProvider;
import org.apache.hadoop.ozone.recon.tasks.ContainerSizeCountTask;
import org.apache.hadoop.ozone.recon.tasks.ReconTaskConfig;
import org.apache.hadoop.ozone.recon.tasks.updater.ReconTaskStatusUpdaterManager;
import org.apache.ozone.recon.schema.UtilizationSchemaDefinition;
import org.apache.ozone.recon.schema.generated.tables.daos.ContainerCountBySizeDao;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconStorageContainerManagerFacade
implements OzoneStorageContainerManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconStorageContainerManagerFacade.class);
    public static final long CONTAINER_METADATA_SIZE = 0x100000L;
    private final OzoneConfiguration ozoneConfiguration;
    private final ReconDatanodeProtocolServer datanodeProtocolServer;
    private final EventQueue eventQueue;
    private final SCMContext scmContext;
    private final ReconContext reconContext;
    private final SCMStorageConfig scmStorageConfig;
    private final SCMNodeDetails reconNodeDetails;
    private final SCMHAManager scmhaManager;
    private final SequenceIdGenerator sequenceIdGen;
    private final ContainerHealthTask containerHealthTask;
    private final DataSource dataSource;
    private DBStore dbStore;
    private ReconNodeManager nodeManager;
    private ReconPipelineManager pipelineManager;
    private ReconContainerManager containerManager;
    private NetworkTopology clusterMap;
    private StorageContainerServiceProvider scmServiceProvider;
    private Set<ReconScmTask> reconScmTasks = new HashSet<ReconScmTask>();
    private SCMContainerPlacementMetrics placementMetrics;
    private PlacementPolicy containerPlacementPolicy;
    private HDDSLayoutVersionManager scmLayoutVersionManager;
    private ReconSafeModeManager safeModeManager;
    private ReconSafeModeMgrTask reconSafeModeMgrTask;
    private ContainerSizeCountTask containerSizeCountTask;
    private ContainerCountBySizeDao containerCountBySizeDao;
    private ScheduledExecutorService scheduler;
    private AtomicBoolean isSyncDataFromSCMRunning;
    private final String threadNamePrefix;

    @Inject
    public ReconStorageContainerManagerFacade(OzoneConfiguration conf, StorageContainerServiceProvider scmServiceProvider, ContainerCountBySizeDao containerCountBySizeDao, UtilizationSchemaDefinition utilizationSchemaDefinition, ContainerHealthSchemaManager containerHealthSchemaManager, ReconContainerMetadataManager reconContainerMetadataManager, ReconUtils reconUtils, ReconSafeModeManager safeModeManager, ReconContext reconContext, DataSource dataSource, ReconTaskStatusUpdaterManager taskStatusUpdaterManager) throws IOException {
        this.reconNodeDetails = reconUtils.getReconNodeDetails(conf);
        this.threadNamePrefix = this.reconNodeDetails.threadNamePrefix();
        this.eventQueue = new EventQueue(this.threadNamePrefix);
        this.eventQueue.setSilent(true);
        this.reconContext = reconContext;
        this.scmContext = new SCMContext.Builder().setIsPreCheckComplete(true).setSCM((OzoneStorageContainerManager)this).build();
        this.ozoneConfiguration = this.getReconScmConfiguration(conf);
        long scmClientRPCTimeOut = conf.getTimeDuration("ozone.recon.scmclient.rpc.timeout", "1m", TimeUnit.MILLISECONDS);
        long scmClientMaxRetryTimeOut = conf.getTimeDuration("ozone.recon.scmclient.max.retry.timeout", "6s", TimeUnit.MILLISECONDS);
        int scmClientFailOverMaxRetryCount = conf.getInt("ozone.recon.scmclient.failover.max.retry", 3);
        conf.setLong("hdds.scmclient.rpc.timeout", scmClientRPCTimeOut);
        conf.setLong("hdds.scmclient.max.retry.timeout", scmClientMaxRetryTimeOut);
        conf.setLong("hdds.scmclient.failover.max.retry", (long)scmClientFailOverMaxRetryCount);
        this.scmStorageConfig = new ReconStorageConfig(conf, reconUtils);
        this.clusterMap = new NetworkTopologyImpl((ConfigurationSource)conf);
        this.dbStore = DBStoreBuilder.createDBStore((ConfigurationSource)this.ozoneConfiguration, (DBDefinition)ReconSCMDBDefinition.get());
        this.scmLayoutVersionManager = new HDDSLayoutVersionManager(this.scmStorageConfig.getLayoutVersion());
        this.scmhaManager = SCMHAManagerStub.getInstance((boolean)true, (DBTransactionBuffer)new SCMDBTransactionBufferImpl());
        this.sequenceIdGen = new SequenceIdGenerator((ConfigurationSource)conf, this.scmhaManager, ReconSCMDBDefinition.SEQUENCE_ID.getTable(this.dbStore));
        reconContext.setClusterId(this.scmStorageConfig.getClusterID());
        this.nodeManager = new ReconNodeManager(conf, this.scmStorageConfig, this.eventQueue, this.clusterMap, (Table<UUID, DatanodeDetails>)ReconSCMDBDefinition.NODES.getTable(this.dbStore), this.scmLayoutVersionManager, reconContext);
        this.placementMetrics = SCMContainerPlacementMetrics.create();
        this.containerPlacementPolicy = ContainerPlacementPolicyFactory.getPolicy((ConfigurationSource)conf, (NodeManager)this.nodeManager, (NetworkTopology)this.clusterMap, (boolean)true, (SCMContainerPlacementMetrics)this.placementMetrics);
        this.datanodeProtocolServer = new ReconDatanodeProtocolServer(conf, this, (EventPublisher)this.eventQueue);
        this.pipelineManager = ReconPipelineManager.newReconPipelineManager((ConfigurationSource)conf, (NodeManager)this.nodeManager, (Table<PipelineID, Pipeline>)ReconSCMDBDefinition.PIPELINES.getTable(this.dbStore), (EventPublisher)this.eventQueue, this.scmhaManager, this.scmContext);
        ContainerReplicaPendingOps pendingOps = new ContainerReplicaPendingOps(Clock.system(ZoneId.systemDefault()));
        this.containerManager = new ReconContainerManager((Configuration)conf, this.dbStore, (Table<ContainerID, ContainerInfo>)ReconSCMDBDefinition.CONTAINERS.getTable(this.dbStore), (PipelineManager)this.pipelineManager, scmServiceProvider, containerHealthSchemaManager, reconContainerMetadataManager, this.scmhaManager, this.sequenceIdGen, pendingOps);
        this.scmServiceProvider = scmServiceProvider;
        this.isSyncDataFromSCMRunning = new AtomicBoolean();
        this.containerCountBySizeDao = containerCountBySizeDao;
        NodeReportHandler nodeReportHandler = new NodeReportHandler((NodeManager)this.nodeManager);
        this.safeModeManager = safeModeManager;
        ReconPipelineReportHandler pipelineReportHandler = new ReconPipelineReportHandler(safeModeManager, (PipelineManager)this.pipelineManager, this.scmContext, (ConfigurationSource)conf, scmServiceProvider);
        PipelineActionHandler pipelineActionHandler = new PipelineActionHandler((PipelineManager)this.pipelineManager, this.scmContext);
        ReconTaskConfig reconTaskConfig = (ReconTaskConfig)conf.getObject(ReconTaskConfig.class);
        PipelineSyncTask pipelineSyncTask = new PipelineSyncTask(this.pipelineManager, this.nodeManager, scmServiceProvider, reconTaskConfig, taskStatusUpdaterManager);
        this.containerHealthTask = new ContainerHealthTask((ContainerManager)this.containerManager, scmServiceProvider, containerHealthSchemaManager, this.containerPlacementPolicy, reconTaskConfig, reconContainerMetadataManager, conf, taskStatusUpdaterManager);
        this.containerSizeCountTask = new ContainerSizeCountTask((ContainerManager)this.containerManager, reconTaskConfig, containerCountBySizeDao, utilizationSchemaDefinition, taskStatusUpdaterManager);
        this.dataSource = dataSource;
        ReconStaleNodeHandler staleNodeHandler = new ReconStaleNodeHandler((NodeManager)this.nodeManager, (PipelineManager)this.pipelineManager, pipelineSyncTask);
        ReconDeadNodeHandler deadNodeHandler = new ReconDeadNodeHandler((NodeManager)this.nodeManager, (PipelineManager)this.pipelineManager, (ContainerManager)this.containerManager, scmServiceProvider, this.containerHealthTask, pipelineSyncTask);
        ReconContainerReportHandler containerReportHandler = new ReconContainerReportHandler((NodeManager)this.nodeManager, (ContainerManager)this.containerManager);
        ReconIncrementalContainerReportHandler icrHandler = new ReconIncrementalContainerReportHandler((NodeManager)this.nodeManager, (ContainerManager)this.containerManager, this.scmContext);
        CloseContainerEventHandler closeContainerHandler = new CloseContainerEventHandler((PipelineManager)this.pipelineManager, (ContainerManager)this.containerManager, this.scmContext, null, 0L);
        ContainerActionsHandler actionsHandler = new ContainerActionsHandler();
        ReconNewNodeHandler newNodeHandler = new ReconNewNodeHandler(this.nodeManager);
        long waitQueueThreshold = this.ozoneConfiguration.getInt(ScmUtils.getContainerReportConfPrefix() + ".queue.wait.threshold", 60000);
        long execWaitThreshold = this.ozoneConfiguration.getInt(ScmUtils.getContainerReportConfPrefix() + ".execute.wait.threshold", 120000);
        List<BlockingQueue<SCMDatanodeHeartbeatDispatcher.ContainerReport>> queues = ReconUtils.initContainerReportQueue(this.ozoneConfiguration);
        List executors = FixedThreadPoolWithAffinityExecutor.initializeExecutorPool((String)this.threadNamePrefix, queues);
        ConcurrentHashMap reportExecutorMap = new ConcurrentHashMap();
        FixedThreadPoolWithAffinityExecutor containerReportExecutors = new FixedThreadPoolWithAffinityExecutor(EventQueue.getExecutorName((Event)SCMEvents.CONTAINER_REPORT, (EventHandler)containerReportHandler), (EventHandler)containerReportHandler, queues, (EventPublisher)this.eventQueue, SCMDatanodeHeartbeatDispatcher.ContainerReportFromDatanode.class, executors, reportExecutorMap);
        containerReportExecutors.setQueueWaitThreshold(waitQueueThreshold);
        containerReportExecutors.setExecWaitThreshold(execWaitThreshold);
        FixedThreadPoolWithAffinityExecutor incrementalReportExecutors = new FixedThreadPoolWithAffinityExecutor(EventQueue.getExecutorName((Event)SCMEvents.INCREMENTAL_CONTAINER_REPORT, (EventHandler)icrHandler), (EventHandler)icrHandler, queues, (EventPublisher)this.eventQueue, SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode.class, executors, reportExecutorMap);
        incrementalReportExecutors.setQueueWaitThreshold(waitQueueThreshold);
        incrementalReportExecutors.setExecWaitThreshold(execWaitThreshold);
        this.eventQueue.addHandler((Event)SCMEvents.CONTAINER_REPORT, (EventExecutor)containerReportExecutors, (EventHandler)containerReportHandler);
        this.eventQueue.addHandler((Event)SCMEvents.INCREMENTAL_CONTAINER_REPORT, (EventExecutor)incrementalReportExecutors, (EventHandler)icrHandler);
        this.eventQueue.addHandler(SCMEvents.DATANODE_COMMAND, (EventHandler)this.nodeManager);
        this.eventQueue.addHandler((Event)SCMEvents.NODE_REPORT, (EventHandler)nodeReportHandler);
        this.eventQueue.addHandler((Event)SCMEvents.PIPELINE_REPORT, (EventHandler)pipelineReportHandler);
        this.eventQueue.addHandler((Event)SCMEvents.PIPELINE_ACTIONS, (EventHandler)pipelineActionHandler);
        this.eventQueue.addHandler((Event)SCMEvents.STALE_NODE, (EventHandler)staleNodeHandler);
        this.eventQueue.addHandler((Event)SCMEvents.DEAD_NODE, (EventHandler)deadNodeHandler);
        this.eventQueue.addHandler((Event)SCMEvents.CONTAINER_ACTIONS, (EventHandler)actionsHandler);
        this.eventQueue.addHandler((Event)SCMEvents.CLOSE_CONTAINER, (EventHandler)closeContainerHandler);
        this.eventQueue.addHandler((Event)SCMEvents.NEW_NODE, (EventHandler)newNodeHandler);
        this.reconScmTasks.add(pipelineSyncTask);
        this.reconScmTasks.add(this.containerHealthTask);
        this.reconScmTasks.add(this.containerSizeCountTask);
        this.reconSafeModeMgrTask = new ReconSafeModeMgrTask((ContainerManager)this.containerManager, this.nodeManager, safeModeManager, reconTaskConfig, this.ozoneConfiguration);
    }

    private OzoneConfiguration getReconScmConfiguration(OzoneConfiguration configuration) {
        OzoneConfiguration reconScmConfiguration = new OzoneConfiguration((Configuration)configuration);
        Map reconScmConfigs = configuration.getPropsMatchPrefixAndTrimPrefix("ozone.recon.scmconfig");
        for (Map.Entry entry : reconScmConfigs.entrySet()) {
            reconScmConfiguration.set((String)entry.getKey(), (String)entry.getValue());
        }
        return reconScmConfiguration;
    }

    public void start() {
        if (LOG.isInfoEnabled()) {
            LOG.info(StorageContainerManager.buildRpcServerStartMessage((String)"Recon ScmDatanodeProtocol RPC server", (InetSocketAddress)this.getDatanodeProtocolServer().getDatanodeRpcAddress()));
        }
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat(this.threadNamePrefix + "SyncSCMContainerInfo-%d").build());
        boolean isSCMSnapshotEnabled = this.ozoneConfiguration.getBoolean("ozone.recon.scm.snapshot.enabled", true);
        if (isSCMSnapshotEnabled) {
            this.initializeSCMDB();
            LOG.info("SCM DB initialized");
        } else {
            this.initializePipelinesFromScm();
        }
        LOG.debug("Started the SCM Container Info sync scheduler.");
        long interval = this.ozoneConfiguration.getTimeDuration("ozone.recon.scm.snapshot.task.interval.delay", "24h", TimeUnit.MILLISECONDS);
        long initialDelay = this.ozoneConfiguration.getTimeDuration("ozone.recon.scm.snapshot.task.initial.delay", "1m", TimeUnit.MILLISECONDS);
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                boolean isSuccess = this.syncWithSCMContainerInfo();
                if (!isSuccess) {
                    LOG.debug("SCM container info sync is already running.");
                }
            }
            catch (Throwable t) {
                LOG.error("Unexpected exception while syncing data from SCM.", t);
            }
            finally {
                this.isSyncDataFromSCMRunning.compareAndSet(true, false);
            }
        }, initialDelay, interval, TimeUnit.MILLISECONDS);
        this.getDatanodeProtocolServer().start();
        this.reconSafeModeMgrTask.start();
        if (!this.safeModeManager.getInSafeMode()) {
            this.reconScmTasks.forEach(ReconScmTask::start);
        }
    }

    public void join() {
        try {
            this.getDatanodeProtocolServer().join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during StorageContainerManager join.");
        }
    }

    public void stop() {
        this.getDatanodeProtocolServer().stop();
        this.reconScmTasks.forEach(ReconScmTask::stop);
        try {
            LOG.info("Stopping SCM Event Queue.");
            this.eventQueue.close();
        }
        catch (Exception ex) {
            LOG.error("SCM Event Queue stop failed", (Throwable)ex);
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.nodeManager});
        IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.containerManager});
        IOUtils.cleanupWithLogger((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.pipelineManager});
        LOG.info("Flushing container replica history to DB.");
        this.containerManager.flushReplicaHistoryMapToDB(true);
        IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.dbStore});
    }

    public void shutDown(String message) {
        this.stop();
        ExitUtils.terminate((int)0, (String)message, (Logger)LOG);
    }

    public ReconDatanodeProtocolServer getDatanodeProtocolServer() {
        return this.datanodeProtocolServer;
    }

    private void initializePipelinesFromScm() {
        try {
            List<Pipeline> pipelinesFromScm = this.scmServiceProvider.getPipelines();
            LOG.info("Obtained {} pipelines from SCM.", (Object)pipelinesFromScm.size());
            this.pipelineManager.initializePipelines(pipelinesFromScm);
        }
        catch (IOException ioEx) {
            LOG.error("Exception encountered while getting pipelines from SCM.", (Throwable)ioEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSCMDB() {
        try {
            long scmContainersCount = this.scmServiceProvider.getContainerCount();
            long reconContainerCount = this.containerManager.getContainers().size();
            long threshold = this.ozoneConfiguration.getInt("ozone.recon.scm.container.threshold", 100);
            if (Math.abs(scmContainersCount - reconContainerCount) > threshold) {
                LOG.info("Recon Container Count: {}, SCM Container Count: {}", (Object)reconContainerCount, (Object)scmContainersCount);
                this.updateReconSCMDBWithNewSnapshot();
                LOG.info("Updated Recon DB with SCM DB");
            } else {
                this.initializePipelinesFromScm();
            }
        }
        catch (IOException e) {
            LOG.error("Exception encountered while getting SCM DB.");
        }
        finally {
            this.isSyncDataFromSCMRunning.compareAndSet(true, false);
        }
    }

    public void updateReconSCMDBWithNewSnapshot() throws IOException {
        if (this.isSyncDataFromSCMRunning.compareAndSet(false, true)) {
            DBCheckpoint dbSnapshot = this.scmServiceProvider.getSCMDBSnapshot();
            if (dbSnapshot != null && dbSnapshot.getCheckpointLocation() != null) {
                LOG.info("Got new checkpoint from SCM : " + dbSnapshot.getCheckpointLocation());
                try {
                    this.initializeNewRdbStore(dbSnapshot.getCheckpointLocation().toFile());
                }
                catch (IOException e) {
                    LOG.error("Unable to refresh Recon SCM DB Snapshot. ", (Throwable)e);
                }
            } else {
                LOG.error("Null snapshot location got from SCM.");
            }
        } else {
            LOG.warn("SCM DB sync is already running.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean syncWithSCMContainerInfo() throws IOException {
        if (this.isSyncDataFromSCMRunning.compareAndSet(false, true)) {
            try {
                List containers = this.containerManager.getContainers();
                long totalContainerCount = this.scmServiceProvider.getContainerCount(HddsProtos.LifeCycleState.CLOSED);
                long containerCountPerCall = this.getContainerCountPerCall(totalContainerCount);
                long startContainerId = 1L;
                if (totalContainerCount <= 0L) return true;
                for (long retrievedContainerCount = 0L; retrievedContainerCount < totalContainerCount; retrievedContainerCount += containerCountPerCall) {
                    List<ContainerInfo> listOfContainers = this.scmServiceProvider.getListOfContainers(startContainerId, Long.valueOf(containerCountPerCall).intValue(), HddsProtos.LifeCycleState.CLOSED);
                    if (null == listOfContainers || listOfContainers.isEmpty()) {
                        LOG.info("No containers found at SCM in CLOSED state");
                        return false;
                    }
                    LOG.info("Got list of containers from SCM : " + listOfContainers.size());
                    listOfContainers.forEach(containerInfo -> {
                        long containerID = containerInfo.getContainerID();
                        boolean isContainerPresentAtRecon = containers.contains(containerInfo);
                        if (!isContainerPresentAtRecon) {
                            try {
                                ContainerWithPipeline containerWithPipeline = this.scmServiceProvider.getContainerWithPipeline(containerID);
                                this.containerManager.addNewContainer(containerWithPipeline);
                            }
                            catch (IOException e) {
                                LOG.error("Could not get container with pipeline for container : {}", (Object)containerID);
                            }
                        }
                    });
                    startContainerId = listOfContainers.get(listOfContainers.size() - 1).getContainerID() + 1L;
                }
                return true;
            }
            catch (IOException e) {
                LOG.error("Unable to refresh Recon SCM DB Snapshot. ", (Throwable)e);
                return false;
            }
        } else {
            LOG.debug("SCM DB sync is already running.");
            return false;
        }
    }

    private long getContainerCountPerCall(long totalContainerCount) {
        long containersMetaDataTotalRpcRespSizeMB = 0x100000L * totalContainerCount;
        long hadoopRPCSize = this.ozoneConfiguration.getInt("ipc.maximum.data.length", 0x8000000);
        long containerCountPerCall = containersMetaDataTotalRpcRespSizeMB <= hadoopRPCSize ? totalContainerCount : Math.round(Math.floor((double)hadoopRPCSize / 1048576.0));
        return containerCountPerCall;
    }

    private void deleteOldSCMDB() throws IOException {
        File oldDBLocation;
        if (this.dbStore != null && (oldDBLocation = this.dbStore.getDbLocation()).exists()) {
            LOG.info("Cleaning up old SCM snapshot db at {}.", (Object)oldDBLocation.getAbsolutePath());
            FileUtils.deleteDirectory((File)oldDBLocation);
        }
    }

    private void initializeNewRdbStore(File dbFile) throws IOException {
        try {
            DBStore newStore = this.createDBAndAddSCMTablesAndCodecs(dbFile, ReconSCMDBDefinition.get());
            Table nodeTable = ReconSCMDBDefinition.NODES.getTable(this.dbStore);
            Table newNodeTable = ReconSCMDBDefinition.NODES.getTable(newStore);
            try (TableIterator iterator = nodeTable.iterator();){
                while (iterator.hasNext()) {
                    Table.KeyValue keyValue = (Table.KeyValue)iterator.next();
                    newNodeTable.put(keyValue.getKey(), keyValue.getValue());
                }
            }
            this.sequenceIdGen.reinitialize(ReconSCMDBDefinition.SEQUENCE_ID.getTable(newStore));
            this.pipelineManager.reinitialize(ReconSCMDBDefinition.PIPELINES.getTable(newStore));
            this.containerManager.reinitialize(ReconSCMDBDefinition.CONTAINERS.getTable(newStore));
            this.nodeManager.reinitialize((Table<UUID, DatanodeDetails>)ReconSCMDBDefinition.NODES.getTable(newStore));
            IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.dbStore});
            this.deleteOldSCMDB();
            this.dbStore = newStore;
            File newDb = new File(dbFile.getParent() + "/" + "recon-scm.db");
            boolean success = dbFile.renameTo(newDb);
            if (success) {
                LOG.info("SCM snapshot linked to Recon DB.");
            }
            LOG.info("Created SCM DB handle from snapshot at {}.", (Object)dbFile.getAbsolutePath());
        }
        catch (IOException ioEx) {
            LOG.error("Unable to initialize Recon SCM DB snapshot store.", (Throwable)ioEx);
        }
    }

    private DBStore createDBAndAddSCMTablesAndCodecs(File dbFile, ReconSCMDBDefinition definition) throws IOException {
        DBStoreBuilder dbStoreBuilder = DBStoreBuilder.newBuilder((ConfigurationSource)this.ozoneConfiguration).setName(dbFile.getName()).setPath(dbFile.toPath().getParent());
        for (DBColumnFamilyDefinition columnFamily : definition.getColumnFamilies()) {
            dbStoreBuilder.addTable(columnFamily.getName());
            dbStoreBuilder.addCodec(columnFamily.getKeyType(), columnFamily.getKeyCodec());
            dbStoreBuilder.addCodec(columnFamily.getValueType(), columnFamily.getValueCodec());
        }
        return dbStoreBuilder.build();
    }

    public NodeManager getScmNodeManager() {
        return this.nodeManager;
    }

    public BlockManager getScmBlockManager() {
        return null;
    }

    public PipelineManager getPipelineManager() {
        return this.pipelineManager;
    }

    public ContainerManager getContainerManager() {
        return this.containerManager;
    }

    public ReplicationManager getReplicationManager() {
        return null;
    }

    public ContainerBalancer getContainerBalancer() {
        return null;
    }

    public InetSocketAddress getDatanodeRpcAddress() {
        return this.getDatanodeProtocolServer().getDatanodeRpcAddress();
    }

    public SCMNodeDetails getScmNodeDetails() {
        return this.reconNodeDetails;
    }

    public ReconfigurationHandler getReconfigurationHandler() {
        return null;
    }

    public DBStore getScmDBStore() {
        return this.dbStore;
    }

    public EventQueue getEventQueue() {
        return this.eventQueue;
    }

    public StorageContainerServiceProvider getScmServiceProvider() {
        return this.scmServiceProvider;
    }

    @VisibleForTesting
    public ContainerSizeCountTask getContainerSizeCountTask() {
        return this.containerSizeCountTask;
    }

    @VisibleForTesting
    public ContainerHealthTask getContainerHealthTask() {
        return this.containerHealthTask;
    }

    @VisibleForTesting
    public ContainerCountBySizeDao getContainerCountBySizeDao() {
        return this.containerCountBySizeDao;
    }

    public ReconContext getReconContext() {
        return this.reconContext;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

