/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.scm;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.IncrementalContainerReportHandler;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.node.states.NodeNotFoundException;
import org.apache.hadoop.hdds.scm.server.SCMDatanodeHeartbeatDispatcher;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.recon.scm.ReconContainerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconIncrementalContainerReportHandler
extends IncrementalContainerReportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ReconIncrementalContainerReportHandler.class);

    public ReconIncrementalContainerReportHandler(NodeManager nodeManager, ContainerManager containerManager, SCMContext scmContext) {
        super(nodeManager, containerManager, scmContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(SCMDatanodeHeartbeatDispatcher.IncrementalContainerReportFromDatanode report, EventPublisher publisher) {
        DatanodeDetails dd;
        DatanodeDetails dnFromReport = report.getDatanodeDetails();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing incremental container report from data node {}", (Object)dnFromReport);
        }
        if ((dd = this.getNodeManager().getNodeByUuid(dnFromReport.getUuid())) == null) {
            LOG.warn("Received container report from unknown datanode {}", (Object)dnFromReport);
            return;
        }
        ReconContainerManager containerManager = (ReconContainerManager)this.getContainerManager();
        try {
            containerManager.checkAndAddNewContainerBatch(((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)report.getReport()).getReportList());
        }
        catch (Exception ioEx) {
            LOG.error("Exception while checking and adding new container.", (Throwable)ioEx);
            return;
        }
        boolean success = true;
        for (StorageContainerDatanodeProtocolProtos.ContainerReplicaProto replicaProto : ((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)report.getReport()).getReportList()) {
            ContainerID id = ContainerID.valueOf((long)replicaProto.getContainerID());
            ContainerInfo container = null;
            try {
                try {
                    container = this.getContainerManager().getContainer(id);
                    id = container.containerID();
                }
                finally {
                    if (replicaProto.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.DELETED)) {
                        this.getNodeManager().removeContainer(dd, id);
                    } else {
                        this.getNodeManager().addContainer(dd, id);
                    }
                }
                this.processContainerReplica(dd, replicaProto, publisher);
                success = true;
            }
            catch (NodeNotFoundException ex) {
                success = false;
                LOG.error("Received ICR from unknown datanode {}.", (Object)report.getDatanodeDetails(), (Object)ex);
            }
            catch (IOException | TimeoutException | InvalidStateTransitionException e) {
                success = false;
                LOG.error("Exception while processing ICR for container {}", (Object)replicaProto.getContainerID());
            }
        }
        containerManager.notifyContainerReportProcessing(false, success);
    }
}

