/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.fsck;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.ContainerPlacementStatus;
import org.apache.hadoop.hdds.scm.PlacementPolicy;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.ContainerReplica;
import org.apache.hadoop.hdds.scm.container.replication.ContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ECContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.RatisContainerReplicaCount;
import org.apache.hadoop.hdds.scm.container.replication.ReplicationManager;
import org.apache.hadoop.ozone.recon.spi.ReconContainerMetadataManager;

public class ContainerHealthStatus {
    private final ContainerInfo container;
    private final int replicaDelta;
    private final Set<ContainerReplica> healthyReplicas;
    private final Set<ContainerReplica> healthyAvailReplicas;
    private final ContainerPlacementStatus placementStatus;
    private final ReconContainerMetadataManager reconContainerMetadataManager;
    private final int numReplicas;
    private final long numKeys;
    private final ContainerReplicaCount containerReplicaCount;

    ContainerHealthStatus(ContainerInfo container, Set<ContainerReplica> replicas, PlacementPolicy placementPolicy, ReconContainerMetadataManager reconContainerMetadataManager, OzoneConfiguration conf) {
        this.reconContainerMetadataManager = reconContainerMetadataManager;
        this.container = container;
        int repFactor = container.getReplicationConfig().getRequiredNodes();
        this.healthyReplicas = replicas.stream().filter(r -> !r.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY)).collect(Collectors.toSet());
        this.healthyAvailReplicas = replicas.stream().filter(r -> !r.getDatanodeDetails().isDecommissioned() && !r.getDatanodeDetails().isMaintenance() && !r.getState().equals((Object)StorageContainerDatanodeProtocolProtos.ContainerReplicaProto.State.UNHEALTHY)).collect(Collectors.toSet());
        this.replicaDelta = repFactor - this.healthyAvailReplicas.size();
        this.placementStatus = this.getPlacementStatus(placementPolicy, repFactor);
        this.numReplicas = replicas.size();
        this.numKeys = this.getContainerKeyCount(container.getContainerID());
        this.containerReplicaCount = this.getContainerReplicaCountInstance(conf, replicas);
    }

    public long getContainerID() {
        return this.container.getContainerID();
    }

    public ContainerInfo getContainer() {
        return this.container;
    }

    public int getReplicationFactor() {
        return this.container.getReplicationConfig().getRequiredNodes();
    }

    public boolean isHealthy() {
        return this.containerReplicaCount.isHealthy();
    }

    public boolean isSufficientlyReplicated() {
        return this.containerReplicaCount.isSufficientlyReplicated();
    }

    public boolean isHealthilyReplicated() {
        return this.replicaDelta == 0 && !this.isMisReplicated();
    }

    public boolean isDeleted() {
        return this.container.getState() == HddsProtos.LifeCycleState.DELETED || this.container.getState() == HddsProtos.LifeCycleState.DELETING;
    }

    public boolean isOverReplicated() {
        return this.containerReplicaCount.isOverReplicated();
    }

    public boolean isUnderReplicated() {
        return !this.isMissing() && !this.containerReplicaCount.isSufficientlyReplicated();
    }

    public int replicaDelta() {
        return this.replicaDelta;
    }

    public int getReplicaCount() {
        return this.healthyAvailReplicas.size();
    }

    public boolean isMisReplicated() {
        return !this.isMissing() && !this.placementStatus.isPolicySatisfied();
    }

    public int misReplicatedDelta() {
        return this.placementStatus.misReplicationCount();
    }

    public int expectedPlacementCount() {
        return this.placementStatus.expectedPlacementCount();
    }

    public int actualPlacementCount() {
        return this.placementStatus.actualPlacementCount();
    }

    public String misReplicatedReason() {
        return this.placementStatus.misReplicatedReason();
    }

    public boolean isMissing() {
        return this.numReplicas == 0;
    }

    public boolean isEmpty() {
        return this.numKeys == 0L;
    }

    private ContainerPlacementStatus getPlacementStatus(PlacementPolicy policy, int repFactor) {
        List dns = this.healthyReplicas.stream().map(ContainerReplica::getDatanodeDetails).collect(Collectors.toList());
        return policy.validateContainerPlacement(dns, repFactor);
    }

    private long getContainerKeyCount(long containerID) {
        try {
            return this.reconContainerMetadataManager.getKeyCountForContainer(containerID);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getNumKeys() {
        return this.numKeys;
    }

    private ContainerReplicaCount getContainerReplicaCountInstance(OzoneConfiguration conf, Set<ContainerReplica> replicas) {
        ReplicationManager.ReplicationManagerConfiguration rmConf = (ReplicationManager.ReplicationManagerConfiguration)conf.getObject(ReplicationManager.ReplicationManagerConfiguration.class);
        boolean isEC = this.container.getReplicationConfig().getReplicationType() == HddsProtos.ReplicationType.EC;
        return isEC ? new ECContainerReplicaCount(this.container, replicas, new ArrayList(), rmConf.getMaintenanceRemainingRedundancy()) : new RatisContainerReplicaCount(this.container, replicas, new ArrayList(), rmConf.getMaintenanceReplicaMinimum(), false);
    }
}

