/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.handlers;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.types.DUResponse;
import org.apache.hadoop.ozone.recon.api.types.EntityType;
import org.apache.hadoop.ozone.recon.api.types.NSSummary;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

public class OBSBucketHandler
extends BucketHandler {
    private final String vol;
    private final String bucket;
    private final OmBucketInfo omBucketInfo;

    public OBSBucketHandler(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OmBucketInfo bucketInfo) {
        super(reconNamespaceSummaryManager, omMetadataManager);
        this.omBucketInfo = bucketInfo;
        this.vol = this.omBucketInfo.getVolumeName();
        this.bucket = this.omBucketInfo.getBucketName();
    }

    @Override
    public EntityType determineKeyPath(String keyName) throws IOException {
        String key = "/" + this.vol + "/" + this.bucket + "/" + keyName;
        Table<String, OmKeyInfo> keyTable = this.getKeyTable();
        try (TableIterator iterator = keyTable.iterator();){
            Table.KeyValue kv;
            String dbKey;
            iterator.seek((Object)key);
            if (iterator.hasNext() && (dbKey = (String)(kv = (Table.KeyValue)iterator.next()).getKey()).equals(key)) {
                EntityType entityType = EntityType.KEY;
                return entityType;
            }
        }
        return EntityType.UNKNOWN;
    }

    @Override
    public long handleDirectKeys(long parentId, boolean withReplica, boolean listFile, List<DUResponse.DiskUsage> duData, String normalizedPath) throws IOException {
        NSSummary nsSummary = this.getReconNamespaceSummaryManager().getNSSummary(parentId);
        if (nsSummary == null) {
            return 0L;
        }
        Table<String, OmKeyInfo> keyTable = this.getKeyTable();
        long keyDataSizeWithReplica = 0L;
        try (TableIterator iterator = keyTable.iterator();){
            String seekPrefix = "/" + this.vol + "/" + this.bucket + "/";
            iterator.seek((Object)seekPrefix);
            while (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                String dbKey = (String)kv.getKey();
                if (!dbKey.startsWith(seekPrefix)) {
                    break;
                }
                OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
                if (keyInfo == null) continue;
                DUResponse.DiskUsage diskUsage = new DUResponse.DiskUsage();
                String objectName = keyInfo.getKeyName();
                diskUsage.setSubpath(objectName);
                diskUsage.setKey(true);
                diskUsage.setSize(keyInfo.getDataSize());
                if (withReplica) {
                    long keyDU = keyInfo.getReplicatedSize();
                    keyDataSizeWithReplica += keyDU;
                    diskUsage.setSizeWithReplica(keyDU);
                }
                if (!listFile) continue;
                duData.add(diskUsage);
            }
        }
        return keyDataSizeWithReplica;
    }

    @Override
    public long calculateDUUnderObject(long parentId) throws IOException {
        long totalDU = 0L;
        Table<String, OmKeyInfo> keyTable = this.getKeyTable();
        try (TableIterator iterator = keyTable.iterator();){
            String seekPrefix = "/" + this.vol + "/" + this.bucket + "/";
            iterator.seek((Object)seekPrefix);
            while (iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                String keyName = (String)kv.getKey();
                if (!keyName.startsWith(seekPrefix)) {
                    break;
                }
                OmKeyInfo keyInfo = (OmKeyInfo)kv.getValue();
                if (keyInfo == null) continue;
                totalDU += keyInfo.getDataSize();
            }
        }
        return totalDU;
    }

    @Override
    public long getDirObjectId(String[] names) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Object stores do not support directories.");
    }

    @Override
    public long getDirObjectId(String[] names, int cutoff) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Object stores do not support directories.");
    }

    @Override
    public OmKeyInfo getKeyInfo(String[] names) throws IOException {
        String ozoneKey = "/";
        ozoneKey = ozoneKey + String.join((CharSequence)"/", names);
        return (OmKeyInfo)this.getKeyTable().getSkipCache((Object)ozoneKey);
    }

    @Override
    public OmDirectoryInfo getDirInfo(String[] names) throws IOException {
        throw new UnsupportedOperationException("Object stores do not support directories.");
    }

    public Table<String, OmKeyInfo> getKeyTable() {
        return this.getOmMetadataManager().getKeyTable(this.getBucketLayout());
    }

    @Override
    public BucketLayout getBucketLayout() {
        return BucketLayout.OBJECT_STORE;
    }
}

