/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.events.configurator.AnnotatedTypeConfiguratorImpl;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.injection.producer.BeanInjectionTarget;
import org.jboss.weld.injection.producer.DecoratorInjectionTarget;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.injection.producer.NonProducibleInjectionTarget;
import org.jboss.weld.injection.spi.InjectionServices;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldInjectionTargetFactory;
import org.jboss.weld.module.EjbSupport;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.InjectionTargets;

public class InjectionTargetFactoryImpl<T>
implements WeldInjectionTargetFactory<T> {
    private final BeanManagerImpl manager;
    private final EnhancedAnnotatedType<T> originalAnnotatedType;
    private final InjectionTargetService injectionTargetService;
    private final InjectionServices injectionServices;
    private volatile EnhancedAnnotatedType<T> annotatedType;
    private volatile AnnotatedTypeConfiguratorImpl<T> configurator;

    protected InjectionTargetFactoryImpl(AnnotatedType<T> type, BeanManagerImpl manager) {
        this.manager = manager;
        this.originalAnnotatedType = manager.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(type, manager.getId());
        this.injectionTargetService = manager.getServices().get(InjectionTargetService.class);
        this.injectionServices = manager.getServices().get(InjectionServices.class);
    }

    @Override
    public WeldInjectionTarget<T> createInjectionTarget(Bean<T> bean) {
        return this.createInjectionTarget(bean, false);
    }

    @Override
    public WeldInjectionTarget<T> createInterceptorInjectionTarget() {
        return this.createInjectionTarget(null, true);
    }

    private WeldInjectionTarget<T> createInjectionTarget(Bean<T> bean, boolean interceptor) {
        try {
            this.initAnnotatedType();
            return this.validate(this.createInjectionTarget(this.annotatedType, bean, interceptor));
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    public BasicInjectionTarget<T> createInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, boolean interceptor) {
        BasicInjectionTarget<T> injectionTarget = this.chooseInjectionTarget(type, bean, interceptor);
        this.initialize(injectionTarget);
        this.postProcess(injectionTarget);
        return injectionTarget;
    }

    @Override
    public synchronized AnnotatedTypeConfigurator<T> configure() {
        if (this.annotatedType != null) {
            BeanManagerLogger.LOG.unableToConfigureInjectionTargetFactory(this.annotatedType);
            throw new IllegalStateException();
        }
        if (this.configurator == null) {
            this.configurator = new AnnotatedTypeConfiguratorImpl<T>(this.originalAnnotatedType);
        }
        return this.configurator;
    }

    private synchronized void initAnnotatedType() {
        if (this.annotatedType != null) {
            return;
        }
        if (this.configurator != null) {
            Object configuredType = this.configurator.complete();
            this.annotatedType = this.manager.getServices().get(ClassTransformer.class).getEnhancedAnnotatedType(configuredType, this.manager.getId());
        } else {
            this.annotatedType = this.originalAnnotatedType;
        }
    }

    private BasicInjectionTarget<T> chooseInjectionTarget(EnhancedAnnotatedType<T> type, Bean<T> bean, boolean interceptor) {
        if (bean instanceof Decorator || type.isAnnotationPresent(javax.decorator.Decorator.class)) {
            return new DecoratorInjectionTarget<T>(type, bean, this.manager);
        }
        NonProducibleInjectionTarget<T> nonProducible = InjectionTargets.createNonProducibleInjectionTarget(type, bean, this.manager);
        if (nonProducible != null) {
            return nonProducible;
        }
        if (bean instanceof SessionBean) {
            return this.manager.getServices().get(EjbSupport.class).createSessionBeanInjectionTarget(type, (SessionBean)bean, this.manager);
        }
        if (bean instanceof Interceptor || type.isAnnotationPresent(javax.interceptor.Interceptor.class)) {
            return BeanInjectionTarget.forCdiInterceptor(type, bean, this.manager);
        }
        if (interceptor) {
            return BasicInjectionTarget.createNonCdiInterceptor(type, this.manager);
        }
        return BeanInjectionTarget.createDefault(type, bean, this.manager);
    }

    protected InjectionTarget<T> createMessageDrivenInjectionTarget(EjbDescriptor<T> descriptor) {
        return this.prepareInjectionTarget(this.manager.getServices().get(EjbSupport.class).createMessageDrivenInjectionTarget(this.originalAnnotatedType, descriptor, this.manager));
    }

    private BasicInjectionTarget<T> initialize(BasicInjectionTarget<T> injectionTarget) {
        this.injectionTargetService.addInjectionTargetToBeInitialized(this.originalAnnotatedType, injectionTarget);
        return injectionTarget;
    }

    private <I extends InjectionTarget<T>> I validate(I injectionTarget) {
        this.injectionTargetService.validateProducer(injectionTarget);
        return injectionTarget;
    }

    private void postProcess(InjectionTarget<T> injectionTarget) {
        if (this.injectionServices != null) {
            this.injectionServices.registerInjectionTarget(injectionTarget, this.originalAnnotatedType.slim());
        }
    }

    private BasicInjectionTarget<T> prepareInjectionTarget(BasicInjectionTarget<T> injectionTarget) {
        try {
            this.postProcess(this.initialize(this.validate(injectionTarget)));
            return injectionTarget;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public WeldInjectionTarget<T> createNonProducibleInjectionTarget() {
        return this.prepareInjectionTarget(NonProducibleInjectionTarget.create(this.originalAnnotatedType, null, this.manager));
    }
}

