/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.jsf;

import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.faces.application.ApplicationWrapper;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.jboss.weld.environment.servlet.WeldServletLifecycle;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.environment.servlet.portlet.PortletSupport;
import org.jboss.weld.environment.servlet.util.ForwardingELResolver;
import org.jboss.weld.environment.servlet.util.TransparentELResolver;
import org.jboss.weld.module.web.el.WeldELContextListener;

public class WeldApplication
extends ApplicationWrapper {
    private final Application application;
    private LazyBeanManagerIntegrationELResolver elResolver;
    private ExpressionFactory expressionFactory;
    private BeanManager beanManager;

    public WeldApplication(Application application) {
        this.application = application;
        super.addELContextListener((ELContextListener)new WeldELContextListener());
        this.elResolver = new LazyBeanManagerIntegrationELResolver();
        super.addELResolver((ELResolver)this.elResolver);
    }

    private void init() {
        ExpressionFactory expressionFactory = this.expressionFactory;
        BeanManager beanManager = null;
        if (expressionFactory == null && (expressionFactory = super.getExpressionFactory()) != null && (beanManager = this.beanManager()) != null) {
            this.elResolver.beanManagerReady(beanManager);
            this.expressionFactory = beanManager.wrapExpressionFactory(expressionFactory);
        }
    }

    public ExpressionFactory getExpressionFactory() {
        this.init();
        if (this.expressionFactory == null) {
            return super.getExpressionFactory();
        }
        return this.expressionFactory;
    }

    private BeanManager beanManager() {
        FacesContext facesContext;
        if (this.beanManager == null && (facesContext = FacesContext.getCurrentInstance()) != null) {
            Object obj = facesContext.getExternalContext().getContext();
            boolean notFound = false;
            try {
                if (obj instanceof ServletContext) {
                    ServletContext ctx = (ServletContext)obj;
                    BeanManager tmp = (BeanManager)ctx.getAttribute(WeldServletLifecycle.BEAN_MANAGER_ATTRIBUTE_NAME);
                    if (tmp == null) {
                        return null;
                    }
                    this.beanManager = tmp;
                } else if (PortletSupport.isPortletEnvSupported() && PortletSupport.isPortletContext(obj)) {
                    BeanManager tmp = PortletSupport.getBeanManager(obj);
                    if (tmp == null) {
                        return null;
                    }
                    this.beanManager = tmp;
                } else {
                    notFound = true;
                }
            }
            catch (Throwable t) {
                throw WeldServletLogger.LOG.exceptionFetchingBeanManager(t);
            }
            if (notFound) {
                throw WeldServletLogger.LOG.notInAServletOrPortlet();
            }
        }
        return this.beanManager;
    }

    public Application getWrapped() {
        return this.application;
    }

    private static class LazyBeanManagerIntegrationELResolver
    extends ForwardingELResolver {
        private ELResolver delegate = new TransparentELResolver();

        public void beanManagerReady(BeanManager beanManager) {
            this.delegate = beanManager.getELResolver();
        }

        @Override
        protected ELResolver delegate() {
            return this.delegate;
        }
    }
}

