/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.lang.annotation.Annotation;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Priority;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveBuilder;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveHandler;
import org.jboss.weld.environment.deployment.discovery.BeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.DefaultBeanArchiveScanner;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.ServiceLoader;

public abstract class AbstractDiscoveryStrategy
implements DiscoveryStrategy {
    protected ResourceLoader resourceLoader;
    protected Bootstrap bootstrap;
    protected Set<Class<? extends Annotation>> initialBeanDefiningAnnotations;
    protected BeanArchiveScanner scanner;
    private final List<BeanArchiveHandler> handlers = new LinkedList<BeanArchiveHandler>();

    protected AbstractDiscoveryStrategy() {
    }

    public AbstractDiscoveryStrategy(ResourceLoader resourceLoader, Bootstrap bootstrap, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        this.setResourceLoader(resourceLoader);
        this.setBootstrap(bootstrap);
        this.setInitialBeanDefiningAnnotations(initialBeanDefiningAnnotations);
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    @Override
    public void setScanner(BeanArchiveScanner scanner) {
        this.scanner = scanner;
    }

    @Override
    public void setInitialBeanDefiningAnnotations(Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        this.initialBeanDefiningAnnotations = initialBeanDefiningAnnotations;
    }

    @Override
    public Set<WeldBeanDeploymentArchive> performDiscovery() {
        if (this.scanner == null) {
            this.scanner = new DefaultBeanArchiveScanner(this.resourceLoader, this.bootstrap);
        }
        ArrayList<BeanArchiveBuilder> beanArchiveBuilders = new ArrayList<BeanArchiveBuilder>();
        HashSet<String> processedRefs = new HashSet<String>();
        List<BeanArchiveHandler> beanArchiveHandlers = this.initBeanArchiveHandlers();
        for (BeanArchiveScanner.ScanResult scanResult : this.scanner.scan()) {
            String ref = scanResult.getBeanArchiveRef();
            if (processedRefs.contains(ref)) {
                throw CommonLogger.LOG.invalidScanningResult(ref);
            }
            CommonLogger.LOG.processingBeanArchiveReference(ref);
            processedRefs.add(ref);
            BeanArchiveBuilder builder = null;
            for (BeanArchiveHandler handler : beanArchiveHandlers) {
                builder = handler.handle(ref);
                if (builder == null) continue;
                CommonLogger.LOG.beanArchiveReferenceHandled(ref, handler);
                builder.setId(scanResult.getBeanArchiveId());
                builder.setBeansXml(scanResult.getBeansXml());
                beanArchiveBuilders.add(builder);
                break;
            }
            if (builder != null) continue;
            CommonLogger.LOG.beanArchiveReferenceCannotBeHandled(ref, beanArchiveHandlers);
        }
        this.beforeDiscovery(beanArchiveBuilders);
        HashSet<WeldBeanDeploymentArchive> archives = new HashSet<WeldBeanDeploymentArchive>();
        block7: for (BeanArchiveBuilder builder : beanArchiveBuilders) {
            BeansXml beansXml = builder.getBeansXml();
            if (beansXml != null) {
                switch (beansXml.getBeanDiscoveryMode()) {
                    case ALL: {
                        this.addToArchives(archives, this.processAllDiscovery(builder));
                        continue block7;
                    }
                    case ANNOTATED: {
                        this.addToArchives(archives, this.processAnnotatedDiscovery(builder));
                        continue block7;
                    }
                    case NONE: {
                        this.addToArchives(archives, this.processNoneDiscovery(builder));
                        continue block7;
                    }
                }
                throw CommonLogger.LOG.undefinedBeanDiscoveryValue((Object)beansXml.getBeanDiscoveryMode());
            }
            this.addToArchives(archives, this.processAnnotatedDiscovery(builder));
        }
        for (WeldBeanDeploymentArchive archive : archives) {
            archive.getServices().add(ResourceLoader.class, this.resourceLoader);
        }
        this.afterDiscovery(archives);
        return archives;
    }

    @Override
    public ClassFileServices getClassFileServices() {
        return null;
    }

    protected void addToArchives(Set<WeldBeanDeploymentArchive> deploymentArchives, WeldBeanDeploymentArchive bda) {
        if (bda == null) {
            return;
        }
        if (bda.isEmpty()) {
            CommonLogger.LOG.debugv("Empty bean deployment archive ignored: {0}", (Object)bda.getId());
            return;
        }
        deploymentArchives.add(bda);
    }

    protected void beforeDiscovery(Collection<BeanArchiveBuilder> builders) {
    }

    protected void afterDiscovery(Set<WeldBeanDeploymentArchive> archives) {
    }

    protected WeldBeanDeploymentArchive processNoneDiscovery(BeanArchiveBuilder builder) {
        return null;
    }

    protected WeldBeanDeploymentArchive processAnnotatedDiscovery(BeanArchiveBuilder builder) {
        throw new UnsupportedOperationException();
    }

    protected WeldBeanDeploymentArchive processAllDiscovery(BeanArchiveBuilder builder) {
        return builder.build();
    }

    @Override
    public void registerHandler(BeanArchiveHandler handler) {
        this.handlers.add(handler);
    }

    List<BeanArchiveHandler> initBeanArchiveHandlers() {
        ArrayList<AbstractMap.SimpleEntry<Integer, BeanArchiveHandler>> entries = new ArrayList<AbstractMap.SimpleEntry<Integer, BeanArchiveHandler>>();
        Iterator<Object> iterator = this.handlers.listIterator();
        while (iterator.hasNext()) {
            entries.add(new AbstractMap.SimpleEntry<Integer, BeanArchiveHandler>(this.handlers.size() - iterator.nextIndex(), (BeanArchiveHandler)iterator.next()));
        }
        for (Metadata metadata : ServiceLoader.load(BeanArchiveHandler.class, this.resourceLoader)) {
            BeanArchiveHandler beanArchiveHandler = (BeanArchiveHandler)metadata.getValue();
            CommonLogger.LOG.debugv("Additional BeanArchiveHandler loaded: {0}", (Object)beanArchiveHandler.getClass());
            entries.add(new AbstractMap.SimpleEntry<Integer, BeanArchiveHandler>(AbstractDiscoveryStrategy.getPriority(beanArchiveHandler), beanArchiveHandler));
        }
        Collections.sort(entries, new Comparator<AbstractMap.SimpleEntry<Integer, BeanArchiveHandler>>(){

            @Override
            public int compare(AbstractMap.SimpleEntry<Integer, BeanArchiveHandler> o1, AbstractMap.SimpleEntry<Integer, BeanArchiveHandler> o2) {
                return Integer.compare(o2.getKey(), o1.getKey());
            }
        });
        ArrayList<BeanArchiveHandler> beanArchiveHandlers = new ArrayList<BeanArchiveHandler>(entries.size());
        for (AbstractMap.SimpleEntry simpleEntry : entries) {
            beanArchiveHandlers.add((BeanArchiveHandler)simpleEntry.getValue());
        }
        return beanArchiveHandlers;
    }

    private static int getPriority(BeanArchiveHandler handler) {
        Priority priority = handler.getClass().getAnnotation(Priority.class);
        if (priority != null) {
            return priority.value();
        }
        return 0;
    }
}

