/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jooq.Catalog;
import org.jooq.Clause;
import org.jooq.Comment;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.UDT;
import org.jooq.impl.AbstractNamed;
import org.jooq.impl.DSL;
import org.jooq.impl.Tools;

public class SchemaImpl
extends AbstractNamed
implements Schema {
    private static final long serialVersionUID = -8101463810207566546L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.SCHEMA, Clause.SCHEMA_REFERENCE};
    private Catalog catalog;

    public SchemaImpl(String name) {
        this(name, null);
    }

    public SchemaImpl(String name, Catalog catalog) {
        this(DSL.name(name), catalog);
    }

    public SchemaImpl(String name, Catalog catalog, String comment) {
        this(DSL.name(name), catalog, DSL.comment(comment));
    }

    public SchemaImpl(Name name) {
        this(name, (Catalog)null);
    }

    public SchemaImpl(Name name, Catalog catalog) {
        this(name, catalog, null);
    }

    public SchemaImpl(Name name, Catalog catalog, Comment comment) {
        super(SchemaImpl.qualify(catalog, name), comment);
        this.catalog = catalog;
    }

    @Override
    public Catalog getCatalog() {
        if (this.catalog == null) {
            this.catalog = this.getQualifiedName().qualified() ? DSL.catalog(this.getQualifiedName().qualifier()) : null;
        }
        return this.catalog;
    }

    @Override
    public final void accept(Context<?> ctx) {
        Catalog mappedCatalog;
        if (ctx.qualifyCatalog() && (mappedCatalog = Tools.getMappedCatalog(ctx.configuration(), this.getCatalog())) != null && !"".equals(mappedCatalog.getName())) {
            ctx.visit(mappedCatalog);
            ctx.sql('.');
        }
        ctx.visit(this.getUnqualifiedName());
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<?> getTable(String tableName) {
        for (Table<?> table : this.getTables()) {
            if (!table.getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    @Override
    public final UDT<?> getUDT(String udtName) {
        for (UDT<?> udt : this.getUDTs()) {
            if (!udt.getName().equals(udtName)) continue;
            return udt;
        }
        return null;
    }

    @Override
    public final Sequence<?> getSequence(String sequenceName) {
        for (Sequence<?> sequence : this.getSequences()) {
            if (!sequence.getName().equals(sequenceName)) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public List<Table<?>> getTables() {
        return Collections.emptyList();
    }

    @Override
    public List<UDT<?>> getUDTs() {
        return Collections.emptyList();
    }

    @Override
    public List<Sequence<?>> getSequences() {
        return Collections.emptyList();
    }

    @Override
    public final Stream<Table<?>> tableStream() {
        return this.getTables().stream();
    }

    @Override
    public final Stream<UDT<?>> udtStream() {
        return this.getUDTs().stream();
    }

    @Override
    public final Stream<Sequence<?>> sequenceStream() {
        return this.getSequences().stream();
    }
}

