/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.EnumSet;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.QueryPartInternal;
import org.jooq.Row2;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractCondition;
import org.jooq.impl.Keywords;

final class RowOverlapsCondition<T1, T2>
extends AbstractCondition {
    private static final long serialVersionUID = 85887551884667824L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.CONDITION, Clause.CONDITION_OVERLAPS};
    private static final EnumSet<SQLDialect> EMULATE_NON_STANDARD_OVERLAPS = EnumSet.of(SQLDialect.CUBRID, new SQLDialect[]{SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE});
    private static final EnumSet<SQLDialect> EMULATE_INTERVAL_OVERLAPS = EnumSet.of(SQLDialect.HSQLDB);
    private final Row2<T1, T2> left;
    private final Row2<T1, T2> right;

    RowOverlapsCondition(Row2<T1, T2> left, Row2<T1, T2> right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate(ctx.configuration()));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    private final QueryPartInternal delegate(Configuration configuration) {
        boolean intervalOverlaps;
        Field<T1> left1 = this.left.field1();
        Field<T2> left2 = this.left.field2();
        Field<T1> right1 = this.right.field1();
        Field<T2> right2 = this.right.field2();
        DataType<T1> type0 = left1.getDataType();
        DataType<T2> type1 = left2.getDataType();
        boolean standardOverlaps = type0.isDateTime() && type1.isTemporal();
        boolean bl = intervalOverlaps = type0.isDateTime() && (type1.isInterval() || type1.isNumeric());
        if (!standardOverlaps || EMULATE_NON_STANDARD_OVERLAPS.contains((Object)configuration.family())) {
            if (intervalOverlaps) {
                return (QueryPartInternal)((Object)right1.le(left1.add(left2)).and(left1.le(right1.add(right2))));
            }
            return (QueryPartInternal)((Object)right1.le(left2.cast(right1)).and(left1.le(right2.cast(left1))));
        }
        if (intervalOverlaps && EMULATE_INTERVAL_OVERLAPS.contains((Object)configuration.dialect())) {
            return (QueryPartInternal)((Object)right1.le(left1.add(left2)).and(left1.le(right1.add(right2))));
        }
        return new Native();
    }

    private class Native
    extends AbstractCondition {
        private static final long serialVersionUID = -1552476981094856727L;

        private Native() {
        }

        @Override
        public final void accept(Context<?> ctx) {
            ctx.sql('(').visit(RowOverlapsCondition.this.left).sql(' ').visit(Keywords.K_OVERLAPS).sql(' ').visit(RowOverlapsCondition.this.right).sql(')');
        }

        @Override
        public final Clause[] clauses(Context<?> ctx) {
            return CLAUSES;
        }
    }
}

