/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.Privilege;
import org.jooq.RevokeFinalStep;
import org.jooq.RevokeFromStep;
import org.jooq.RevokeOnStep;
import org.jooq.Role;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.User;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;

final class RevokeImpl
extends AbstractQuery
implements RevokeOnStep,
RevokeFromStep,
RevokeFinalStep {
    private static final long serialVersionUID = -5777612075774539326L;
    private static final Clause[] CLAUSE = new Clause[]{Clause.REVOKE};
    private final Collection<? extends Privilege> privileges;
    private Role role;
    private Table<?> table;
    private User user;
    private final boolean grantOptionFor;

    RevokeImpl(Configuration configuration, Collection<? extends Privilege> privileges, boolean grantOptionFor) {
        super(configuration);
        this.privileges = privileges;
        this.grantOptionFor = grantOptionFor;
    }

    RevokeImpl(Configuration configuration, Collection<? extends Privilege> privileges) {
        this(configuration, privileges, false);
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.start(Clause.REVOKE_PRIVILEGE).visit(Keywords.K_REVOKE).sql(' ');
        if (this.grantOptionFor) {
            ctx.visit(Keywords.K_GRANT_OPTION_FOR).sql(' ');
        }
        String separator = "";
        for (Privilege privilege : this.privileges) {
            ctx.sql(separator).visit(privilege);
            separator = ", ";
        }
        ctx.end(Clause.REVOKE_PRIVILEGE).sql(' ').start(Clause.REVOKE_ON).visit(Keywords.K_ON).sql(' ').visit(this.table).end(Clause.REVOKE_ON).sql(' ').start(Clause.REVOKE_FROM).visit(Keywords.K_FROM).sql(' ');
        if (this.user != null) {
            ctx.visit(this.user);
        } else if (this.role != null) {
            ctx.visit(this.role);
        } else {
            ctx.visit(Keywords.K_PUBLIC);
        }
        if (ctx.family() == SQLDialect.HSQLDB) {
            ctx.sql(' ').visit(Keywords.K_RESTRICT);
        }
        ctx.end(Clause.REVOKE_FROM);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSE;
    }

    @Override
    public final RevokeImpl on(Table<?> t) {
        this.table = t;
        return this;
    }

    @Override
    public final RevokeImpl on(Name t) {
        return this.on((Table)DSL.table(t));
    }

    @Override
    public final RevokeImpl on(String t) {
        return this.on((Table)DSL.table(t));
    }

    @Override
    public final RevokeImpl from(User u) {
        this.user = u;
        return this;
    }

    @Override
    public final RevokeImpl from(Role r) {
        this.role = r;
        return this;
    }

    @Override
    public final RevokeImpl fromPublic() {
        return this;
    }
}

