/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.JoinType;
import org.jooq.Keyword;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQL;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.TableOptionalOnStep;
import org.jooq.TableOuterJoinStep;
import org.jooq.TablePartitionByStep;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.Alias;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.Fields;
import org.jooq.impl.Keywords;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.RecordImpl;
import org.jooq.impl.TableAlias;
import org.jooq.impl.Tools;

final class JoinTable
extends AbstractTable<Record>
implements TableOuterJoinStep<Record>,
TableOptionalOnStep<Record>,
TablePartitionByStep<Record>,
TableOnConditionStep<Record> {
    private static final long serialVersionUID = 8377996833996498178L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.TABLE, Clause.TABLE_JOIN};
    private static final EnumSet<SQLDialect> EMULATE_NATURAL_JOIN = EnumSet.of(SQLDialect.CUBRID);
    private static final EnumSet<SQLDialect> EMULATE_NATURAL_OUTER_JOIN = EnumSet.of(SQLDialect.CUBRID, SQLDialect.H2);
    private static final EnumSet<SQLDialect> EMULATE_JOIN_USING = EnumSet.of(SQLDialect.CUBRID, SQLDialect.H2);
    private static final EnumSet<SQLDialect> EMULATE_APPLY = EnumSet.of(SQLDialect.POSTGRES);
    final Table<?> lhs;
    final Table<?> rhs;
    private final JoinType type;
    private final ConditionProviderImpl condition;
    private final QueryPartList<Field<?>> using;

    JoinTable(TableLike<?> lhs, TableLike<?> rhs, JoinType type) {
        super("join");
        this.lhs = lhs.asTable();
        this.rhs = rhs.asTable();
        this.type = type;
        this.condition = new ConditionProviderImpl();
        this.using = new QueryPartList();
    }

    @Override
    public final List<ForeignKey<Record, ?>> getReferences() {
        List<ForeignKey<?, ?>> lhsReferences = this.lhs.getReferences();
        List<ForeignKey<?, ?>> rhsReferences = this.rhs.getReferences();
        ArrayList result = new ArrayList(lhsReferences.size() + rhsReferences.size());
        result.addAll(lhsReferences);
        result.addAll(rhsReferences);
        return result;
    }

    @Override
    public final void accept(Context<?> ctx) {
        JoinType translatedType = this.translateType(ctx);
        Clause translatedClause = this.translateClause(translatedType);
        Keyword keyword = translatedType.toKeyword();
        if (translatedType == JoinType.CROSS_APPLY && EMULATE_APPLY.contains((Object)ctx.family())) {
            keyword = Keywords.K_CROSS_JOIN_LATERAL;
        } else if (translatedType == JoinType.OUTER_APPLY && EMULATE_APPLY.contains((Object)ctx.family())) {
            keyword = Keywords.K_LEFT_OUTER_JOIN_LATERAL;
        }
        this.toSQLTable(ctx, this.lhs);
        switch (translatedType) {
            case LEFT_SEMI_JOIN: 
            case LEFT_ANTI_JOIN: {
                if (ctx.data((Object)Tools.DataKey.DATA_COLLECT_SEMI_ANTI_JOIN) == null) break;
                ArrayList<Condition> semiAntiJoinPredicates = (ArrayList<Condition>)ctx.data((Object)Tools.DataKey.DATA_COLLECTED_SEMI_ANTI_JOIN);
                if (semiAntiJoinPredicates == null) {
                    semiAntiJoinPredicates = new ArrayList<Condition>();
                    ctx.data((Object)Tools.DataKey.DATA_COLLECTED_SEMI_ANTI_JOIN, semiAntiJoinPredicates);
                }
                switch (translatedType) {
                    case LEFT_SEMI_JOIN: {
                        semiAntiJoinPredicates.add(DSL.exists(DSL.selectOne().from((TableLike<?>)this.rhs).where((Condition)this.condition)));
                        break;
                    }
                    case LEFT_ANTI_JOIN: {
                        semiAntiJoinPredicates.add(DSL.notExists(DSL.selectOne().from((TableLike<?>)this.rhs).where((Condition)this.condition)));
                    }
                }
                return;
            }
        }
        ctx.formatIndentStart().formatSeparator().start(translatedClause).visit(keyword).sql(' ');
        this.toSQLTable(ctx, this.rhs);
        if (!Arrays.asList(JoinType.CROSS_JOIN, JoinType.NATURAL_JOIN, JoinType.NATURAL_LEFT_OUTER_JOIN, JoinType.NATURAL_RIGHT_OUTER_JOIN, JoinType.CROSS_APPLY, JoinType.OUTER_APPLY).contains((Object)translatedType)) {
            this.toSQLJoinCondition(ctx);
        } else if (JoinType.OUTER_APPLY == translatedType && EMULATE_APPLY.contains((Object)ctx.family())) {
            ctx.formatSeparator().start(Clause.TABLE_JOIN_ON).visit(Keywords.K_ON).sql(" 1 = 1").end(Clause.TABLE_JOIN_ON);
        }
        ctx.end(translatedClause).formatIndentEnd();
    }

    private void toSQLTable(Context<?> ctx, Table<?> table) {
        boolean wrap;
        boolean bl = wrap = table instanceof JoinTable && table == this.rhs;
        if (wrap) {
            ctx.sql('(').formatIndentStart().formatNewLine();
        }
        ctx.visit(table);
        if (wrap) {
            ctx.formatIndentEnd().formatNewLine().sql(')');
        }
    }

    final Clause translateClause(JoinType translatedType) {
        switch (translatedType) {
            case JOIN: {
                return Clause.TABLE_JOIN_INNER;
            }
            case CROSS_JOIN: {
                return Clause.TABLE_JOIN_CROSS;
            }
            case NATURAL_JOIN: {
                return Clause.TABLE_JOIN_NATURAL;
            }
            case LEFT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_LEFT;
            }
            case RIGHT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_RIGHT;
            }
            case FULL_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_FULL;
            }
            case NATURAL_LEFT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_LEFT;
            }
            case NATURAL_RIGHT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_RIGHT;
            }
            case CROSS_APPLY: {
                return Clause.TABLE_JOIN_CROSS_APPLY;
            }
            case OUTER_APPLY: {
                return Clause.TABLE_JOIN_OUTER_APPLY;
            }
            case LEFT_SEMI_JOIN: {
                return Clause.TABLE_JOIN_SEMI_LEFT;
            }
            case LEFT_ANTI_JOIN: {
                return Clause.TABLE_JOIN_ANTI_LEFT;
            }
            case STRAIGHT_JOIN: {
                return Clause.TABLE_JOIN_STRAIGHT;
            }
        }
        throw new IllegalArgumentException("Bad join type: " + (Object)((Object)translatedType));
    }

    final JoinType translateType(Context<?> context) {
        if (this.emulateCrossJoin(context)) {
            return JoinType.JOIN;
        }
        if (this.emulateNaturalJoin(context)) {
            return JoinType.JOIN;
        }
        if (this.emulateNaturalLeftOuterJoin(context)) {
            return JoinType.LEFT_OUTER_JOIN;
        }
        if (this.emulateNaturalRightOuterJoin(context)) {
            return JoinType.RIGHT_OUTER_JOIN;
        }
        return this.type;
    }

    private final boolean emulateCrossJoin(Context<?> context) {
        return false;
    }

    private final boolean emulateNaturalJoin(Context<?> context) {
        return this.type == JoinType.NATURAL_JOIN && EMULATE_NATURAL_JOIN.contains((Object)context.family());
    }

    private final boolean emulateNaturalLeftOuterJoin(Context<?> context) {
        return this.type == JoinType.NATURAL_LEFT_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)context.family());
    }

    private final boolean emulateNaturalRightOuterJoin(Context<?> context) {
        return this.type == JoinType.NATURAL_RIGHT_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)context.family());
    }

    private final void toSQLJoinCondition(Context<?> context) {
        if (!this.using.isEmpty()) {
            if (EMULATE_JOIN_USING.contains((Object)context.family())) {
                boolean first = true;
                for (Field<?> field : this.using) {
                    context.formatSeparator();
                    if (first) {
                        first = false;
                        context.start(Clause.TABLE_JOIN_ON).visit(Keywords.K_ON);
                    } else {
                        context.visit(Keywords.K_AND);
                    }
                    context.sql(' ').visit(Tools.qualify(this.lhs, field)).sql(" = ").visit(Tools.qualify(this.rhs, field));
                }
                context.end(Clause.TABLE_JOIN_ON);
            } else {
                context.formatSeparator().start(Clause.TABLE_JOIN_USING).visit(Keywords.K_USING).sql(" (");
                Tools.fieldNames(context, this.using);
                context.sql(')').end(Clause.TABLE_JOIN_USING);
            }
        } else if (this.emulateNaturalJoin(context) || this.emulateNaturalLeftOuterJoin(context) || this.emulateNaturalRightOuterJoin(context)) {
            boolean first = true;
            for (Field<?> field : this.lhs.fields()) {
                Field<?> other = this.rhs.field(field);
                if (other == null) continue;
                context.formatSeparator();
                if (first) {
                    first = false;
                    context.start(Clause.TABLE_JOIN_ON).visit(Keywords.K_ON);
                } else {
                    context.visit(Keywords.K_AND);
                }
                context.sql(' ').visit(field).sql(" = ").visit(other);
            }
            context.end(Clause.TABLE_JOIN_ON);
        } else {
            context.formatSeparator().start(Clause.TABLE_JOIN_ON).visit(Keywords.K_ON).sql(' ').visit(this.condition).end(Clause.TABLE_JOIN_ON);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<Record> as(Name alias) {
        return new TableAlias<Record>(this, alias, true);
    }

    @Override
    public final Table<Record> as(Name alias, Name ... fieldAliases) {
        return new TableAlias<Record>(this, alias, fieldAliases, true);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImpl.class;
    }

    @Override
    final Fields<Record> fields0() {
        if (this.type == JoinType.LEFT_SEMI_JOIN || this.type == JoinType.LEFT_ANTI_JOIN) {
            return new Fields<Record>(this.lhs.asTable().fields());
        }
        Field<?>[] l = this.lhs.asTable().fields();
        Field<?>[] r = this.rhs.asTable().fields();
        Field[] all = new Field[l.length + r.length];
        System.arraycopy(l, 0, all, 0, l.length);
        System.arraycopy(r, 0, all, l.length, r.length);
        return new Fields<Record>(all);
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    public final JoinTable on(Condition conditions) {
        this.condition.addConditions(conditions);
        return this;
    }

    public final JoinTable on(Condition ... conditions) {
        this.condition.addConditions(conditions);
        return this;
    }

    public final JoinTable on(Field<Boolean> c) {
        return this.on(DSL.condition(c));
    }

    public final JoinTable on(Boolean c) {
        return this.on(DSL.condition(c));
    }

    public final JoinTable on(SQL sql) {
        this.and(sql);
        return this;
    }

    public final JoinTable on(String sql) {
        this.and(sql);
        return this;
    }

    public final JoinTable on(String sql, Object ... bindings) {
        this.and(sql, bindings);
        return this;
    }

    public final JoinTable on(String sql, QueryPart ... parts) {
        this.and(sql, parts);
        return this;
    }

    public final JoinTable onKey() throws DataAccessException {
        List<ForeignKey<?, ?>> leftToRight = this.lhs.getReferencesTo(this.rhs);
        List<ForeignKey<?, ?>> rightToLeft = this.rhs.getReferencesTo(this.lhs);
        if (leftToRight.size() == 1 && rightToLeft.size() == 0) {
            return this.onKey(leftToRight.get(0), this.lhs, this.rhs);
        }
        if (rightToLeft.size() == 1 && leftToRight.size() == 0) {
            return this.onKey(rightToLeft.get(0), this.rhs, this.lhs);
        }
        if (rightToLeft.isEmpty() && leftToRight.isEmpty()) {
            throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, leftToRight, rightToLeft);
        }
        throw this.onKeyException(OnKeyExceptionReason.AMBIGUOUS, null, null);
    }

    public final JoinTable onKey(TableField<?, ?> ... keyFields) throws DataAccessException {
        block2: {
            block3: {
                if (keyFields == null || keyFields.length <= 0) break block2;
                if (this.search(this.lhs, keyFields[0].getTable()) == null) break block3;
                for (ForeignKey<?, ?> key : this.lhs.getReferences()) {
                    if (!key.getFields().containsAll(Arrays.asList(keyFields))) continue;
                    return this.onKey((ForeignKey)key);
                }
                break block2;
            }
            if (this.search(this.rhs, keyFields[0].getTable()) == null) break block2;
            for (ForeignKey<?, ?> key : this.rhs.getReferences()) {
                if (!key.getFields().containsAll(Arrays.asList(keyFields))) continue;
                return this.onKey((ForeignKey)key);
            }
        }
        throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, null, null);
    }

    public final JoinTable onKey(ForeignKey<?, ?> key) {
        if (this.search(this.lhs, key.getTable()) != null) {
            return this.onKey(key, this.lhs, this.rhs);
        }
        if (this.search(this.rhs, key.getTable()) != null) {
            return this.onKey(key, this.rhs, this.lhs);
        }
        throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, null, null);
    }

    private final Table<?> search(Table<?> tree, Table<?> search) {
        Alias<Table<?>> alias = Tools.alias(tree);
        if (alias != null) {
            return this.search(alias.wrapped(), search);
        }
        if (tree instanceof JoinTable) {
            JoinTable t = (JoinTable)tree;
            Table<?> r = this.search(t.lhs, search);
            if (r == null) {
                r = this.search(t.rhs, search);
            }
            return r;
        }
        return search.equals(tree) ? tree : null;
    }

    private final JoinTable onKey(ForeignKey<?, ?> key, Table<?> fk, Table<?> pk) {
        JoinTable result = this;
        TableField<R, ?>[] references = key.getFieldsArray();
        TableField<R, ?>[] referenced = key.getKey().getFieldsArray();
        for (int i = 0; i < references.length; ++i) {
            Field f1 = fk.field(references[i]);
            Field f2 = pk.field(referenced[i]);
            result.and(f1.equal(f2));
        }
        return result;
    }

    private final DataAccessException onKeyException(OnKeyExceptionReason reason, List<?> leftToRight, List<?> rightToLeft) {
        switch (reason) {
            case AMBIGUOUS: {
                return new DataAccessException("Key ambiguous between tables [" + this.lhs + "] and [" + this.rhs + "]. Found: " + leftToRight + " and " + rightToLeft);
            }
        }
        return new DataAccessException("No matching Key found between tables [" + this.lhs + "] and [" + this.rhs + "]");
    }

    public final JoinTable using(Field<?> ... fields) {
        return this.using(Arrays.asList(fields));
    }

    public final JoinTable using(Collection<? extends Field<?>> fields) {
        this.using.addAll((Collection<Field<?>>)fields);
        return this;
    }

    public final JoinTable and(Condition c) {
        this.condition.addConditions(c);
        return this;
    }

    public final JoinTable and(Field<Boolean> c) {
        return this.and(DSL.condition(c));
    }

    public final JoinTable and(Boolean c) {
        return this.and(DSL.condition(c));
    }

    public final JoinTable and(SQL sql) {
        return this.and(DSL.condition(sql));
    }

    public final JoinTable and(String sql) {
        return this.and(DSL.condition(sql));
    }

    public final JoinTable and(String sql, Object ... bindings) {
        return this.and(DSL.condition(sql, bindings));
    }

    public final JoinTable and(String sql, QueryPart ... parts) {
        return this.and(DSL.condition(sql, parts));
    }

    public final JoinTable andNot(Condition c) {
        return this.and(c.not());
    }

    public final JoinTable andNot(Field<Boolean> c) {
        return this.andNot(DSL.condition(c));
    }

    public final JoinTable andNot(Boolean c) {
        return this.andNot(DSL.condition(c));
    }

    public final JoinTable andExists(Select<?> select) {
        return this.and(DSL.exists(select));
    }

    public final JoinTable andNotExists(Select<?> select) {
        return this.and(DSL.notExists(select));
    }

    public final JoinTable or(Condition c) {
        this.condition.addConditions(Operator.OR, c);
        return this;
    }

    public final JoinTable or(Field<Boolean> c) {
        return this.or(DSL.condition(c));
    }

    public final JoinTable or(Boolean c) {
        return this.or(DSL.condition(c));
    }

    public final JoinTable or(SQL sql) {
        return this.or(DSL.condition(sql));
    }

    public final JoinTable or(String sql) {
        return this.or(DSL.condition(sql));
    }

    public final JoinTable or(String sql, Object ... bindings) {
        return this.or(DSL.condition(sql, bindings));
    }

    public final JoinTable or(String sql, QueryPart ... parts) {
        return this.or(DSL.condition(sql, parts));
    }

    public final JoinTable orNot(Condition c) {
        return this.or(c.not());
    }

    public final JoinTable orNot(Field<Boolean> c) {
        return this.orNot(DSL.condition(c));
    }

    public final JoinTable orNot(Boolean c) {
        return this.orNot(DSL.condition(c));
    }

    public final JoinTable orExists(Select<?> select) {
        return this.or(DSL.exists(select));
    }

    public final JoinTable orNotExists(Select<?> select) {
        return this.or(DSL.notExists(select));
    }

    private static enum OnKeyExceptionReason {
        AMBIGUOUS,
        NOT_FOUND;

    }
}

