/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.AbstractStoreQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.LazyVal;
import org.jooq.impl.Tools;

final class FieldMapsForInsert
extends AbstractQueryPart {
    private static final long serialVersionUID = -6227074228534414225L;
    final Table<?> table;
    final Map<Field<?>, Field<?>> empty;
    final Map<Field<?>, List<Field<?>>> values;
    int rows;
    int nextRow = -1;

    FieldMapsForInsert(Table<?> table) {
        this.table = table;
        this.values = new LinkedHashMap();
        this.empty = new LinkedHashMap();
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (!this.isExecutable()) {
            ctx.formatSeparator().start(Clause.INSERT_VALUES).visit(Keywords.K_DEFAULT_VALUES).end(Clause.INSERT_VALUES);
        } else if (this.rows == 1) {
            ctx.formatSeparator().start(Clause.INSERT_VALUES).visit(Keywords.K_VALUES).sql(' ');
            this.toSQL92Values(ctx);
            ctx.end(Clause.INSERT_VALUES);
        } else {
            switch (ctx.family()) {
                case FIREBIRD: {
                    ctx.formatSeparator().start(Clause.INSERT_SELECT).visit(this.insertSelect()).end(Clause.INSERT_SELECT);
                    break;
                }
                default: {
                    ctx.formatSeparator().start(Clause.INSERT_VALUES).visit(Keywords.K_VALUES).sql(' ');
                    this.toSQL92Values(ctx);
                    ctx.end(Clause.INSERT_VALUES);
                }
            }
        }
    }

    final Select<Record> insertSelect() {
        Select<Record> select = null;
        for (int row = 0; row < this.rows; ++row) {
            ArrayList fields = new ArrayList(this.values.size());
            for (List<Field<?>> list : this.values.values()) {
                fields.add(list.get(row));
            }
            SelectSelectStep<Record> iteration = DSL.select(fields);
            select = select == null ? iteration : select.unionAll(iteration);
        }
        return select;
    }

    final void toSQL92Values(Context<?> ctx) {
        this.toSQL92Values(ctx, false);
    }

    final void toSQL92Values(Context<?> ctx, boolean emulateBulkInsertReturning) {
        boolean indent = this.values.size() > 1;
        for (int row = 0; row < this.rows; ++row) {
            if (row > 0) {
                ctx.sql(", ");
            }
            ctx.start(Clause.FIELD_ROW).sql('(');
            if (indent) {
                ctx.formatIndentStart();
            }
            String separator = "";
            boolean i = false;
            for (List<Field<?>> list : this.values.values()) {
                ctx.sql(separator);
                if (indent) {
                    ctx.formatNewLine();
                }
                ctx.visit(list.get(row));
                separator = ", ";
            }
            if (indent) {
                ctx.formatIndentEnd().formatNewLine();
            }
            ctx.sql(')').end(Clause.FIELD_ROW);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    final void addFields(Collection<?> fields) {
        if (this.rows == 0) {
            this.newRecord();
        }
        this.initNextRow();
        for (Object field : fields) {
            Field<?> f = Tools.tableField(this.table, field);
            Field<?> e = this.empty.get(f);
            if (e == null) {
                e = new LazyVal<Object>(null, f);
                this.empty.put(f, e);
            }
            if (this.values.containsKey(f)) continue;
            this.values.put(f, this.rows > 0 ? new ArrayList(Collections.nCopies(this.rows, e)) : new ArrayList());
        }
    }

    final void set(Collection<? extends Field<?>> fields) {
        this.initNextRow();
        Iterator<Field<?>> it1 = fields.iterator();
        Iterator<List<Field<?>>> it2 = this.values.values().iterator();
        while (it1.hasNext() && it2.hasNext()) {
            it2.next().set(this.rows - 1, it1.next());
        }
        if (it1.hasNext() || it2.hasNext()) {
            throw new IllegalArgumentException("Added record size (" + fields.size() + ") must match fields size (" + this.values.size() + ")");
        }
    }

    final <T> Field<T> set(Field<T> field, Field<T> value) {
        this.addFields(Collections.singletonList(field));
        return this.values.get(field).set(this.rows - 1, value);
    }

    final void set(Map<?, ?> map) {
        this.addFields(map.keySet());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Field<?> field = Tools.tableField(this.table, entry.getKey());
            this.values.get(field).set(this.rows - 1, Tools.field(entry.getValue(), field));
        }
    }

    private final void initNextRow() {
        if (this.rows == this.nextRow) {
            Iterator<List<Field<?>>> v = this.values.values().iterator();
            Iterator<Field<?>> e = this.empty.values().iterator();
            while (v.hasNext() && e.hasNext()) {
                v.next().add(e.next());
            }
            ++this.rows;
        }
    }

    final void newRecord() {
        if (this.nextRow < this.rows) {
            ++this.nextRow;
        }
    }

    final Collection<Field<?>> fields() {
        return this.values.keySet();
    }

    final List<Map<Field<?>, Field<?>>> maps() {
        this.initNextRow();
        return new AbstractList<Map<Field<?>, Field<?>>>(){

            @Override
            public Map<Field<?>, Field<?>> get(int index) {
                return FieldMapsForInsert.this.map(index);
            }

            @Override
            public int size() {
                return FieldMapsForInsert.this.rows;
            }
        };
    }

    final Map<Field<?>, Field<?>> map(final int index) {
        this.initNextRow();
        return new AbstractMap<Field<?>, Field<?>>(){
            transient Set<Map.Entry<Field<?>, Field<?>>> entrySet;

            @Override
            public Set<Map.Entry<Field<?>, Field<?>>> entrySet() {
                if (this.entrySet == null) {
                    this.entrySet = new EntrySet();
                }
                return this.entrySet;
            }

            @Override
            public boolean containsKey(Object key) {
                return FieldMapsForInsert.this.values.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                for (List<Field<?>> list : FieldMapsForInsert.this.values.values()) {
                    if (!list.get(index).equals(value)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Field<?> get(Object key) {
                List<Field<?>> list = FieldMapsForInsert.this.values.get(key);
                return list == null ? null : list.get(index);
            }

            @Override
            public Field<?> put(Field<?> key, Field<?> value) {
                return FieldMapsForInsert.this.set(key, value);
            }

            @Override
            public Field<?> remove(Object key) {
                List<Field<?>> list = FieldMapsForInsert.this.values.get(key);
                FieldMapsForInsert.this.values.remove(key);
                return list == null ? null : list.get(index);
            }

            @Override
            public Set<Field<?>> keySet() {
                return FieldMapsForInsert.this.values.keySet();
            }

            final class EntrySet
            extends AbstractSet<Map.Entry<Field<?>, Field<?>>> {
                EntrySet() {
                }

                @Override
                public final int size() {
                    return FieldMapsForInsert.this.values.size();
                }

                @Override
                public final void clear() {
                    FieldMapsForInsert.this.values.clear();
                }

                @Override
                public final Iterator<Map.Entry<Field<?>, Field<?>>> iterator() {
                    return new Iterator<Map.Entry<Field<?>, Field<?>>>(){
                        Iterator<Map.Entry<Field<?>, List<Field<?>>>> delegate;
                        {
                            this.delegate = FieldMapsForInsert.this.values.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.delegate.hasNext();
                        }

                        @Override
                        public Map.Entry<Field<?>, Field<?>> next() {
                            Map.Entry<Field<?>, List<Field<?>>> entry = this.delegate.next();
                            return new AbstractMap.SimpleImmutableEntry(entry.getKey(), entry.getValue().get(index));
                        }

                        @Override
                        public void remove() {
                            this.delegate.remove();
                        }
                    };
                }
            }
        };
    }

    final Map<Field<?>, Field<?>> lastMap() {
        return this.map(this.rows - 1);
    }

    final boolean isExecutable() {
        return this.rows > 0;
    }

    final void toSQLReferenceKeys(Context<?> ctx) {
        block7: {
            if (!this.isExecutable()) {
                return;
            }
            if (this.values.size() == 0) {
                return;
            }
            for (Field<?> field : this.values.keySet()) {
                if (field instanceof AbstractStoreQuery.UnknownField) continue;
                break block7;
            }
            return;
        }
        boolean indent = this.values.size() > 1;
        ctx.sql(" (");
        if (indent) {
            ctx.formatIndentStart();
        }
        boolean qualify = ctx.qualify();
        ctx.qualify(false);
        String separator = "";
        for (Field<?> field : this.values.keySet()) {
            ctx.sql(separator);
            if (indent) {
                ctx.formatNewLine();
            }
            ctx.visit(field);
            separator = ", ";
        }
        ctx.qualify(qualify);
        if (indent) {
            ctx.formatIndentEnd().formatNewLine();
        }
        ctx.sql(')');
    }
}

