/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Catalog;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.Named;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.impl.DSL;

abstract class AbstractMeta
implements Meta,
Serializable {
    private static final long serialVersionUID = 910484713008245977L;
    private final Map<Name, Catalog> cachedCatalogs = new LinkedHashMap<Name, Catalog>();
    private final Map<Name, Schema> cachedQualifiedSchemas = new LinkedHashMap<Name, Schema>();
    private final Map<Name, Table<?>> cachedQualifiedTables = new LinkedHashMap();
    private final Map<Name, Sequence<?>> cachedQualifiedSequences = new LinkedHashMap();
    private final Map<Name, List<Schema>> cachedUnqualifiedSchemas = new LinkedHashMap<Name, List<Schema>>();
    private final Map<Name, List<Table<?>>> cachedUnqualifiedTables = new LinkedHashMap();
    private final Map<Name, List<Sequence<?>>> cachedUnqualifiedSequences = new LinkedHashMap();

    AbstractMeta() {
    }

    @Override
    public final Catalog getCatalog(String name) {
        return this.getCatalog(DSL.name(name));
    }

    @Override
    public final Catalog getCatalog(Name name) {
        if (this.cachedCatalogs.isEmpty()) {
            for (Catalog catalog : this.getCatalogs()) {
                this.cachedCatalogs.put(catalog.getQualifiedName(), catalog);
            }
        }
        return this.cachedCatalogs.get(name);
    }

    @Override
    public final List<Schema> getSchemas(String name) {
        return this.getSchemas(DSL.name(name));
    }

    @Override
    public final List<Schema> getSchemas(Name name) {
        return this.get(name, new Iterable<Schema>(){

            @Override
            public Iterator<Schema> iterator() {
                return AbstractMeta.this.getSchemas().iterator();
            }
        }, this.cachedQualifiedSchemas, this.cachedUnqualifiedSchemas);
    }

    @Override
    public final List<Table<?>> getTables(String name) {
        return this.getTables(DSL.name(name));
    }

    @Override
    public final List<Table<?>> getTables(Name name) {
        return this.get(name, new Iterable<Table<?>>(){

            @Override
            public Iterator<Table<?>> iterator() {
                return AbstractMeta.this.getTables().iterator();
            }
        }, this.cachedQualifiedTables, this.cachedUnqualifiedTables);
    }

    @Override
    public final List<Sequence<?>> getSequences(String name) {
        return this.getSequences(DSL.name(name));
    }

    @Override
    public final List<Sequence<?>> getSequences(Name name) {
        return this.get(name, new Iterable<Sequence<?>>(){

            @Override
            public Iterator<Sequence<?>> iterator() {
                return AbstractMeta.this.getSequences().iterator();
            }
        }, this.cachedQualifiedSequences, this.cachedUnqualifiedSequences);
    }

    private final <T extends Named> List<T> get(Name name, Iterable<T> i, Map<Name, T> qualified, Map<Name, List<T>> unqualified) {
        Named object;
        if (qualified.isEmpty()) {
            for (Named object2 : i) {
                Name q = object2.getQualifiedName();
                Name u = object2.getUnqualifiedName();
                qualified.put(q, object2);
                List<T> list = unqualified.get(u);
                if (list == null) {
                    list = new ArrayList<T>();
                    unqualified.put(u, list);
                }
                list.add(object2);
            }
        }
        if ((object = (Named)qualified.get(name)) != null) {
            return Collections.singletonList(object);
        }
        List<T> list = unqualified.get(name);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }
}

