/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.erasurecode.rawcoder;

import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.ozone.erasurecode.rawcoder.RSRawDecoder;
import org.apache.ozone.erasurecode.rawcoder.RSRawEncoder;
import org.apache.ozone.erasurecode.rawcoder.RawErasureCoderFactory;
import org.apache.ozone.erasurecode.rawcoder.RawErasureDecoder;
import org.apache.ozone.erasurecode.rawcoder.RawErasureEncoder;

@InterfaceAudience.Private
public class RSRawErasureCoderFactory
implements RawErasureCoderFactory {
    public static final String CODER_NAME = "rs_java";

    @Override
    public RawErasureEncoder createEncoder(ECReplicationConfig ecReplicationConfig) {
        return new RSRawEncoder(ecReplicationConfig);
    }

    @Override
    public RawErasureDecoder createDecoder(ECReplicationConfig ecReplicationConfig) {
        return new RSRawDecoder(ecReplicationConfig);
    }

    @Override
    public String getCoderName() {
        return CODER_NAME;
    }

    @Override
    public String getCodecName() {
        return ECReplicationConfig.EcCodec.RS.name().toLowerCase();
    }
}

