/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;

public interface Codec<T> {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public Class<T> getTypeClass();

    default public boolean supportCodecBuffer() {
        return false;
    }

    default public CodecBuffer toCodecBuffer(@Nonnull T object, CodecBuffer.Allocator allocator) throws IOException {
        throw new UnsupportedOperationException();
    }

    default public CodecBuffer toDirectCodecBuffer(@Nonnull T object) throws IOException {
        return this.toCodecBuffer(object, CodecBuffer.Allocator.getDirect());
    }

    default public CodecBuffer toHeapCodecBuffer(@Nonnull T object) throws IOException {
        return this.toCodecBuffer(object, CodecBuffer.Allocator.getHeap());
    }

    default public T fromCodecBuffer(@Nonnull CodecBuffer buffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] toPersistedFormat(T var1) throws IOException;

    public T fromPersistedFormat(byte[] var1) throws IOException;

    public T copyObject(T var1);
}

