/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.hadoop.util.ThreadUtil;
import org.slf4j.LoggerFactory;

public class RatisVersionInfo {
    private static final String RATIS_VERSION_PROPERTIES = "ratis-version.properties";
    private final Properties info = new Properties();

    public RatisVersionInfo() {
        try (InputStream is = ThreadUtil.getResourceAsStream((ClassLoader)this.getClass().getClassLoader(), (String)RATIS_VERSION_PROPERTIES);){
            this.info.load(is);
        }
        catch (IOException ex) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not read ratis-version.properties", (Throwable)ex);
        }
    }

    public String getVersion() {
        return this.info.getProperty("version", "Unknown");
    }

    public String getRevision() {
        return this.info.getProperty("revision", "Unknown");
    }

    public String getBuildVersion() {
        return this.getVersion() + " from " + this.getRevision();
    }
}

