/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.ratis.conf.RatisClientConfig;
import org.apache.hadoop.hdds.ratis.retrypolicy.RetryPolicyCreator;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.datastream.SupportedDataStreamType;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcTlsConfig;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.RoutingTable;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.security.TlsConf;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.JvmPauseMonitor;
import org.apache.ratis.util.Preconditions;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RatisHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RatisHelper.class);
    private static final OzoneConfiguration CONF = new OzoneConfiguration();
    public static final String HDDS_DATANODE_RATIS_PREFIX_KEY = "hdds.ratis";
    private static final RaftGroupId DUMMY_GROUP_ID = RaftGroupId.valueOf((ByteString)ByteString.copyFromUtf8((String)"AOzoneRatisGroup"));
    private static final RaftGroup EMPTY_GROUP = RaftGroup.valueOf((RaftGroupId)DUMMY_GROUP_ID, Collections.emptyList());
    @VisibleForTesting
    public static final int NEUTRAL_PRIORITY = 0;
    private static final int HIGHER_PRIORITY = 1;

    private RatisHelper() {
    }

    public static JvmPauseMonitor newJvmPauseMonitor(String name) {
        return JvmPauseMonitor.newBuilder().setName((Object)name).build();
    }

    private static String toRaftPeerIdString(DatanodeDetails id) {
        return id.getUuidString();
    }

    public static UUID toDatanodeId(String peerIdString) {
        return UUID.fromString(peerIdString);
    }

    public static UUID toDatanodeId(RaftPeerId peerId) {
        return RatisHelper.toDatanodeId(peerId.toString());
    }

    public static UUID toDatanodeId(RaftProtos.RaftPeerProto peerId) {
        return RatisHelper.toDatanodeId(RaftPeerId.valueOf((ByteString)peerId.getId()));
    }

    private static String toRaftPeerAddress(DatanodeDetails id, DatanodeDetails.Port.Name port) {
        if (RatisHelper.datanodeUseHostName()) {
            String address = id.getHostName() + ":" + id.getPort(port).getValue();
            LOG.debug("Datanode is using hostname for raft peer address: {}", (Object)address);
            return address;
        }
        String address = id.getIpAddress() + ":" + id.getPort(port).getValue();
        LOG.debug("Datanode is using IP for raft peer address: {}", (Object)address);
        return address;
    }

    public static RaftPeerId toRaftPeerId(DatanodeDetails id) {
        return RaftPeerId.valueOf((String)RatisHelper.toRaftPeerIdString(id));
    }

    public static RaftPeer toRaftPeer(DatanodeDetails id) {
        return RatisHelper.raftPeerBuilderFor(id).build();
    }

    public static RaftPeer toRaftPeer(DatanodeDetails id, int priority) {
        return RatisHelper.raftPeerBuilderFor(id).setPriority(priority).build();
    }

    private static RaftPeer.Builder raftPeerBuilderFor(DatanodeDetails dn) {
        return RaftPeer.newBuilder().setId(RatisHelper.toRaftPeerId(dn)).setAddress(RatisHelper.toRaftPeerAddress(dn, DatanodeDetails.Port.Name.RATIS_SERVER)).setAdminAddress(RatisHelper.toRaftPeerAddress(dn, DatanodeDetails.Port.Name.RATIS_ADMIN)).setClientAddress(RatisHelper.toRaftPeerAddress(dn, DatanodeDetails.Port.Name.RATIS)).setDataStreamAddress(RatisHelper.toRaftPeerAddress(dn, DatanodeDetails.Port.Name.RATIS_DATASTREAM));
    }

    private static List<RaftPeer> toRaftPeers(Pipeline pipeline) {
        return RatisHelper.toRaftPeers(pipeline.getNodes());
    }

    private static <E extends DatanodeDetails> List<RaftPeer> toRaftPeers(List<E> datanodes) {
        return datanodes.stream().map(RatisHelper::toRaftPeer).collect(Collectors.toList());
    }

    private static RaftGroup emptyRaftGroup() {
        return EMPTY_GROUP;
    }

    private static RaftGroup newRaftGroup(Collection<RaftPeer> peers) {
        return peers.isEmpty() ? RatisHelper.emptyRaftGroup() : RaftGroup.valueOf((RaftGroupId)DUMMY_GROUP_ID, peers);
    }

    public static RaftGroup newRaftGroup(RaftGroupId groupId, List<DatanodeDetails> peers, List<Integer> priorityList) {
        assert (peers.size() == priorityList.size());
        ArrayList<RaftPeer> newPeers = new ArrayList<RaftPeer>();
        for (int i = 0; i < peers.size(); ++i) {
            RaftPeer peer = RatisHelper.toRaftPeer(peers.get(i), priorityList.get(i));
            newPeers.add(peer);
        }
        return peers.isEmpty() ? RaftGroup.valueOf((RaftGroupId)groupId, Collections.emptyList()) : RaftGroup.valueOf((RaftGroupId)groupId, newPeers);
    }

    public static RaftGroup newRaftGroup(RaftGroupId groupId, Collection<DatanodeDetails> peers) {
        List newPeers = peers.stream().map(RatisHelper::toRaftPeer).collect(Collectors.toList());
        return peers.isEmpty() ? RaftGroup.valueOf((RaftGroupId)groupId, Collections.emptyList()) : RaftGroup.valueOf((RaftGroupId)groupId, newPeers);
    }

    public static RaftGroup newRaftGroup(Pipeline pipeline) {
        return RaftGroup.valueOf((RaftGroupId)RaftGroupId.valueOf((UUID)pipeline.getId().getId()), RatisHelper.toRaftPeers(pipeline));
    }

    public static RaftClient newRaftClient(RpcType rpcType, Pipeline pipeline, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, ConfigurationSource ozoneConfiguration) throws IOException {
        return RatisHelper.newRaftClient(rpcType, RatisHelper.toRaftPeerId(pipeline.getLeaderNode()), RatisHelper.toRaftPeer(pipeline.getClosestNode()), RatisHelper.newRaftGroup(RaftGroupId.valueOf((UUID)pipeline.getId().getId()), pipeline.getNodes()), retryPolicy, tlsConfig, ozoneConfiguration);
    }

    private static RpcType getRpcType(ConfigurationSource conf) {
        return SupportedRpcType.valueOfIgnoreCase((String)conf.get("hdds.container.ratis.rpc.type", "GRPC"));
    }

    public static BiFunction<RaftPeer, GrpcTlsConfig, RaftClient> newRaftClient(ConfigurationSource conf) {
        return (leader, tlsConfig) -> RatisHelper.newRaftClient(RatisHelper.getRpcType(conf), leader, RatisHelper.createRetryPolicy(conf), tlsConfig, conf);
    }

    public static BiFunction<RaftPeer, GrpcTlsConfig, RaftClient> newRaftClientNoRetry(ConfigurationSource conf) {
        return (leader, tlsConfig) -> RatisHelper.newRaftClient(RatisHelper.getRpcType(conf), leader, RetryPolicies.noRetry(), tlsConfig, conf);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeer leader, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, ConfigurationSource configuration) {
        return RatisHelper.newRaftClient(rpcType, leader.getId(), leader, RatisHelper.newRaftGroup(Collections.singletonList(leader)), retryPolicy, tlsConfig, configuration);
    }

    public static RaftClient newRaftClient(RpcType rpcType, RaftPeer leader, RetryPolicy retryPolicy, ConfigurationSource ozoneConfiguration) {
        return RatisHelper.newRaftClient(rpcType, leader.getId(), leader, RatisHelper.newRaftGroup(Collections.singletonList(leader)), retryPolicy, null, ozoneConfiguration);
    }

    private static RaftClient newRaftClient(RpcType rpcType, RaftPeerId leader, RaftPeer primary, RaftGroup group, RetryPolicy retryPolicy, GrpcTlsConfig tlsConfig, ConfigurationSource ozoneConfiguration) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("newRaftClient: {}, leader={}, group={}", new Object[]{rpcType, leader, group});
        }
        RaftProperties properties = RatisHelper.newRaftProperties(rpcType);
        RatisHelper.enableNettyStreaming(properties);
        RatisHelper.createRaftClientProperties(ozoneConfiguration, properties);
        return RaftClient.newBuilder().setRaftGroup(group).setLeaderId(leader).setPrimaryDataStreamServer(primary).setProperties(properties).setParameters(RatisHelper.setClientTlsConf(rpcType, tlsConfig)).setRetryPolicy(retryPolicy).build();
    }

    public static Parameters setClientTlsConf(RpcType rpcType, GrpcTlsConfig tlsConfig) {
        if (tlsConfig != null && rpcType == SupportedRpcType.GRPC) {
            Parameters parameters = new Parameters();
            RatisHelper.setAdminTlsConf(parameters, tlsConfig);
            RatisHelper.setClientTlsConf(parameters, tlsConfig);
            return parameters;
        }
        return null;
    }

    private static void setAdminTlsConf(Parameters parameters, GrpcTlsConfig tlsConfig) {
        if (tlsConfig != null) {
            GrpcConfigKeys.Admin.setTlsConf((Parameters)parameters, (GrpcTlsConfig)tlsConfig);
        }
    }

    private static void setClientTlsConf(Parameters parameters, GrpcTlsConfig tlsConfig) {
        if (tlsConfig != null) {
            GrpcConfigKeys.Client.setTlsConf((Parameters)parameters, (GrpcTlsConfig)tlsConfig);
            NettyConfigKeys.DataStream.Client.setTlsConf((Parameters)parameters, (TlsConf)tlsConfig);
        }
    }

    public static Parameters setServerTlsConf(GrpcTlsConfig serverConf, GrpcTlsConfig clientConf) {
        Parameters parameters = new Parameters();
        if (serverConf != null) {
            GrpcConfigKeys.Server.setTlsConf((Parameters)parameters, (GrpcTlsConfig)serverConf);
            GrpcConfigKeys.TLS.setConf((Parameters)parameters, (GrpcTlsConfig)serverConf);
            RatisHelper.setAdminTlsConf(parameters, serverConf);
            NettyConfigKeys.DataStream.Server.setTlsConf((Parameters)parameters, (TlsConf)serverConf);
        }
        RatisHelper.setClientTlsConf(parameters, clientConf);
        return parameters;
    }

    public static Parameters setServerTlsConf(GrpcTlsConfig tlsConf) {
        return RatisHelper.setServerTlsConf(tlsConf, tlsConf);
    }

    public static RaftProperties newRaftProperties(RpcType rpcType) {
        RaftProperties properties = new RaftProperties();
        RatisHelper.setRpcType(properties, rpcType);
        return properties;
    }

    public static RaftProperties setRpcType(RaftProperties properties, RpcType rpcType) {
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)rpcType);
        return properties;
    }

    public static RaftProperties enableNettyStreaming(RaftProperties properties) {
        RaftConfigKeys.DataStream.setType((RaftProperties)properties, (SupportedDataStreamType)SupportedDataStreamType.NETTY);
        return properties;
    }

    public static void createRaftClientProperties(ConfigurationSource ozoneConf, RaftProperties raftProperties) {
        Map<String, String> ratisClientConf = RatisHelper.getDatanodeRatisPrefixProps(ozoneConf);
        ratisClientConf.forEach((key, val) -> {
            if (RatisHelper.isClientConfig(key) || RatisHelper.isGrpcClientConfig(key) || RatisHelper.isNettyStreamConfig(key) || RatisHelper.isDataStreamConfig(key)) {
                raftProperties.set(key, val);
            }
        });
    }

    private static boolean isClientConfig(String key) {
        return key.startsWith("raft.client");
    }

    private static boolean isDataStreamConfig(String key) {
        return key.startsWith("raft.datastream");
    }

    private static boolean isGrpcClientConfig(String key) {
        return key.startsWith("raft.grpc") && !key.startsWith("raft.grpc.tls") && !key.startsWith("raft.grpc.admin") && !key.startsWith("raft.grpc.server");
    }

    private static boolean isNettyStreamConfig(String key) {
        return key.startsWith("raft.netty.dataStream");
    }

    private static boolean isStreamClientConfig(String key) {
        return key.startsWith("raft.client.data-stream");
    }

    public static void createRaftServerProperties(ConfigurationSource ozoneConf, RaftProperties raftProperties) {
        Map<String, String> ratisServerConf = RatisHelper.getDatanodeRatisPrefixProps(ozoneConf);
        ratisServerConf.forEach((key, val) -> {
            if (RatisHelper.isNettyStreamConfig(key) || RatisHelper.isStreamClientConfig(key) || !RatisHelper.isClientConfig(key)) {
                raftProperties.set(key, val);
            }
        });
    }

    private static Map<String, String> getDatanodeRatisPrefixProps(ConfigurationSource configuration) {
        return configuration.getPropsMatchPrefixAndTrimPrefix(StringUtils.appendIfNotPresent(HDDS_DATANODE_RATIS_PREFIX_KEY, '.'));
    }

    public static GrpcTlsConfig createTlsClientConfig(SecurityConfig conf, TrustManager trustManager) {
        GrpcTlsConfig tlsConfig = null;
        if (conf.isSecurityEnabled() && conf.isGrpcTlsEnabled()) {
            tlsConfig = new GrpcTlsConfig(null, trustManager, false);
        }
        return tlsConfig;
    }

    public static RetryPolicy createRetryPolicy(ConfigurationSource conf) {
        try {
            RatisClientConfig scmClientConfig = (RatisClientConfig)conf.getObject(RatisClientConfig.class);
            Class<RetryPolicyCreator> policyClass = RatisHelper.getClass(scmClientConfig.getRetryPolicy(), RetryPolicyCreator.class);
            return policyClass.newInstance().create(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Long getMinReplicatedIndex(Collection<RaftProtos.CommitInfoProto> commitInfos) {
        return commitInfos.stream().map(RaftProtos.CommitInfoProto::getCommitIndex).min(Long::compareTo).orElse(null);
    }

    private static boolean datanodeUseHostName() {
        return CONF.getBoolean("hdds.datanode.use.datanode.hostname", false);
    }

    private static <U> Class<? extends U> getClass(String name, Class<U> xface) {
        try {
            Class<?> theClass = Class.forName(name);
            if (!xface.isAssignableFrom(theClass)) {
                throw new RuntimeException(theClass + " not " + xface.getName());
            }
            return theClass.asSubclass(xface);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static RoutingTable getRoutingTable(Pipeline pipeline) {
        RaftPeerId primaryId = null;
        ArrayList<RaftPeerId> raftPeers = new ArrayList<RaftPeerId>();
        for (DatanodeDetails dn : pipeline.getNodesInOrder()) {
            RaftPeerId raftPeerId = RaftPeerId.valueOf((String)dn.getUuidString());
            try {
                if (dn == pipeline.getClosestNode()) {
                    primaryId = raftPeerId;
                }
            }
            catch (IOException e) {
                LOG.error("Can not get primary node from the pipeline: {} with exception: {}", (Object)pipeline, (Object)e.getLocalizedMessage());
                return null;
            }
            raftPeers.add(raftPeerId);
        }
        RoutingTable.Builder builder = RoutingTable.newBuilder();
        RaftPeerId previousId = primaryId;
        for (RaftPeerId peerId : raftPeers) {
            if (peerId.equals((Object)primaryId)) continue;
            builder.addSuccessor(previousId, peerId);
            previousId = peerId;
        }
        return builder.build();
    }

    public static void debug(ByteBuffer buffer, String name, Logger log) {
        if (!log.isDebugEnabled()) {
            return;
        }
        buffer = buffer.duplicate();
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (buffer.remaining() > 0) {
            builder.append(buffer.get()).append(i % 20 == 0 ? "\n  " : ", ");
            ++i;
        }
        log.debug("{}: {}\n  {}", new Object[]{name, buffer, builder});
    }

    public static void debug(ByteBuf buf, String name, Logger log) {
        if (!log.isDebugEnabled()) {
            return;
        }
        buf = buf.duplicate();
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (buf.readableBytes() > 0) {
            builder.append(buf.readByte()).append(i % 20 == 0 ? "\n  " : ", ");
            ++i;
        }
        log.debug("{}: {}\n  {}", new Object[]{name, buf, builder});
    }

    static RaftPeer newRaftPeer(RaftPeer peer, RaftPeerId target) {
        int priority = peer.getId().equals((Object)target) ? 1 : 0;
        return RaftPeer.newBuilder((RaftPeer)peer).setPriority(priority).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferRatisLeadership(ConfigurationSource conf, RaftGroup group, RaftPeerId targetPeerId, GrpcTlsConfig tlsConfig) throws IOException {
        block21: {
            if (group.getPeer(targetPeerId) == null) {
                throw new IOException("Target " + targetPeerId + " not found in group " + group.getPeers().stream().map(RaftPeer::getId).collect(Collectors.toList()) + ".");
            }
            LOG.info("Start transferring leadership to {}", (Object)targetPeerId);
            try (RaftClient client = RatisHelper.newRaftClient((RpcType)SupportedRpcType.GRPC, null, null, group, RatisHelper.createRetryPolicy(conf), tlsConfig, conf);){
                GroupInfoReply info = client.getGroupManagementApi(targetPeerId).info(group.getGroupId());
                if (!info.isSuccess()) {
                    throw new IOException("Failed to get info for " + group.getGroupId() + " from " + targetPeerId);
                }
                RaftGroup remote = info.getGroup();
                if (!group.equals((Object)remote)) {
                    throw new IOException("Group mismatched: the given group " + group + " and the remote group from " + targetPeerId + " are not equal.\n Given: " + group + "\n Remote: " + remote);
                }
                RaftClientReply setConf = null;
                try {
                    List peersWithNewPriorities = group.getPeers().stream().map(peer -> RatisHelper.newRaftPeer(peer, targetPeerId)).collect(Collectors.toList());
                    setConf = client.admin().setConfiguration(peersWithNewPriorities);
                    if (!setConf.isSuccess()) {
                        throw new IOException("Failed to set priority.", (Throwable)setConf.getException());
                    }
                    LOG.info("Successfully set priority: {}", peersWithNewPriorities);
                    RaftClientReply reply = client.admin().transferLeadership(targetPeerId, 60000L);
                    if (reply.isSuccess()) {
                        LOG.info("Successfully transferred leadership to {}.", (Object)targetPeerId);
                        break block21;
                    }
                    LOG.warn("Failed to transfer leadership to {}. Ratis reply: {}", (Object)targetPeerId, (Object)reply);
                    throw new IOException((Throwable)reply.getException());
                }
                finally {
                    if (setConf != null && setConf.isSuccess()) {
                        RatisHelper.resetPriorities(remote, client);
                    }
                }
            }
        }
    }

    private static void resetPriorities(RaftGroup original, RaftClient client) {
        List resetPeers = original.getPeers().stream().map(originalPeer -> RaftPeer.newBuilder((RaftPeer)originalPeer).setPriority(0).build()).collect(Collectors.toList());
        LOG.info("Resetting Raft peers priorities to {}", resetPeers);
        try {
            RaftClientReply reply = client.admin().setConfiguration(resetPeers);
            if (reply.isSuccess()) {
                LOG.info("Successfully reset priorities: {}", (Object)original);
            } else {
                LOG.warn("Failed to reset priorities: {}, reply: {}", (Object)original, (Object)reply);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to reset priorities for " + original, (Throwable)e);
        }
    }

    public static boolean attemptUntilTrue(BooleanSupplier condition, Duration pollInterval, Duration timeout) {
        try {
            int attempts = RatisHelper.calculateAttempts(pollInterval, timeout);
            TimeDuration sleepTime = TimeDuration.valueOf((long)pollInterval.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
            JavaUtils.attemptUntilTrue((BooleanSupplier)condition, (int)attempts, (TimeDuration)sleepTime, null, null);
            return true;
        }
        catch (IllegalStateException | InterruptedException exception) {
            return false;
        }
    }

    public static int calculateAttempts(Duration pollInterval, Duration maxDuration) {
        long interval;
        long max = maxDuration.toMillis();
        Preconditions.assertTrue((max >= (interval = pollInterval.toMillis()) ? 1 : 0) != 0, () -> "max: " + maxDuration + " < interval:" + pollInterval);
        return (int)(max / interval);
    }
}

