/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.hdds.conf.ConfigurationException;
import org.apache.hadoop.util.StringUtils;

public class DelegatingProperties
extends Properties {
    private final Properties properties;
    private final String complianceMode;
    private final boolean checkCompliance;
    private final Properties cryptoProperties;

    public DelegatingProperties(Properties properties, String complianceMode, Properties cryptoProperties) {
        this.properties = properties;
        this.complianceMode = complianceMode;
        this.checkCompliance = !complianceMode.equals("unrestricted");
        this.cryptoProperties = cryptoProperties;
    }

    public String checkCompliance(String config, String value) {
        Collection whitelistOptions;
        String whitelistConfig;
        String whitelistValue;
        if (this.checkCompliance && this.cryptoProperties.containsKey(config) && !config.equals("ozone.security.crypto.compliance.mode") && (whitelistValue = this.properties.getProperty(whitelistConfig = config + "." + this.complianceMode + ".whitelist", "")) != null && !(whitelistOptions = StringUtils.getTrimmedStringCollection((String)whitelistValue)).contains(value)) {
            throw new ConfigurationException("Not allowed configuration value! Compliance mode is set to " + this.complianceMode + " and " + config + " configuration's value is not allowed. Please check the " + whitelistConfig + " configuration.");
        }
        return value;
    }

    @Override
    public String getProperty(String key) {
        String value = this.properties.getProperty(key);
        return this.checkCompliance(key, value);
    }

    @Override
    public Object setProperty(String key, String value) {
        return this.properties.setProperty(key, value);
    }

    @Override
    public synchronized Object remove(Object key) {
        return this.properties.remove(key);
    }

    @Override
    public synchronized void clear() {
        this.properties.clear();
    }

    @Override
    public Enumeration<Object> keys() {
        return this.properties.keys();
    }

    @Override
    public Enumeration<?> propertyNames() {
        return this.properties.propertyNames();
    }

    @Override
    public Set<String> stringPropertyNames() {
        return this.properties.stringPropertyNames();
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<Object> keySet() {
        return this.properties.keySet();
    }

    @Override
    public boolean contains(Object value) {
        return this.properties.contains(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        return this.properties.remove(key, value);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return this.properties.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<?, ?> t) {
        this.properties.putAll(t);
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.properties.entrySet();
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.properties.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return this.properties.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties properties = this.properties;
        synchronized (properties) {
            for (Map.Entry<Object, Object> item : this.properties.entrySet()) {
                if (!(item.getKey() instanceof String) || !(item.getValue() instanceof String)) continue;
                String value = this.checkCompliance((String)item.getKey(), (String)item.getValue());
                result.put((String)item.getKey(), value);
            }
        }
        return result.entrySet().iterator();
    }
}

