/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.util.Arrays;
import org.apache.hadoop.hdds.utils.db.Table;

public abstract class RawKeyValue<RAW>
implements Table.KeyValue<RAW, RAW> {
    private final RAW key;
    private final RAW value;

    public static ByteArray create(byte[] key, byte[] value) {
        return new ByteArray(key, value);
    }

    private RawKeyValue(RAW key, RAW value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public RAW getKey() {
        return this.key;
    }

    @Override
    public RAW getValue() {
        return this.value;
    }

    public static final class ByteArray
    extends RawKeyValue<byte[]> {
        static byte[] copy(byte[] bytes) {
            return Arrays.copyOf(bytes, bytes.length);
        }

        private ByteArray(byte[] key, byte[] value) {
            super(key, value);
        }

        @Override
        public byte[] getKey() {
            return ByteArray.copy((byte[])super.getKey());
        }

        @Override
        public byte[] getValue() {
            return ByteArray.copy((byte[])super.getValue());
        }
    }
}

