/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.insight.datanode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.server.http.HttpConfig;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.container.common.impl.HddsDispatcher;
import org.apache.hadoop.ozone.insight.BaseInsightPoint;
import org.apache.hadoop.ozone.insight.Component;
import org.apache.hadoop.ozone.insight.InsightPoint;
import org.apache.hadoop.ozone.insight.LoggerSource;
import org.apache.hadoop.ozone.insight.MetricGroupDisplay;

public class DatanodeDispatcherInsight
extends BaseInsightPoint
implements InsightPoint {
    private static final String DATANODE_FILTER = "datanode";
    private OzoneConfiguration conf;

    public DatanodeDispatcherInsight(OzoneConfiguration conf) {
        this.conf = conf;
    }

    public Component getDatanodeFromFilter(Map<String, String> filters) {
        if (filters == null || !filters.containsKey(DATANODE_FILTER)) {
            throw new IllegalArgumentException("datanode filter should be specified (-f datanode=<host_or_ip)");
        }
        String policyStr = this.conf.get("ozone.http.policy", OzoneConfigKeys.OZONE_HTTP_POLICY_DEFAULT);
        HttpConfig.Policy policy = HttpConfig.Policy.fromString((String)policyStr);
        int port = policy.isHttpEnabled() ? 9882 : 9883;
        return new Component(Component.Type.DATANODE, null, filters.get(DATANODE_FILTER), port);
    }

    @Override
    public List<LoggerSource> getRelatedLoggers(boolean verbose, Map<String, String> filters) {
        ArrayList<LoggerSource> result = new ArrayList<LoggerSource>();
        result.add(new LoggerSource(this.getDatanodeFromFilter(filters), HddsDispatcher.class.getCanonicalName(), this.defaultLevel(verbose)));
        return result;
    }

    @Override
    public List<MetricGroupDisplay> getMetrics(Map<String, String> filters) {
        ArrayList<MetricGroupDisplay> result = new ArrayList<MetricGroupDisplay>();
        this.addProtocolMessageMetrics(result, "hdds_dispatcher", this.getDatanodeFromFilter(filters), (Object[])ContainerProtos.Type.values());
        return result;
    }

    @Override
    public String getDescription() {
        return "Datanode request dispatcher (after Ratis replication)";
    }

    @Override
    public boolean filterLog(Map<String, String> filters, String logLine) {
        return true;
    }
}

